/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.IssueUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;

public class All {
    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String defaultDescription(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return context.getParent(graph).getLabel(graph);
    }

    @SCLValue(type="a -> b -> c")
    public static Object dependencyBaseRealizationFunction(Object _graph, Object _model) throws DatabaseException {
        Resource model = (Resource)_model;
        return model;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String standardIssueSeverity(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Resource issue = property.getParent(graph).getRepresents(graph);
        Resource severity = graph.getPossibleObject(issue, ISSUE.Issue_HasSeverity);
        return (String)graph.getPossibleRelatedValue(severity, L0.HasName, (Binding)Bindings.STRING);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String standardIssueResource(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        List<Resource> contexts = IssueUtils.getContextsForProperty(graph, property);
        if (contexts.isEmpty()) {
            return "";
        }
        Resource context = contexts.get(0);
        String name = (String)graph.getPossibleRelatedValue(context, L0.HasName, (Binding)Bindings.STRING);
        return name != null && !name.isEmpty() ? name : context.toString();
    }

    private static String pathString(String uri, int startIndex) {
        StringBuilder sb = new StringBuilder(uri.length() - startIndex + 1);
        sb.append('/');
        while (true) {
            int nextSlash;
            if ((nextSlash = uri.indexOf(47, startIndex)) == -1) break;
            sb.append(URIStringUtils.unescape((String)uri.substring(startIndex, nextSlash))).append('/');
            startIndex = nextSlash + 1;
        }
        sb.append(URIStringUtils.unescape((String)uri.substring(startIndex, uri.length())));
        return sb.toString();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String standardIssuePath(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        List<Resource> contexts = IssueUtils.getContextsForProperty(graph, property);
        if (contexts.isEmpty()) {
            return "";
        }
        Resource parent = graph.getPossibleObject(contexts.get(0), L0.PartOf);
        if (parent == null) {
            return "";
        }
        Resource issueModel = Variables.getModel((ReadGraph)graph, (Variable)property);
        if (issueModel == null) {
            return "";
        }
        Resource contextModel = (Resource)graph.sync((ReadInterface)new PossibleModel(parent));
        if (contextModel == null) {
            return "";
        }
        if (issueModel.equals(contextModel)) {
            String uri = graph.getURI(parent);
            String modelURI = graph.getURI(contextModel);
            return All.pathString(uri, modelURI.length() + 1);
        }
        String uri = graph.getURI(parent);
        String modelURI = graph.getURI(graph.getRootLibrary());
        return All.pathString(uri, modelURI.length() + 1);
    }
}

