/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import java.util.Map;
import java.util.TreeMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.procore.cluster.Table;
import org.simantics.db.procore.cluster.TableFactory;
import org.simantics.db.procore.cluster.TableSizeListener;

public final class ValueTableSmall
extends Table<byte[]> {
    private static final boolean DEBUG = false;
    private TreeMap<Integer, Integer> valueMap = new TreeMap();
    private int VALUE_SIZE = 0;
    private int VALUE_OFFSET = 0;

    ValueTableSmall(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getByteFactory(), sizeListener, header, headerBase);
    }

    ValueTableSmall(TableSizeListener sizeListener, int[] header, int headerBase, byte[] bytes) {
        super(TableFactory.getByteFactory(), sizeListener, header, headerBase, bytes);
    }

    private IndexAndSize checkIndexAndGetRealIndex(int index) {
        if (index < 1) {
            throw new IllegalArgumentException("Underflow, index=" + index);
        }
        int tableSize = this.getTableSize();
        if (index >= tableSize) {
            throw new IllegalArgumentException("Overflow, index=" + index);
        }
        int i = index + this.offset;
        byte[] table = (byte[])this.getTable();
        IndexAndSize is = new IndexAndSize();
        is.size = table[i++];
        if (is.size == 0) {
            throw new IllegalArgumentException("Removed, index=" + index);
        }
        if (is.size < 0) {
            is.size = (short)((is.size & 0x7F) << 8 | table[i++] & 0xFF);
        }
        is.index = i;
        if (is.index + is.size > tableSize) {
            throw new IllegalArgumentException("Illegal size, index=" + is.index + " size=" + is.size);
        }
        return is;
    }

    public byte[] getValue(int valueIndex) {
        IndexAndSize is = this.checkIndexAndGetRealIndex(valueIndex);
        byte[] value = new byte[is.size];
        System.arraycopy(this.table, is.index, value, 0, is.size);
        return value;
    }

    char[] getString(int valueIndex) {
        IndexAndSize is = this.checkIndexAndGetRealIndex(valueIndex);
        int size = is.size - 1;
        char[] t = new char[size];
        int start = is.index;
        int i = 0;
        while (i < size) {
            t[i] = (char)((byte[])this.table)[start];
            ++i;
            ++start;
        }
        return t;
    }

    int setValue(int valueIndex, byte[] value, int offset, int length) {
        if (valueIndex != 0) {
            this.removeValue(valueIndex);
        }
        return this.createValue(value, offset, length);
    }

    int createValue(byte[] value, int voffset, int vsize) {
        if (vsize < 1 || vsize > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal internal value size=" + vsize + ".");
        }
        int size = vsize;
        size = vsize > 127 ? (size += 2) : ++size;
        int valueIndex = this.createNewElement(size);
        int i = this.checkIndexAndGetRealIndex(valueIndex, 1);
        if (vsize > 127) {
            ((byte[])this.table)[i++] = (byte)(vsize >>> 8 | 0x80);
            ((byte[])this.table)[i++] = (byte)(vsize & 0xFF);
        } else {
            ((byte[])this.table)[i++] = (byte)vsize;
        }
        System.arraycopy(value, voffset, this.table, i, vsize);
        return valueIndex;
    }

    void removeValue(int valueIndex) {
        IndexAndSize is = this.checkIndexAndGetRealIndex(valueIndex);
        int length = is.size;
        int index = is.index;
        if (is.size > 127) {
            length += 2;
            ((byte[])this.table)[(index -= 2) + 1] = 0;
        } else {
            ++length;
            --index;
        }
        ((byte[])this.table)[index] = 0;
        this.deleteOldElement(valueIndex, length);
    }

    void checkValueInit() throws DatabaseException {
        this.valueMap.clear();
        int s = this.getTableSize();
        int c = this.getTableCapacity();
        if (s < 0 || s > c) {
            throw new ValidationException("Illegal value table size=" + s + " cap=" + c);
        }
        this.VALUE_SIZE = s;
        this.VALUE_OFFSET = this.getTableBase() - 1;
    }

    void checkValue(int capacity, int index) throws DatabaseException {
        if (capacity == 0 && index == 0) {
            return;
        }
        if (capacity < 1) {
            throw new ValidationException("Illegal resource value capacity=" + capacity);
        }
        if (index < 1) {
            throw new ValidationException("Illegal resource value index=" + index);
        }
        if (this.VALUE_SIZE < capacity + index + this.VALUE_OFFSET) {
            throw new ValidationException("Illegal resource value c=" + capacity + " i=" + index + " ts=" + this.VALUE_SIZE + " off=" + this.VALUE_OFFSET);
        }
        Integer valueCap = this.valueMap.get(index);
        if (valueCap == null) {
            this.valueMap.put(index, capacity);
        } else if (capacity > valueCap) {
            this.valueMap.put(index, capacity);
        } else {
            this.valueMap.put(index, valueCap);
        }
    }

    void checkValueFini() throws DatabaseException {
        int last = 0;
        for (Map.Entry<Integer, Integer> e : this.valueMap.entrySet()) {
            int i = e.getKey();
            int c = e.getValue();
            int cur = this.VALUE_OFFSET + i;
            if (last > cur) {
                throw new ValidationException("Index error with resource value c=" + c + " i=" + i + " ts=" + this.VALUE_SIZE + " off=" + this.VALUE_OFFSET);
            }
            last = cur + c;
        }
    }

    private static final class IndexAndSize {
        int index;
        short size;

        private IndexAndSize() {
        }
    }
}

