/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.procore.cluster.TableFactoryI;
import org.simantics.db.procore.cluster.TableHeader;
import org.simantics.db.procore.cluster.TableSizeListener;

public class Table<TableType> {
    private static final int INITIAL_SIZE = 100;
    private static final int INCREMENT_SIZE = 1000;
    protected static final int ZERO_SHIFT = 1;
    private final TableHeader header;
    private final TableFactoryI<TableType> factory;
    private final TableSizeListener sizeListener;
    public int offset;
    public TableType table;

    protected Table(TableFactoryI<TableType> factory, TableSizeListener sizeListener, int[] header, int headerBase) {
        this.factory = factory;
        this.sizeListener = sizeListener;
        this.header = new TableHeader(header, headerBase);
        this.offset = -1;
        this.newTable(100);
        this.header.setSize(0);
        this.header.setCount(0);
        this.header.setOffset(this.offset);
    }

    protected Table(TableFactoryI<TableType> factory, TableSizeListener sizeListener, int[] header, int headerBase, TableType bytes) {
        this.factory = factory;
        this.sizeListener = sizeListener;
        this.header = new TableHeader(header, headerBase);
        this.offset = this.header.getOffset();
        this.table = bytes;
    }

    protected final TableType createNewTable(int capacity, int size, int count) {
        TableType t = this.table;
        this.offset = -1;
        this.newTable(capacity);
        this.sizeListener.resized();
        this.header.setSize(size);
        this.header.setCount(count);
        this.header.setOffset(this.offset);
        return t;
    }

    protected final int getTableCapacity() {
        return this.header.getCapacity();
    }

    protected final int getTableSize() {
        return this.header.getSize();
    }

    protected final int getTableCount() {
        return this.header.getCount();
    }

    protected int convertRealIndexToTableIndex(int realIndex) {
        return realIndex - this.offset;
    }

    protected final int checkIndexAndGetRealIndex(int index, int size) {
        if (index < 1) {
            throw new IllegalArgumentException("Underflow, index=" + index);
        }
        if (size > 0 && index - 1 + size > this.header.getSize()) {
            throw new IllegalArgumentException("Overflow, index=" + index + " size=" + size);
        }
        return index + this.offset;
    }

    protected final int checkIndexAndGetRealIndexEx(int index, int size) {
        if (index < 1 || size < 1) {
            throw new IllegalArgumentException("Underflow, index=" + index + " size=" + size);
        }
        if (index - 1 + size < this.header.getSize()) {
            return index + this.offset;
        }
        if (index - 1 + size == this.header.getSize()) {
            return -1;
        }
        throw new IllegalArgumentException("Underflow, index=" + index + " size=" + size);
    }

    protected final void getCopy(int index, byte[] to, int start, int size) {
        int realIndex = this.checkIndexAndGetRealIndex(index, size);
        if (size < 0) {
            throw new IllegalArgumentException("Illgal table size " + size);
        }
        System.arraycopy(this.table, realIndex, to, start, size);
    }

    protected final void getCopy(int index, char[] to, int start, int size) {
        byte[] bs = (byte[])this.table;
        start += index + this.offset + 1;
        int i = 0;
        while (i < size) {
            to[i] = (char)bs[start++];
            ++i;
        }
    }

    protected final void setCopy(int index, int size, TableType from, int fromStartIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(index, size);
        System.arraycopy(from, fromStartIndex, this.table, realIndex, size);
    }

    protected final boolean isEqual(int index, TableType to, int toStartIndex, int toSize) {
        int realIndex = this.checkIndexAndGetRealIndex(index, toSize);
        return this.factory.isEqual(this.table, realIndex, toSize, to, toStartIndex);
    }

    protected final int createNewElement(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Illegal table size " + size);
        }
        if (size == 0) {
            return 1;
        }
        int oldSize = this.header.getSize();
        int newSize = oldSize + size;
        if (newSize > this.header.getCapacity()) {
            this.realloc(newSize);
        }
        this.header.setSize(newSize);
        this.header.setCount(this.header.getCount() + 1);
        return 1 + oldSize;
    }

    protected final void deleteOldElement(int index, int size) {
        this.checkIndexAndGetRealIndex(index, size);
        this.header.setCount(this.header.getCount() - 1);
    }

    protected final TableHeader getHeader() {
        return this.header;
    }

    protected final int getTableBase() {
        return this.offset + 1;
    }

    protected final TableType getTable() {
        return this.table;
    }

    protected final int getExtra(int index) {
        return this.header.getExtra(index);
    }

    protected final void setExtra(int index, int value) {
        this.header.setExtra(index, value);
    }

    private final void realloc(int newSize) {
        int realCapacity = newSize + Math.max(1000, newSize / 10);
        TableType oldTable = this.table;
        this.newTable(realCapacity);
        this.sizeListener.resized();
        int oldBase = this.getTableBase();
        this.offset = -1;
        this.header.setOffset(this.offset);
        int oldSize = this.header.getSize();
        if (oldSize > 0) {
            System.arraycopy(oldTable, oldBase, this.table, 0, oldSize);
        }
    }

    private final void newTable(int capacity) {
        this.table = this.factory.newTable(capacity);
        this.header.setCapacity(capacity);
    }
}

