/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ExternalValueException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procore.cluster.BitUtility;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.CompleteTable;
import org.simantics.db.procore.cluster.IntHash;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.PredicateTable;
import org.simantics.db.procore.cluster.ValueTable;

final class ResourceElement {
    private static final boolean DEBUG = false;
    private static final int DESCRIPTOR_OFFSET = 0;
    private static final int VALUE_OFFSET = 1;
    private static final int STM_OFFSET = 2;
    private static final int SIZE_OF = 4;

    ResourceElement() {
    }

    static void construct(long[] table, int index) {
        int i = 0 + index;
        table[i++] = 0L;
        table[i++] = 0L;
        table[i++] = 0L;
        table[i++] = 0L;
    }

    static void destruct(long[] table, int index) {
        int i = 0 + index;
        table[i++] = 0L;
        table[i++] = 0L;
        table[i++] = 0L;
        table[i++] = 0L;
    }

    static boolean isUsed(long[] table, int index) {
        int i = 0 + index;
        if (table[i++] != 0L) {
            return true;
        }
        if (table[i++] != 0L) {
            return true;
        }
        if (table[i++] != 0L) {
            return true;
        }
        return table[i++] != 0L;
    }

    static int getSizeOf() {
        return 4;
    }

    static int getCompleteObjectRef(long[] table, int index) {
        int i = 0 + index;
        return BitUtility.getHighInt(table[i]);
    }

    static void setCompleteObjectRef(long[] table, int index, int ref) {
        int i = 0 + index;
        table[i] = BitUtility.setHighInt(table[i], ref);
    }

    static int getPredicateIndex(long[] table, int index) {
        int i = 0 + index;
        int predicateIndex = BitUtility.getLowInt(table[i]);
        assert (predicateIndex >= 0);
        return predicateIndex;
    }

    static void setPredicateIndex(long[] table, int index, int predicateIndex) {
        assert (predicateIndex >= 0);
        int i = 0 + index;
        table[i] = BitUtility.setLowInt(table[i], predicateIndex);
    }

    static int copyValue(ValueTable valueTable, long[] table, int index, byte[] byteTable, int byteSize, int byteBase, int byteCurrent) {
        int i = 1 + index;
        if (0L == table[i] || -1L == table[i]) {
            return byteCurrent;
        }
        int capacity = BitUtility.getLowInt(table[i]);
        int valueIndex = ResourceElement.getValueIndex(table, index);
        if (valueIndex == 0) {
            return byteCurrent;
        }
        valueTable.getValue(valueIndex, byteTable, byteCurrent, capacity);
        valueIndex = byteCurrent - byteBase;
        ResourceElement.setValueIndex(table, index, valueIndex);
        return byteCurrent += capacity;
    }

    static byte[] getValue(ValueTable valueTable, long[] table, int index) throws DatabaseException {
        int i = 1 + index;
        if (0L == table[i]) {
            return null;
        }
        if (-1L == table[i]) {
            throw new ExternalValueException("Value stored externally.");
        }
        int capacity = BitUtility.getLowInt(table[i]);
        byte[] t = new byte[capacity];
        int valueIndex = ResourceElement.getValueIndex(table, index);
        valueTable.getValue(valueIndex, t, 0, capacity);
        return t;
    }

    static boolean hasValue(long[] table, int index) {
        int i = 1 + index;
        return 0L != table[i];
    }

    static boolean removeValue(ValueTable valueTable, long[] table, int index) {
        int i = 1 + index;
        if (0L == table[i]) {
            return false;
        }
        if (-1L != table[i]) {
            int capacity = BitUtility.getLowInt(table[i]);
            int valueIndex = ResourceElement.getValueIndex(table, index);
            valueTable.removeValue(valueIndex, capacity);
        }
        table[i] = 0L;
        return true;
    }

    public static void setValue(ValueTable valueTable, long[] table, int index, byte[] value, int length) {
        int i = 1 + index;
        int capacity = BitUtility.getLowInt(table[i]);
        int valueIndex = ResourceElement.getValueIndex(table, index);
        if (length <= capacity) {
            valueTable.setValue(valueIndex, value, length);
            ResourceElement.setValueCapacity(table, index, length);
        } else {
            if (valueIndex != 0 && capacity > 0) {
                valueTable.removeValue(valueIndex, capacity);
            }
            valueIndex = valueTable.createValue(value, 0, length);
            capacity = length;
            ResourceElement.setValueCapacityAndIndex(table, index, capacity, valueIndex);
        }
    }

    public static boolean isValueEx(ValueTable valueTable, long[] table, int index) {
        int i = 1 + index;
        return -1L == table[i];
    }

    public static void setValueEx(ValueTable valueTable, long[] table, int index) {
        int i = 1 + index;
        if (-1L == table[i]) {
            return;
        }
        if (0L != table[i]) {
            int capacity = BitUtility.getLowInt(table[i]);
            int valueIndex = ResourceElement.getValueIndex(table, index);
            valueTable.removeValue(valueIndex, capacity);
        }
        table[i] = -1L;
    }

    static void getValueCapacityAndIndex(ValueData vd, long[] table, int index) {
        int i = 1 + index;
        vd.capacity = BitUtility.getLowInt(table[i]);
        vd.index = ResourceElement.getValueIndex(table, index);
    }

    private static int getValueIndex(long[] table, int index) {
        int i = 1 + index;
        return BitUtility.getHighInt(table[i]);
    }

    private static void setValueIndex(long[] table, int index, int valueIndex) {
        int i = 1 + index;
        table[i] = BitUtility.setHighInt(table[i], valueIndex);
    }

    private static void setValueCapacity(long[] table, int index, int capacity) {
        int i = 1 + index;
        table[i] = BitUtility.setLowInt(table[i], capacity);
    }

    private static void setValueCapacityAndIndex(long[] table, int index, int capacity, int valueIndex) {
        int i = 1 + index;
        table[i] = BitUtility.setLowAndHighInt(table[i], capacity, valueIndex);
    }

    public static <Context> boolean foreachPredicate(long[] table, int index, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support, IntHash.Modifier modifier, CompleteTable ct) throws DatabaseException {
        int p2;
        int key;
        boolean broken;
        ClusterI.CompleteTypeEnum completeType;
        boolean broken2;
        int completeRef = ResourceElement.getCompleteObjectRef(table, index);
        if (completeRef != 0 && (ClusterTraits.completeReferenceIsMultiple(completeRef) ? (broken2 = ct.foreachPredicate(completeRef, procedure, context, support, modifier)) : ClusterI.CompleteTypeEnum.NotComplete != (completeType = ClusterTraits.completeReferenceGetType(completeRef)) && (broken = procedure.execute(context, key = ClusterTraitsBase.getCompleteTypeResourceKeyFromEnum((ClusterI.CompleteTypeEnum)completeType), 0)))) {
            return true;
        }
        if (ResourceElement.getPredicateIndex(table, index) != 0) {
            return false;
        }
        int i = 2 + index;
        int p1 = BitUtility.getHighInt(table[i]);
        if (p1 == 0) {
            return false;
        }
        int externalRef = modifier == null ? p1 : modifier.execute(p1);
        if (procedure.execute(context, externalRef, 0)) {
            return true;
        }
        if ((p2 = BitUtility.getHighInt(table[++i])) == 0 || p1 == p2) {
            return false;
        }
        externalRef = modifier == null ? p2 : modifier.execute(p2);
        return procedure.execute(context, externalRef, 0);
    }

    public static int getSingleObject(long[] table, int index, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, IntHash.Modifier modifier) throws DatabaseException {
        int p2;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            int completeRef = ResourceElement.getCompleteObjectRef(table, index);
            if (completeRef == 0) {
                return 0;
            }
            if (ClusterTraits.completeReferenceIsMultiple(completeRef)) {
                class ForeachObject
                implements ClusterI.ObjectProcedure<Integer> {
                    private final /* synthetic */ ClusterI.CompleteTypeEnum val$pCompleteType;
                    private final /* synthetic */ IntHash.Modifier val$modifier;

                    ForeachObject(ClusterI.CompleteTypeEnum completeTypeEnum, IntHash.Modifier modifier) {
                        this.val$pCompleteType = completeTypeEnum;
                        this.val$modifier = modifier;
                    }

                    public boolean execute(Integer context, int completeRef) throws DatabaseException {
                        ClusterI.CompleteTypeEnum oCompleteType = ClusterTraits.completeReferenceGetType(completeRef);
                        if (this.val$pCompleteType == oCompleteType) {
                            if (context != 0) {
                                context = 0;
                                return true;
                            }
                            int clusterIndex = ClusterTraits.completeReferenceGetForeignIndex(completeRef);
                            int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex(completeRef);
                            if (clusterIndex == 0) {
                                context = this.val$modifier.execute(resourceIndex);
                            } else {
                                int externalRef = ClusterTraits.createForeignReference(clusterIndex, resourceIndex);
                                context = this.val$modifier.execute(externalRef);
                            }
                        }
                        return true;
                    }

                    public boolean found() {
                        throw new UnsupportedOperationException();
                    }
                }
                ForeachObject t = new ForeachObject(pCompleteType, modifier);
                Integer c = 0;
                ct.foreachComplete(completeRef, t, c, support, modifier);
                return c;
            }
            ClusterI.CompleteTypeEnum completeType = ClusterTraits.completeReferenceGetType(completeRef);
            if (pCompleteType != completeType) {
                return 0;
            }
            int clusterIndex = ClusterTraits.completeReferenceGetForeignIndex(completeRef);
            int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex(completeRef);
            if (clusterIndex == 0) {
                return modifier.execute(resourceIndex);
            }
            int externalRef = ClusterTraits.createForeignReference(clusterIndex, resourceIndex);
            return modifier.execute(externalRef);
        }
        int i = 2 + index;
        int p1 = BitUtility.getHighInt(table[i]);
        if (p1 == 0) {
            return 0;
        }
        int result = 0;
        if (pRef == p1) {
            int o1 = BitUtility.getLowInt(table[i]);
            result = modifier.execute(o1);
        }
        if ((p2 = BitUtility.getHighInt(table[++i])) == 0 || pRef != p2) {
            return result;
        }
        if (result != 0) {
            return -1;
        }
        int o2 = BitUtility.getLowInt(table[i]);
        return modifier.execute(o2);
    }

    public static void foreachObject(long[] table, int index, ReadGraphImpl graph, AsyncMultiProcedure<Resource> procedure, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, IntHash.Modifier modifier) throws DatabaseException {
        long l2;
        int p2;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            int completeRef = ResourceElement.getCompleteObjectRef(table, index);
            if (completeRef == 0) {
                procedure.finished((AsyncReadGraph)graph);
                return;
            }
            if (ClusterTraits.completeReferenceIsMultiple(completeRef)) {
                class ForeachObject
                implements ClusterI.ObjectProcedure<Object> {
                    private final /* synthetic */ ClusterI.CompleteTypeEnum val$pCompleteType;
                    private final /* synthetic */ AsyncMultiProcedure val$procedure;
                    private final /* synthetic */ ReadGraphImpl val$graph;
                    private final /* synthetic */ IntHash.Modifier val$modifier;

                    ForeachObject(ClusterI.CompleteTypeEnum completeTypeEnum, AsyncMultiProcedure asyncMultiProcedure, ReadGraphImpl readGraphImpl, IntHash.Modifier modifier) {
                        this.val$pCompleteType = completeTypeEnum;
                        this.val$procedure = asyncMultiProcedure;
                        this.val$graph = readGraphImpl;
                        this.val$modifier = modifier;
                    }

                    public boolean execute(Object context, int completeRef) throws DatabaseException {
                        ClusterI.CompleteTypeEnum oCompleteType = ClusterTraits.completeReferenceGetType(completeRef);
                        if (this.val$pCompleteType == oCompleteType) {
                            int clusterIndex = ClusterTraits.completeReferenceGetForeignIndex(completeRef);
                            int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex(completeRef);
                            if (clusterIndex == 0) {
                                this.val$procedure.execute((AsyncReadGraph)this.val$graph, (Object)new ResourceImpl(this.val$graph.getResourceSupport(), this.val$modifier.execute(resourceIndex)));
                            } else {
                                int externalRef = ClusterTraits.createForeignReference(clusterIndex, resourceIndex);
                                this.val$procedure.execute((AsyncReadGraph)this.val$graph, (Object)new ResourceImpl(this.val$graph.getResourceSupport(), this.val$modifier.execute(externalRef)));
                            }
                        }
                        return false;
                    }

                    public boolean found() {
                        throw new UnsupportedOperationException();
                    }
                }
                ForeachObject t = new ForeachObject(pCompleteType, procedure, graph, modifier);
                ct.foreachComplete(completeRef, t, null, support, modifier);
                procedure.finished((AsyncReadGraph)graph);
                return;
            }
            ClusterI.CompleteTypeEnum completeType = ClusterTraits.completeReferenceGetType(completeRef);
            if (pCompleteType != completeType) {
                procedure.finished((AsyncReadGraph)graph);
                return;
            }
            int clusterIndex = ClusterTraits.completeReferenceGetForeignIndex(completeRef);
            int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex(completeRef);
            if (clusterIndex == 0) {
                procedure.execute((AsyncReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(resourceIndex)));
            } else {
                int externalRef = ClusterTraits.createForeignReference(clusterIndex, resourceIndex);
                procedure.execute((AsyncReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(externalRef)));
            }
            procedure.finished((AsyncReadGraph)graph);
            return;
        }
        int i = 2 + index;
        long l = table[i];
        int p1 = (int)(l >>> 32);
        if (p1 == 0) {
            procedure.finished((AsyncReadGraph)graph);
            return;
        }
        if (pRef == p1) {
            int o1 = (int)l;
            procedure.execute((AsyncReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(o1)));
        }
        if (pRef != (p2 = (int)((l2 = table[++i]) >>> 32))) {
            procedure.finished((AsyncReadGraph)graph);
            return;
        }
        int o2 = (int)l2;
        procedure.execute((AsyncReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(o2)));
        procedure.finished((AsyncReadGraph)graph);
    }

    public static <C> void foreachObject(long[] table, int index, ReadGraphImpl graph, C context, AsyncContextMultiProcedure<C, Resource> procedure, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, IntHash.Modifier modifier) throws DatabaseException {
        long l2;
        int p2;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            int completeRef = ResourceElement.getCompleteObjectRef(table, index);
            if (completeRef == 0) {
                procedure.finished((AsyncReadGraph)graph);
                return;
            }
            if (ClusterTraits.completeReferenceIsMultiple(completeRef)) {
                class ForeachObject
                implements ClusterI.ObjectProcedure<Object> {
                    private final /* synthetic */ ClusterI.CompleteTypeEnum val$pCompleteType;
                    private final /* synthetic */ AsyncContextMultiProcedure val$procedure;
                    private final /* synthetic */ ReadGraphImpl val$graph;
                    private final /* synthetic */ Object val$context;
                    private final /* synthetic */ IntHash.Modifier val$modifier;

                    ForeachObject(ClusterI.CompleteTypeEnum completeTypeEnum, AsyncContextMultiProcedure asyncContextMultiProcedure, ReadGraphImpl readGraphImpl, Object object, IntHash.Modifier modifier) {
                        this.val$pCompleteType = completeTypeEnum;
                        this.val$procedure = asyncContextMultiProcedure;
                        this.val$graph = readGraphImpl;
                        this.val$context = object;
                        this.val$modifier = modifier;
                    }

                    public boolean execute(Object _context, int completeRef) throws DatabaseException {
                        ClusterI.CompleteTypeEnum oCompleteType = ClusterTraits.completeReferenceGetType(completeRef);
                        if (this.val$pCompleteType == oCompleteType) {
                            int clusterIndex = ClusterTraits.completeReferenceGetForeignIndex(completeRef);
                            int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex(completeRef);
                            if (clusterIndex == 0) {
                                this.val$procedure.execute((AsyncReadGraph)this.val$graph, this.val$context, (Object)new ResourceImpl(this.val$graph.getResourceSupport(), this.val$modifier.execute(resourceIndex)));
                            } else {
                                int externalRef = ClusterTraits.createForeignReference(clusterIndex, resourceIndex);
                                this.val$procedure.execute((AsyncReadGraph)this.val$graph, this.val$context, (Object)new ResourceImpl(this.val$graph.getResourceSupport(), this.val$modifier.execute(externalRef)));
                            }
                        }
                        return false;
                    }

                    public boolean found() {
                        throw new UnsupportedOperationException();
                    }
                }
                ForeachObject t = new ForeachObject(pCompleteType, procedure, graph, context, modifier);
                ct.foreachComplete(completeRef, t, null, support, modifier);
                procedure.finished((AsyncReadGraph)graph);
                return;
            }
            ClusterI.CompleteTypeEnum completeType = ClusterTraits.completeReferenceGetType(completeRef);
            if (pCompleteType != completeType) {
                procedure.finished((AsyncReadGraph)graph);
                return;
            }
            int clusterIndex = ClusterTraits.completeReferenceGetForeignIndex(completeRef);
            int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex(completeRef);
            if (clusterIndex == 0) {
                procedure.execute((AsyncReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(resourceIndex)));
            } else {
                int externalRef = ClusterTraits.createForeignReference(clusterIndex, resourceIndex);
                procedure.execute((AsyncReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(externalRef)));
            }
            procedure.finished((AsyncReadGraph)graph);
            return;
        }
        int i = 2 + index;
        long l = table[i];
        int p1 = (int)(l >>> 32);
        if (p1 == 0) {
            procedure.finished((AsyncReadGraph)graph);
            return;
        }
        if (pRef == p1) {
            int o1 = (int)l;
            procedure.execute((AsyncReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(o1)));
        }
        if (pRef != (p2 = (int)((l2 = table[++i]) >>> 32))) {
            procedure.finished((AsyncReadGraph)graph);
            return;
        }
        int o2 = (int)l2;
        procedure.execute((AsyncReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), modifier.execute(o2)));
        procedure.finished((AsyncReadGraph)graph);
    }

    public static <Context> boolean foreachObject(long[] table, int index, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, IntHash.Modifier modifier, int pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct) throws DatabaseException {
        int p2;
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            int completeRef = ResourceElement.getCompleteObjectRef(table, index);
            if (completeRef == 0) {
                return false;
            }
            if (ClusterTraits.completeReferenceIsMultiple(completeRef)) {
                return ct.foreachObject(completeRef, procedure, context, support, modifier, pCompleteType);
            }
            ClusterI.CompleteTypeEnum completeType = ClusterTraits.completeReferenceGetType(completeRef);
            if (pCompleteType != completeType) {
                return false;
            }
            int clusterIndex = ClusterTraits.completeReferenceGetForeignIndex(completeRef);
            int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex(completeRef);
            if (clusterIndex == 0) {
                int externalRef = modifier == null ? resourceIndex : modifier.execute(resourceIndex);
                if (procedure.execute(context, externalRef)) {
                    return true;
                }
            } else {
                int externalRef = ClusterTraits.createForeignReference(clusterIndex, resourceIndex);
                if (modifier != null) {
                    externalRef = modifier.execute(externalRef);
                }
                if (procedure.execute(context, externalRef)) {
                    return true;
                }
            }
            return false;
        }
        int i = 2 + index;
        int p1 = BitUtility.getHighInt(table[i]);
        if (p1 == 0) {
            return false;
        }
        if (pRef == p1) {
            int o1 = BitUtility.getLowInt(table[i]);
            int externalRef = modifier == null ? o1 : modifier.execute(o1);
            if (procedure.execute(context, externalRef)) {
                return true;
            }
        }
        if ((p2 = BitUtility.getHighInt(table[++i])) == 0 || pRef != p2) {
            return false;
        }
        int o2 = BitUtility.getLowInt(table[i]);
        int externalRef = modifier == null ? o2 : modifier.execute(o2);
        return procedure.execute(context, externalRef);
    }

    static boolean isEmpty(long[] table, int index) {
        return ResourceElement.getStatementCount(table, index) == 0 && !ResourceElement.hasValue(table, index);
    }

    static int getStatementCount(long[] table, int index) {
        int i = 2 + index;
        int p1 = BitUtility.getHighInt(table[i]);
        int p2 = BitUtility.getLowInt(table[++i]);
        if (p1 == 0) {
            return 0;
        }
        if (p2 == 0) {
            return 1;
        }
        int predicateIndex = ResourceElement.getPredicateIndex(table, index);
        if (predicateIndex == 0) {
            return 2;
        }
        return 3;
    }

    private static int makeCompleteObjectRef(int oRef, ClusterI.CompleteTypeEnum completeType) {
        int ref;
        if (oRef > 0) {
            int resourceIndex = oRef;
            int clusterIndex = 0;
            ref = ClusterTraits.completeReferenceMake(completeType.getValue(), resourceIndex, clusterIndex);
        } else {
            assert (oRef < 0);
            assert (!ClusterTraits.isFlat(oRef));
            ref = completeType.getValue() << 30 | oRef & 0x3FFFFFFF;
        }
        return ref;
    }

    static int addStatement(long[] table, int index, int pRef, int oRef, PredicateTable pt, ObjectTable ot, ClusterI.CompleteTypeEnum completeType, CompleteTable ct) throws DatabaseException {
        assert (pRef != 0);
        assert (oRef != 0);
        if (ClusterI.CompleteTypeEnum.NotComplete != completeType) {
            int cRef = ResourceElement.makeCompleteObjectRef(oRef, completeType);
            int ctr = ResourceElement.getCompleteObjectRef(table, index);
            if (ctr == 0) {
                ResourceElement.setCompleteObjectRef(table, index, cRef);
            } else {
                int nRef;
                if (ctr == cRef) {
                    return -1;
                }
                if (ClusterTraits.completeReferenceIsMultiple(ctr)) {
                    nRef = ct.addComplete(ctr, cRef);
                    if (nRef == 0) {
                        return -1;
                    }
                } else {
                    nRef = ct.createCompleteArraySet(ctr, cRef);
                }
                ResourceElement.setCompleteObjectRef(table, index, nRef);
            }
            return 0;
        }
        int i = 2 + index;
        int p1 = BitUtility.getHighInt(table[i]);
        int o1 = BitUtility.getLowInt(table[i]);
        if (p1 == 0) {
            table[i] = BitUtility.setLowAndHighInt(table[i], oRef, pRef);
            return 0;
        }
        if (p1 == pRef && o1 == oRef) {
            return -1;
        }
        int p2 = BitUtility.getHighInt(table[++i]);
        int o2 = BitUtility.getLowInt(table[i]);
        if (p2 == 0) {
            table[i] = BitUtility.setLowAndHighInt(table[i], oRef, pRef);
            return 0;
        }
        if (p2 == pRef && o2 == oRef) {
            return -1;
        }
        int predicateIndex = ResourceElement.getPredicateIndex(table, index);
        if (predicateIndex == 0) {
            if (p1 == p2) {
                int objectIndex = ot.createObjectSet(o1, o2);
                assert (objectIndex != 0);
                int[] os = new int[]{ClusterTraits.statementIndexMake(objectIndex)};
                int[] ps = new int[]{p1};
                predicateIndex = pt.createPredicateSet(ps, os);
            } else {
                int[] os = new int[]{o1, o2};
                int[] ps = new int[]{p1, p2};
                predicateIndex = pt.createPredicateSet(ps, os);
            }
            assert (predicateIndex != 0);
            ResourceElement.setPredicateIndex(table, index, predicateIndex);
        }
        assert (predicateIndex != 0);
        return predicateIndex;
    }

    static boolean removeStatement(long[] table, int index, int pRef, int oRef, ClusterI.CompleteTypeEnum completeType, CompleteTable ct) throws DatabaseException {
        int completeRef;
        assert (pRef != 0);
        assert (oRef != 0);
        if (completeType != ClusterI.CompleteTypeEnum.NotComplete && (completeRef = ResourceElement.getCompleteObjectRef(table, index)) != 0) {
            ClusterI.CompleteTypeEnum completeType2 = ClusterTraits.completeReferenceGetType(completeRef);
            if (completeType == completeType2) {
                int clusterIndex = ClusterTraits.completeReferenceGetForeignIndex(completeRef);
                int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex(completeRef);
                if (clusterIndex == 0) {
                    if (oRef == resourceIndex) {
                        ResourceElement.setCompleteObjectRef(table, index, 0);
                        return true;
                    }
                } else {
                    int externalRef = ClusterTraits.createForeignReference(clusterIndex, resourceIndex);
                    if (oRef == externalRef) {
                        ResourceElement.setCompleteObjectRef(table, index, 0);
                        return true;
                    }
                }
            } else if (completeType2 == ClusterI.CompleteTypeEnum.NotComplete) {
                int newSize;
                int cRef = ResourceElement.makeCompleteObjectRef(oRef, completeType);
                int oldSize = ct.getCompleteSetSize(completeRef);
                if (oldSize == (newSize = ct.removeComplete(completeRef, cRef))) {
                    return false;
                }
                if (newSize == 1) {
                    cRef = ct.removeLast(completeRef);
                    ResourceElement.setCompleteObjectRef(table, index, cRef);
                }
                return true;
            }
        }
        int i = 2 + index;
        int p1 = BitUtility.getHighInt(table[i]);
        int o1 = BitUtility.getLowInt(table[i]);
        if (p1 == 0) {
            return false;
        }
        if (p1 == pRef && o1 == oRef) {
            table[i] = table[i + 1];
            table[i + 1] = 0L;
            return true;
        }
        int p2 = BitUtility.getHighInt(table[++i]);
        int o2 = BitUtility.getLowInt(table[i]);
        if (p2 == 0) {
            return false;
        }
        if (p2 == pRef && o2 == oRef) {
            table[i] = 0L;
            return true;
        }
        return false;
    }

    static class ValueData {
        int capacity;
        int index;

        ValueData() {
        }
    }
}

