/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.IntHash;
import org.simantics.db.procore.cluster.IntHashTrait;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.Table;
import org.simantics.db.procore.cluster.TableFactory;
import org.simantics.db.procore.cluster.TableIntAllocatorAdapter;
import org.simantics.db.procore.cluster.TableIntArraySet2;
import org.simantics.db.procore.cluster.TableIntSet2;
import org.simantics.db.procore.cluster.TableSizeListener;

final class PredicateTable
extends Table<int[]> {
    final TableIntAllocatorAdapter allocator = new TableIntAllocatorAdapter(this);
    private TIntHashSet checkIndexSet = null;

    PredicateTable(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getIntFactory(), sizeListener, header, headerBase);
    }

    PredicateTable(TableSizeListener sizeListener, int[] header, int headerBase, int[] ints) {
        super(TableFactory.getIntFactory(), sizeListener, header, headerBase, ints);
    }

    int createPredicateSet(int[] ps, int[] os) throws DatabaseException {
        int hashBase = TableIntArraySet2.create(ps, os, this.allocator);
        return this.convertRealIndexToTableIndex(hashBase);
    }

    void deletePredicateSet(int predicateIndex) {
        int hashBase = this.checkIndexAndGetRealIndex(predicateIndex, 0);
        if (TableIntArraySet2.isArraySet((int[])this.getTable(), hashBase)) {
            int capacity = TableIntArraySet2.getAllocatedSize((int[])this.getTable(), hashBase);
            int elementIndex = predicateIndex - 1;
            this.deleteOldElement(elementIndex, capacity);
        } else {
            int capacity = TableIntSet2.getAllocatedSize((int[])this.getTable(), hashBase);
            int elementIndex = predicateIndex - 4;
            this.deleteOldElement(elementIndex, capacity);
        }
    }

    int getPredicateSetSize(int predicateIndex) {
        int hashBase = this.checkIndexAndGetRealIndex(predicateIndex, 0);
        if (TableIntArraySet2.isArraySet((int[])this.getTable(), hashBase)) {
            return TableIntArraySet2.getSize((int[])this.getTable(), hashBase);
        }
        return TableIntSet2.getSize((int[])this.getTable(), hashBase);
    }

    int getObjectIndex(int predicateIndex, int pRef) {
        int hashBase = this.checkIndexAndGetRealIndex(predicateIndex, 0);
        if (TableIntArraySet2.isArraySet((int[])this.table, hashBase)) {
            return TableIntArraySet2.get((int[])this.table, hashBase, pRef);
        }
        return TableIntSet2.get((int[])this.table, hashBase, pRef);
    }

    private int addPredicateArray(int predicateIndex, int hashBase, int pReference, int oReference, ObjectTable ot) throws DatabaseException {
        int newHashBase;
        int objectIndex = TableIntArraySet2.get((int[])this.getTable(), hashBase, pReference);
        if (objectIndex == 0) {
            newHashBase = TableIntArraySet2.addInt((int[])this.getTable(), hashBase, pReference, oReference, this.allocator);
        } else if (ClusterTraits.statementIndexIsDirect(objectIndex)) {
            int oRef = objectIndex;
            if (oRef == oReference) {
                return 0;
            }
            objectIndex = ot.createObjectSet(oRef, oReference);
            assert (objectIndex != 0);
            int newObjectIndex = ClusterTraits.statementIndexMake(objectIndex);
            newHashBase = TableIntArraySet2.addInt((int[])this.getTable(), hashBase, pReference, newObjectIndex, this.allocator);
        } else {
            int newObjectIndex = ot.addObject(ClusterTraits.statementIndexGet(objectIndex), oReference);
            if (newObjectIndex == 0) {
                return 0;
            }
            newObjectIndex = ClusterTraits.statementIndexMake(newObjectIndex);
            newHashBase = TableIntArraySet2.addInt((int[])this.getTable(), hashBase, pReference, newObjectIndex, this.allocator);
            if (newHashBase == 0) {
                return hashBase;
            }
        }
        int TABLE_SIZE = TableIntArraySet2.getSize((int[])this.getTable(), newHashBase);
        if (TABLE_SIZE > 5) {
            return this.convertToPredicateSet(predicateIndex, newHashBase);
        }
        return newHashBase;
    }

    private int convertToPredicateSet(int predicateIndex, int hashBase) {
        TableIntArraySet2.Tables tables = TableIntArraySet2.getInts((int[])this.getTable(), hashBase);
        this.deletePredicateSet(predicateIndex);
        int newHashBase = TableIntSet2.create(tables.keys, tables.vals, this.allocator);
        assert (newHashBase != 0);
        return newHashBase;
    }

    private int addPredicateSet(int hashBase, int pReference, int oReference, ObjectTable ot) throws DatabaseException {
        int newHashBase;
        int objectIndex = TableIntSet2.get((int[])this.getTable(), hashBase, pReference);
        if (objectIndex == 0) {
            newHashBase = TableIntSet2.addInt((int[])this.getTable(), hashBase, pReference, oReference, this.allocator);
        } else if (ClusterTraits.statementIndexIsDirect(objectIndex)) {
            int oRef = objectIndex;
            if (oRef == oReference) {
                return 0;
            }
            objectIndex = ot.createObjectSet(oRef, oReference);
            assert (objectIndex != 0);
            int newObjectIndex = ClusterTraits.statementIndexMake(objectIndex);
            newHashBase = TableIntSet2.addInt((int[])this.getTable(), hashBase, pReference, newObjectIndex, this.allocator);
            assert (newHashBase != 0);
        } else {
            int newObjectIndex = ot.addObject(ClusterTraits.statementIndexGet(objectIndex), oReference);
            if (newObjectIndex == 0) {
                return 0;
            }
            int stmIndex = ClusterTraits.statementIndexMake(newObjectIndex);
            newHashBase = TableIntSet2.addInt((int[])this.getTable(), hashBase, pReference, stmIndex, this.allocator);
            if (newHashBase == 0) {
                return hashBase;
            }
        }
        return newHashBase;
    }

    int addPredicate(int predicateIndex, int pReference, int oReference, ObjectTable ot) throws DatabaseException {
        int hashBase = this.checkIndexAndGetRealIndex(predicateIndex, 0);
        int newHashBase = TableIntArraySet2.isArraySet((int[])this.getTable(), hashBase) ? this.addPredicateArray(predicateIndex, hashBase, pReference, oReference, ot) : this.addPredicateSet(hashBase, pReference, oReference, ot);
        if (newHashBase == 0) {
            return 0;
        }
        return this.convertRealIndexToTableIndex(newHashBase);
    }

    Status removePredicate(int predicateIndex, int pReference, int oReference, ObjectTable ot) throws DatabaseException {
        int hashBase = this.checkIndexAndGetRealIndex(predicateIndex, 0);
        int[] table = (int[])this.getTable();
        if (TableIntArraySet2.isArraySet(table, hashBase)) {
            int objectIndex = TableIntArraySet2.get(table, hashBase, pReference);
            if (objectIndex == 0) {
                return Status.NothingRemoved;
            }
            if (ClusterTraits.statementIndexIsDirect(objectIndex)) {
                int oRef = objectIndex;
                if (oRef != oReference) {
                    return Status.NothingRemoved;
                }
                if (TableIntArraySet2.removeInt(table, hashBase, pReference)) {
                    return Status.PredicateRemoved;
                }
                throw new DatabaseException("Internal error during remove.");
            }
            int oIndex = ClusterTraits.statementIndexGet(objectIndex);
            int nO = ot.getObjectSetSize(oIndex);
            if (nO < 1) {
                throw new DatabaseException("Illegal object set size=" + nO);
            }
            int nObject = ot.removeObject(objectIndex, oReference);
            if (nObject == 0) {
                ot.deleteObjectSet(oIndex);
                if (TableIntArraySet2.removeInt(table, hashBase, pReference)) {
                    return Status.PredicateRemoved;
                }
                throw new DatabaseException("Internal error during remove (2).");
            }
            if (nO == nObject) {
                return Status.NothingRemoved;
            }
            return Status.ObjectRemoved;
        }
        int objectIndex = TableIntSet2.get(table, hashBase, pReference);
        if (objectIndex == 0) {
            return Status.NothingRemoved;
        }
        if (ClusterTraits.statementIndexIsDirect(objectIndex)) {
            int oRef = objectIndex;
            if (oRef != oReference) {
                return Status.NothingRemoved;
            }
            if (TableIntSet2.removeInt(table, hashBase, pReference)) {
                return Status.PredicateRemoved;
            }
            throw new DatabaseException("Internal error during remove (3).");
        }
        int oIndex = ClusterTraits.statementIndexGet(objectIndex);
        int nO = ot.getObjectSetSize(oIndex);
        if (nO < 1) {
            throw new DatabaseException("Illegal object set size=" + nO);
        }
        int nObject = ot.removeObject(objectIndex, oReference);
        if (nObject == 0) {
            ot.deleteObjectSet(oIndex);
            if (TableIntSet2.removeInt(table, hashBase, pReference)) {
                return Status.PredicateRemoved;
            }
            throw new DatabaseException("Internal error during remove (4).");
        }
        if (nO == nObject) {
            return Status.NothingRemoved;
        }
        return Status.ObjectRemoved;
    }

    public <Context> boolean foreachPredicate(int predicateIndex, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support, IntHash.Modifier modifier) throws DatabaseException {
        int hashBase = this.checkIndexAndGetRealIndex(predicateIndex, 0);
        boolean ret = TableIntArraySet2.isArraySet((int[])this.getTable(), hashBase) ? TableIntArraySet2.foreachInt((int[])this.getTable(), hashBase, procedure, context, modifier) : TableIntSet2.foreachInt((int[])this.getTable(), hashBase, procedure, context, modifier);
        return ret;
    }

    private void checkEntry(ClusterImpl cluster, int[] table, int index) throws DatabaseException {
        assert (ClusterTraits.statementIndexIsDirect(table[index]));
        int dr = table[index];
        cluster.checkDirectReference(dr);
        assert (table[index + 1] != 0);
        if (ClusterTraits.statementIndexIsDirect(table[index + 1])) {
            cluster.checkDirectReference(table[index + 1]);
        } else {
            cluster.checkObjectSetReference(table[index + 1]);
        }
    }

    void check(ClusterImpl cluster) throws DatabaseException {
        if (this.checkIndexSet == null) {
            this.checkIndexSet = new TIntHashSet();
        } else {
            this.checkIndexSet.clear();
        }
        int count = 0;
        int[] table = (int[])this.getTable();
        int ps = this.getHeader().getOffset() + 1;
        int pe = ps + this.getTableSize();
        int p = ps;
        while (p < pe) {
            int cap;
            if (table[cap = p++] >= 0) {
                int use = p++;
                int fre = p++;
                int max = p++;
                assert (table[cap] >= table[use] + table[fre]);
                assert (table[max] == table[cap] >> 1);
                assert (table[max] + 1 >= table[use]);
                this.checkIndexSet.add(p - ps);
                int e = p + table[cap] * 2;
                while (p < e) {
                    if (!IntHashTrait.isFull(table[p])) {
                        assert (table[p + 1] == 0);
                    } else {
                        this.checkEntry(cluster, table, p);
                    }
                    p += 2;
                }
            } else {
                int size = -table[cap];
                assert (size > 0);
                boolean free = false;
                this.checkIndexSet.add(p - ps);
                int e = p + size * 2;
                while (p < e) {
                    if (free) {
                        assert (table[p] == 0);
                        assert (table[p + 1] == 0);
                    } else if (table[p] == 0) {
                        assert (table[p + 1] == 0);
                        free = true;
                    } else {
                        this.checkEntry(cluster, table, p);
                    }
                    p += 2;
                }
            }
            ++count;
        }
        assert (this.getHeader().getCount() <= count);
    }

    final void checkPredicateSetIndex(ClusterImpl cluster, int i) throws DatabaseException {
        if (this.checkIndexSet == null) {
            this.check(cluster);
        }
        if (!this.checkIndexSet.contains(i - 1)) {
            throw new ValidationException("Illegal predicate set index=" + i);
        }
    }

    void printDebugInfo() {
        int[] table = (int[])this.getTable();
        int ps = this.getHeader().getOffset() + 1;
        int pe = ps + this.getTableSize();
        TIntIntHashMap stat = new TIntIntHashMap();
        TIntIntHashMap stat2 = new TIntIntHashMap();
        int p = ps;
        while (p < pe) {
            int cap;
            if (table[cap = p++] >= 0) {
                int use = p++;
                int fre = p++;
                int max = p++;
                assert (table[cap] >= table[use] + table[fre]);
                assert (table[max] == table[cap] >> 1);
                p += table[cap] * 2;
                int val = stat.get(table[use]) + 1;
                stat.put(table[use], val);
                continue;
            }
            int size = -table[cap];
            int val = stat2.get(size) + 1;
            stat2.put(size, val);
            p += size * 2;
        }
        stat.forEachEntry(new TIntIntProcedure(){

            public boolean execute(int a, int b) {
                System.out.println("predicate set capacity " + a + " instance count " + b);
                return true;
            }
        });
        stat2.forEachEntry(new TIntIntProcedure(){

            public boolean execute(int a, int b) {
                System.out.println("predicate array set capacity " + a + " instance count " + b);
                return true;
            }
        });
    }

    static enum Status {
        NothingRemoved,
        ObjectRemoved,
        PredicateRemoved;

    }
}

