/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.PrimeFinder;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.procore.cluster.IntAllocatorI;
import org.simantics.db.procore.cluster.IntHash;
import org.simantics.db.procore.cluster.IntHashTrait;

final class IntHash2
extends IntHashTrait {
    static final int HeaderSize = 4;
    private static final int REAL_SIZE = -4;
    private static final int USED_SIZE = -3;
    private static final int FREE_SIZE = -2;
    private static final int MAX_SIZE = -1;

    IntHash2() {
    }

    public static int getRealSize(int[] table, int hashBase) {
        return table[hashBase + -4];
    }

    private static void setRealSize(int[] table, int hashBase, int realSize) {
        assert (realSize > 0);
        table[hashBase + -4] = realSize;
    }

    public static int getUsedSize(int[] table, int hashBase) {
        return table[hashBase + -3];
    }

    static void setUsedSize(int[] table, int hashBase, int usedSize) {
        assert (usedSize >= 0);
        table[hashBase + -3] = usedSize;
    }

    static int decUsedSize(int[] table, int hashBase) {
        int n = hashBase + -3;
        table[n] = table[n] - 1;
        return table[hashBase + -3];
    }

    static int incUsedSize(int[] table, int hashBase) {
        int n = hashBase + -3;
        table[n] = table[n] + 1;
        return table[hashBase + -3];
    }

    static void setUsedAndRealSize(int[] table, int hashBase, int used, int real) {
        IntHash2.setUsedSize(table, hashBase, used);
        IntHash2.setRealSize(table, hashBase, real);
    }

    static int getFreeSize(int[] table, int hashBase) {
        return table[hashBase + -2];
    }

    static void setFreeSize(int[] table, int hashBase, int freeSize) {
        assert (freeSize >= 0);
        table[hashBase + -2] = freeSize;
    }

    static void decFreeSize(int[] table, int hashBase) {
        int n = hashBase + -2;
        table[n] = table[n] - 1;
    }

    static int getMaxSize(int[] table, int hashBase) {
        return table[hashBase + -1];
    }

    static void setMaxSize(int[] table, int hashBase, int maxSize) {
        assert (maxSize > 0);
        table[hashBase + -1] = maxSize;
    }

    static void setMaxAndFreeSize(int[] table, int hashBase, int max, int free) {
        IntHash2.setMaxSize(table, hashBase, max);
        IntHash2.setFreeSize(table, hashBase, free);
    }

    public static int getAllocatedSize(int[] table, int hashBase) {
        return IntHash2.getRealSize(table, hashBase) * 2 + 4;
    }

    public static int create(int[] keys, int[] vals, IntAllocatorI allocator) {
        assert (keys.length > 0);
        assert (keys.length == vals.length);
        int desiredSize = keys.length;
        int hashBase = IntHash2.create(desiredSize, allocator);
        int i = 0;
        while (i < desiredSize) {
            hashBase = IntHash2.add(allocator.getTable(), hashBase, keys[i], vals[i], allocator);
            ++i;
        }
        return hashBase;
    }

    private static int create(int desiredSize, IntAllocatorI allocator) {
        int capacity = PrimeFinder.nextPrime((int)((desiredSize << 1) + 1));
        int hashBase = allocator.allocate(capacity * 2 + 4) + 4;
        int[] table = allocator.getTable();
        IntHash2.setUsedAndRealSize(table, hashBase, 0, capacity);
        IntHash2.setMaxAndFreeSize(table, hashBase, capacity >> 1, capacity);
        return hashBase;
    }

    public static int add(int[] table, int hashBase, int key, int val, IntAllocatorI allocator) {
        assert (IntHash2.isFull(key));
        int index = IntHash2.insertionIndex(table, hashBase, key);
        if (index < 0) {
            int realIndex = -index;
            assert (table[realIndex] == key);
            if (table[realIndex + 1] == val) {
                return 0;
            }
            table[realIndex + 1] = val;
            return hashBase;
        }
        int previousState = table[index];
        table[index] = key;
        table[index + 1] = val;
        return IntHash2.postInsertHook(table, hashBase, IntHash2.isFree(previousState), allocator);
    }

    public static boolean remove(int[] table, int hashBase, int a) {
        int index = IntHash2.index(table, hashBase, a);
        if (index >= 0) {
            table[index] = IntHash2.setRemoved();
            table[index + 1] = IntHash2.setFree();
            IntHash2.decUsedSize(table, hashBase);
            return true;
        }
        return false;
    }

    public static int get(int[] table, int hashBase, int a) {
        int index = IntHash2.index(table, hashBase, a);
        if (index < 0) {
            return IntHash2.setFree();
        }
        return table[index + 1];
    }

    public static boolean contains(int[] table, int hashBase, int a) {
        return IntHash2.index(table, hashBase, a) >= 0;
    }

    public static boolean isEmpty(int[] table, int hashBase) {
        return IntHash2.getUsedSize(table, hashBase) == 0;
    }

    public static void clear(int[] table, int hashBase) {
        int[] set = table;
        int free = IntHash2.setFree();
        int capacity = IntHash2.getRealSize(table, hashBase);
        int i = hashBase + capacity * 2;
        while (i-- > hashBase) {
            set[i] = free;
        }
        IntHash2.setUsedSize(table, hashBase, 0);
        IntHash2.setFreeSize(table, hashBase, capacity);
    }

    public static boolean ensureSize(int[] table, int hashBase, int desiredSize, IntAllocatorI allocator) {
        int size = IntHash2.getUsedSize(table, hashBase);
        if (desiredSize > IntHash2.getMaxSize(table, hashBase) - size) {
            int newCapacity = (desiredSize + size << 1) + 1;
            IntHash2.rehash(table, hashBase, PrimeFinder.nextPrime((int)newCapacity), allocator);
            return true;
        }
        return false;
    }

    public static void compact(int[] table, int hashBase, IntAllocatorI allocator) {
        IntHash2.rehash(table, hashBase, PrimeFinder.nextPrime((int)((IntHash2.getUsedSize(table, hashBase) << 1) + 1)), allocator);
    }

    static <Context> boolean foreachInt(int[] table, int base, ClusterI.PredicateProcedure<Context> procedure, Context context, IntHash.Modifier modifier) throws DatabaseException {
        int capacity = IntHash2.getRealSize(table, base);
        int size = IntHash2.getUsedSize(table, base);
        int count = 0;
        int i = capacity * 2 + base;
        while (count < size && i-- > base) {
            int o;
            int v = table[i];
            if (!IntHash2.isFull(o = table[--i])) continue;
            int key = modifier != null ? modifier.execute(o) : o;
            if (procedure.execute(context, key, v)) {
                return true;
            }
            if (size != ++count) continue;
            return false;
        }
        assert (size == count);
        return false;
    }

    private static final int rehash(int[] oldTable, int oldHashBase, int newCapacity, IntAllocatorI allocator) {
        assert (PrimeFinder.nextPrime((int)newCapacity) == newCapacity);
        int oldCapacity = IntHash2.getRealSize(oldTable, oldHashBase);
        int oldSize = IntHash2.getUsedSize(oldTable, oldHashBase);
        int newHashBase = allocator.allocate(newCapacity * 2 + 4) + 4;
        int[] newtable = allocator.getTable();
        IntHash2.setUsedAndRealSize(newtable, newHashBase, oldSize, newCapacity);
        IntHash2.setMaxAndFreeSize(newtable, newHashBase, newCapacity >> 1, newCapacity - oldSize);
        int i = oldCapacity * 2 + oldHashBase;
        while (i-- > oldHashBase) {
            int o;
            int v = oldTable[i];
            if (!IntHash2.isFull(o = oldTable[--i])) continue;
            int index = IntHash2.insertionIndex(newtable, newHashBase, o);
            newtable[index] = o;
            newtable[index + 1] = v;
        }
        return newHashBase;
    }

    private static final int postInsertHook(int[] table, int hashBase, boolean usedFreeSlot, IntAllocatorI allocator) {
        if (usedFreeSlot) {
            IntHash2.decFreeSize(table, hashBase);
        }
        if (IntHash2.incUsedSize(table, hashBase) > IntHash2.getMaxSize(table, hashBase) || IntHash2.getFreeSize(table, hashBase) == 0) {
            int newCapacity = IntHash2.getUsedSize(table, hashBase) > IntHash2.getMaxSize(table, hashBase) ? PrimeFinder.nextPrime((int)(IntHash2.getRealSize(table, hashBase) << 1)) : IntHash2.getRealSize(table, hashBase);
            return IntHash2.rehash(table, hashBase, newCapacity, allocator);
        }
        return hashBase;
    }

    private static int index(int[] table, int hashBase, int a) {
        int[] set = table;
        int length = IntHash2.getRealSize(table, hashBase);
        int hash = IntHash2.computeHashCode(a);
        int index = hash % length;
        int hashIndex = hashBase + index * 2;
        if (!IntHash2.isFree(set[hashIndex]) && (IntHash2.isRemoved(set[hashIndex]) || set[hashIndex] != a)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!IntHash2.isFree(set[hashIndex = hashBase + index * 2]) && (IntHash2.isRemoved(set[hashIndex]) || set[hashIndex] != a));
        }
        return IntHash2.isFree(set[hashIndex]) ? -1 : hashIndex;
    }

    private static final int insertionIndex(int[] table, int hashBase, int a) {
        int[] set = table;
        int length = IntHash2.getRealSize(table, hashBase);
        int hash = IntHash2.computeHashCode(a);
        int index = hash % length;
        assert (hashBase != 0);
        int hashIndex = hashBase + index * 2;
        if (IntHash2.isFree(set[hashIndex])) {
            return hashIndex;
        }
        if (IntHash2.isFull(set[hashIndex]) && set[hashIndex] == a) {
            return -hashIndex;
        }
        int probe = 1 + hash % (length - 2);
        if (!IntHash2.isRemoved(set[hashIndex])) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (IntHash2.isFull(set[hashIndex = hashBase + index * 2]) && set[hashIndex] != a);
        }
        if (IntHash2.isRemoved(set[hashIndex])) {
            int firstRemoved = hashIndex;
            while (!IntHash2.isFree(set[hashIndex]) && (IntHash2.isRemoved(set[hashIndex]) || set[hashIndex] != a)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                hashIndex = hashBase + index * 2;
            }
            return IntHash2.isFull(set[hashIndex]) ? -hashIndex : firstRemoved;
        }
        return IntHash2.isFull(set[hashIndex]) ? -hashIndex : hashIndex;
    }

    private static final int computeHashCode(int aKey) {
        int hash = aKey * 31;
        return hash & Integer.MAX_VALUE;
    }
}

