/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import fi.vtt.simantics.procore.internal.ClusterTable;
import gnu.trove.map.hash.TIntShortHashMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterSmall;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ClusterTraitsSmall;
import org.simantics.db.procore.cluster.ForeignElement;
import org.simantics.db.procore.cluster.Table;
import org.simantics.db.procore.cluster.TableFactory;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ResourceUID;

public final class ForeignTableSmall
extends Table<long[]> {
    private ClusterTable clusterTable;
    static long rmTime = 0L;
    private static final int FOREIGN_COUNT_INDEX = 0;

    ForeignTableSmall(ClusterSmall sizeListener, int[] header, int headerBase) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase);
        this.clusterTable = sizeListener.clusterTable;
    }

    ForeignTableSmall(ClusterSmall sizeListener, int[] header, int headerBase, long[] longs) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase, longs);
        this.clusterTable = sizeListener.clusterTable;
    }

    int getUsedSize() {
        return this.getTableCount();
    }

    public TIntShortHashMap getResourceHashMap() throws DatabaseException {
        int ELEMENT_SIZE = ForeignElement.getSizeOf();
        assert (ELEMENT_SIZE == 3);
        int TABLE_SIZE = this.getTableCount();
        int FOREIGN_COUNT = this.getForeignCount();
        int BASE = this.getTableBase();
        int TOP = BASE + TABLE_SIZE * ELEMENT_SIZE;
        long[] table = (long[])this.getTable();
        int count = 0;
        int index = 1;
        long firstCache = 0L;
        long secondCache = 0L;
        ClusterImpl clusterCache = null;
        TIntShortHashMap hm = new TIntShortHashMap(FOREIGN_COUNT);
        int i = BASE;
        while (i < TOP && count < FOREIGN_COUNT) {
            if (0L != table[i] || 0L != table[i + 1] || 0L != table[i + 2]) {
                long first = table[i];
                long second = table[i + 1];
                long third = table[i + 2];
                ClusterImpl cluster = null;
                if (firstCache == first && secondCache == second) {
                    cluster = clusterCache;
                }
                if (cluster == null) {
                    clusterCache = cluster = this.clusterTable.getClusterByClusterUIDOrMakeProxy(ClusterUID.make((long)first, (long)second));
                    firstCache = first;
                    secondCache = second;
                }
                int resourceKey = ClusterTraits.createResourceKey((int)cluster.clusterKey, (int)((int)third));
                hm.put(resourceKey, ClusterTraitsSmall.makeForeignRef((short)index));
                ++count;
            }
            i += ELEMENT_SIZE;
            ++index;
        }
        if (FOREIGN_COUNT != hm.size()) {
            throw new DatabaseException("Foreign table has been corrupted. count=" + FOREIGN_COUNT + "size=" + hm.size());
        }
        return hm;
    }

    short createForeign(int resourceKey) {
        int index = this.getTableCount();
        int size = ForeignElement.getSizeOf();
        int foreignIndex = this.createNewElement(size);
        int realIndex = this.checkIndexAndGetRealIndex(foreignIndex, size);
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
        Object cluster = this.clusterTable.getClusterProxyByResourceKey(resourceKey);
        ClusterUID cuid = cluster.getClusterUID();
        ResourceUID uid = cuid.toRID((int)resourceIndex);
        ForeignElement.constructForeign((long[])this.getTable(), realIndex, uid);
        this.incForeignCount();
        return ClusterTraitsSmall.makeForeignRef((short)(index + 1));
    }

    void deleteForeign(int foreignIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(foreignIndex);
        ForeignElement.destructForeign((long[])this.getTable(), realIndex);
        this.decForeignCount();
    }

    final ResourceUID getResourceUID(int foreignIndex) {
        return ForeignElement.getResourceUID((long[])this.table, this.checkIndexAndGetRealIndex(foreignIndex));
    }

    int getForeignCount() {
        return this.getExtra(0);
    }

    private int incForeignCount() {
        int count = this.getExtra(0) + 1;
        this.setExtra(0, count);
        return count;
    }

    private int decForeignCount() {
        int count = this.getExtra(0) - 1;
        this.setExtra(0, count);
        return count;
    }

    private int checkIndexAndGetRealIndex(int foreignIndex) {
        int index = (foreignIndex - 1) * ForeignElement.getSizeOf() + 1;
        int realIndex = this.checkIndexAndGetRealIndex(index, ForeignElement.getSizeOf());
        return realIndex;
    }
}

