/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.map.hash.TObjectIntHashMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procore.cluster.ForeignElement;
import org.simantics.db.procore.cluster.Table;
import org.simantics.db.procore.cluster.TableFactory;
import org.simantics.db.procore.cluster.TableSizeListener;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ResourceUID;

final class ForeignTable
extends Table<long[]> {
    private static final int FOREIGN_COUNT_INDEX = 0;

    ForeignTable(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase);
    }

    ForeignTable(TableSizeListener sizeListener, int[] header, int headerBase, long[] longs) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase, longs);
    }

    int getUsedSize() {
        return this.getTableCount();
    }

    TObjectIntHashMap<ClusterUID> getHashMap() throws DatabaseException {
        int ELEMENT_SIZE = ForeignElement.getSizeOf();
        int TABLE_SIZE = this.getTableCount();
        int FOREIGN_COUNT = this.getForeignCount();
        int BASE = this.getTableBase();
        int TOP = BASE + TABLE_SIZE * ELEMENT_SIZE;
        long[] table = (long[])this.getTable();
        int count = 0;
        int index = 1;
        TObjectIntHashMap hm = new TObjectIntHashMap(FOREIGN_COUNT);
        int i = BASE;
        while (i < TOP && count < FOREIGN_COUNT) {
            if (0L != table[i] || 0L != table[i + 1] || 0L != table[i + 2]) {
                hm.put((Object)ClusterUID.make((long)table[i], (long)table[i + 1]), index);
                ++count;
            }
            i += ELEMENT_SIZE;
            ++index;
        }
        if (FOREIGN_COUNT != hm.size()) {
            throw new DatabaseException("Foreign table has been corrupted.");
        }
        return hm;
    }

    TObjectIntHashMap<ResourceUID> getResourceHashMap() throws DatabaseException {
        int ELEMENT_SIZE = ForeignElement.getSizeOf();
        assert (ELEMENT_SIZE == 3);
        int TABLE_SIZE = this.getTableCount();
        int FOREIGN_COUNT = this.getForeignCount();
        int BASE = this.getTableBase();
        int TOP = BASE + TABLE_SIZE * ELEMENT_SIZE;
        long[] table = (long[])this.getTable();
        int count = 0;
        int index = 1;
        TObjectIntHashMap hm = new TObjectIntHashMap(FOREIGN_COUNT);
        int i = BASE;
        while (i < TOP && count < FOREIGN_COUNT) {
            if (0L != table[i] || 0L != table[i + 1] || 0L != table[i + 2]) {
                hm.put((Object)new ResourceUID(table[i], table[i + 1], table[i + 2]), index);
                ++count;
            }
            i += ELEMENT_SIZE;
            ++index;
        }
        if (FOREIGN_COUNT != hm.size()) {
            throw new DatabaseException("Foreign table has been corrupted. count=" + FOREIGN_COUNT + "size=" + hm.size());
        }
        return hm;
    }

    int createForeign(ResourceUID uid) {
        int index = this.getTableCount();
        int size = ForeignElement.getSizeOf();
        int foreignIndex = this.createNewElement(size);
        int realIndex = this.checkIndexAndGetRealIndex(foreignIndex, size);
        ForeignElement.constructForeign((long[])this.getTable(), realIndex, uid);
        this.incForeignCount();
        return index + 1;
    }

    void deleteForeign(int foreignIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(foreignIndex);
        ForeignElement.destructForeign((long[])this.getTable(), realIndex);
        this.decForeignCount();
    }

    final ResourceUID getResourceUID(int foreignIndex) {
        return ForeignElement.getResourceUID((long[])this.table, this.checkIndexAndGetRealIndex(foreignIndex));
    }

    int getForeignCount() {
        return this.getExtra(0);
    }

    private int incForeignCount() {
        int count = this.getExtra(0) + 1;
        this.setExtra(0, count);
        return count;
    }

    private int decForeignCount() {
        int count = this.getExtra(0) - 1;
        this.setExtra(0, count);
        return count;
    }

    private int checkIndexAndGetRealIndex(int foreignIndex) {
        int index = (foreignIndex - 1) * ForeignElement.getSizeOf() + 1;
        int realIndex = this.checkIndexAndGetRealIndex(index, ForeignElement.getSizeOf());
        return realIndex;
    }
}

