/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.IntHash;

class ForeachObject<Context>
implements ClusterI.ObjectProcedure<Context> {
    private ClusterI.ObjectProcedure<Context> procedure;
    private IntHash.Modifier modifier;
    private ClusterI.CompleteTypeEnum completeType;

    public ForeachObject(ClusterI.ObjectProcedure<Context> procedure, ClusterSupport support, IntHash.Modifier modifier, ClusterI.CompleteTypeEnum completeType) {
        this.procedure = procedure;
        this.modifier = modifier;
        this.completeType = completeType;
    }

    public boolean execute(Context context, int completeRef) throws DatabaseException {
        ClusterI.CompleteTypeEnum completeType2 = ClusterTraits.completeReferenceGetType(completeRef);
        if (this.completeType == completeType2) {
            int clusterIndex = ClusterTraits.completeReferenceGetForeignIndex(completeRef);
            int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex(completeRef);
            if (clusterIndex == 0) {
                int externalRef = this.modifier == null ? resourceIndex : this.modifier.execute(resourceIndex);
                return this.procedure.execute(context, externalRef);
            }
            try {
                int externalRef = ClusterTraits.createForeignReference(clusterIndex, resourceIndex);
                if (this.modifier != null) {
                    externalRef = this.modifier.execute(externalRef);
                }
                return this.procedure.execute(context, externalRef);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public boolean found() {
        throw new UnsupportedOperationException();
    }
}

