/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.procore.cluster.CalculateStatements;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.PredicateTable;
import org.simantics.db.procore.cluster.ResourceTable;

public class ClusterPrintDebugInfo
implements ClusterI.ObjectProcedure<Integer> {
    private ClusterBig cluster;
    private ClusterSupport support;
    private ObjectTable ot;
    private int n = 0;

    ClusterPrintDebugInfo(ClusterBig cluster, ResourceTable resourceTable, PredicateTable predicateTable, ClusterSupport support, ObjectTable ot) throws DatabaseException {
        this.cluster = cluster;
        if (support == null) {
            throw new DatabaseException("Illegal argument.");
        }
        this.support = support;
        this.ot = ot;
    }

    public boolean execute(Integer i, int resourceRef) {
        int resourceKey;
        try {
            resourceKey = ClusterTraits.createResourceKey((int)this.cluster.getClusterKey(), (int)resourceRef);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return false;
        }
        CalculateStatements cs = new CalculateStatements(resourceRef, this.ot);
        try {
            this.cluster.forPredicates(resourceKey, cs, cs, this.support);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public int getSize() {
        return this.n;
    }

    public boolean found() {
        throw new UnsupportedOperationException();
    }
}

