/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.procore.cluster.LongHash;
import org.simantics.db.procore.cluster.LongIterator;

public class ClusterObjectSet {
    public static final int HeaderSize = 2;
    private final LongHash.AllocatorI allocator;
    private long[] longs;
    private int hashBase;

    public ClusterObjectSet(LongHash.AllocatorI allocator) {
        this.allocator = allocator;
        this.longs = allocator.getLongs();
        this.hashBase = allocator.getHashBase();
    }

    public ClusterObjectSet(LongHash.AllocatorI allocator, int initialSize) {
        this.allocator = allocator;
        this.hashBase = LongHash.setUp(allocator, initialSize);
        this.longs = allocator.getLongs();
    }

    public boolean add(long a) {
        if (LongHash.add(this.allocator, a)) {
            this.longs = this.allocator.getLongs();
            this.hashBase = this.allocator.getHashBase();
            return true;
        }
        return false;
    }

    public void clear() {
        LongHash.clear(this.longs, this.hashBase);
    }

    public void compact() {
        LongHash.compact(this.allocator);
        this.longs = this.allocator.getLongs();
        this.hashBase = this.allocator.getHashBase();
    }

    public boolean contains(long a) {
        return LongHash.contains(this.longs, this.hashBase, a);
    }

    public boolean ensureSize(int size) {
        if (LongHash.ensureSize(this.allocator, size)) {
            this.longs = this.allocator.getLongs();
            this.hashBase = this.allocator.getHashBase();
            return true;
        }
        return false;
    }

    public int getCapacity() {
        return LongHash.getRealSize(this.longs, this.hashBase);
    }

    public LongIterator getObjeccts() {
        return new LongIterator(this.allocator);
    }

    public int getSize() {
        return LongHash.getUsedSize(this.longs, this.hashBase);
    }

    public boolean isEmpty() {
        return LongHash.isEmpty(this.longs, this.hashBase);
    }

    public boolean remove(long a) {
        return LongHash.remove(this.longs, this.hashBase, a);
    }

    private static void test(boolean ensureOn, boolean dumpOn, int addedLongs, long longOffset) {
        long next;
        String eo = ensureOn ? "on" : "off";
        System.out.println("********************************************");
        System.out.println("Set test with ensure " + eo);
        long start = System.nanoTime();
        AllocatorTest allocator = new AllocatorTest(null, 0);
        ClusterObjectSet longSet = new ClusterObjectSet(allocator, 0);
        if (ensureOn) {
            longSet.ensureSize(addedLongs);
        }
        long i = 0L;
        while (i < (long)addedLongs) {
            if (!longSet.add(i + longOffset)) {
                throw new Error("Add failed.");
            }
            ++i;
        }
        double end = (double)(System.nanoTime() - start) / 1000000.0;
        System.out.println("Elapsed time in milliseconds " + end + " for adding " + addedLongs + ".");
        if (dumpOn) {
            allocator.dump();
        }
        start = System.nanoTime();
        long i2 = 0L;
        while (i2 < (long)addedLongs) {
            if (!longSet.contains(i2 + longOffset)) {
                throw new Error("Contain failed.");
            }
            ++i2;
        }
        end = (double)(System.nanoTime() - start) / 1000000.0;
        System.out.println("Elapsed time in milliseconds " + end + " for reading.");
        start = System.nanoTime();
        long longSize = (long)addedLongs + longOffset;
        long freeLong = LongHash.setFree();
        LongIterator iterator = longSet.getObjeccts();
        while (freeLong != (next = iterator.next())) {
            if (next >= longOffset && next < longSize) continue;
            throw new Error("Iterator failed.");
        }
        end = (double)(System.nanoTime() - start) / 1000000.0;
        System.out.println("Elapsed time in milliseconds " + end + " for looping.");
        start = System.nanoTime();
        long i3 = 0L;
        while (i3 < (long)addedLongs) {
            if (!longSet.remove(i3 + longOffset)) {
                throw new Error("Remove failed.");
            }
            ++i3;
        }
        end = (double)(System.nanoTime() - start) / 1000000.0;
        System.out.println("Elapsed time in milliseconds " + end + " for removing.");
        if (longSet.getSize() != 0) {
            throw new Error("Element count not zero.");
        }
        if (dumpOn) {
            allocator.dump();
        }
        System.out.println("Real hash space consumption " + longSet.getCapacity());
        start = System.nanoTime();
        longSet.compact();
        end = (double)(System.nanoTime() - start) / 1000000.0;
        System.out.println("Elapsed time in      " + end + " for compact.");
        System.out.println("Real hash space consumption " + longSet.getCapacity());
        if (dumpOn) {
            allocator.dump();
        }
        System.out.println("********************************************");
    }

    public static void main(String[] args) {
        boolean dumpOn = true;
        int addedLongs = 100;
        long longOffset = 100L;
        ClusterObjectSet.test(false, true, 100, 100L);
        ClusterObjectSet.test(true, true, 100, 100L);
    }

    private static class AllocatorTest
    implements LongHash.AllocatorI {
        private static final int HASH_OFFSET = 10;
        private long[] longs;
        private int hashBase;

        AllocatorTest(long[] longs, int hashBase) {
        }

        @Override
        public int allocate(int size) {
            this.hashBase = 12;
            this.longs = new long[size + this.hashBase];
            return 12;
        }

        @Override
        public final int getHashBase() {
            return this.hashBase;
        }

        @Override
        public final long[] getLongs() {
            return this.longs;
        }

        void dump() {
            int i = 0;
            while (i < this.longs.length) {
                System.out.println("longs[" + i + "]=" + this.longs[i]);
                ++i;
            }
            System.out.println("longs capacity=" + this.longs.length);
        }
    }
}

