/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.map.hash.TObjectIntHashMap;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.FlatTable;
import org.simantics.db.procore.cluster.ForeignTable;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ResourceUID;

public class ClusterMap {
    private ForeignTable foreignTable;
    private TObjectIntHashMap<ClusterUID> hashMap;

    ClusterMap(ForeignTable foreignTable, FlatTable flatTable) {
        this.foreignTable = foreignTable;
        this.hashMap = null;
    }

    void compact() {
        if (this.hashMap == null) {
            return;
        }
        this.hashMap.compact();
    }

    int getUsedSpace() {
        if (this.hashMap == null) {
            return 0;
        }
        return 39 * this.hashMap.size();
    }

    int getForeignResourceIndex(int reference) throws DatabaseException {
        if (ClusterTraits.isFlat(reference)) {
            throw new DatabaseException("Flat reference is not supported yet.");
        }
        return ClusterTraits.getResourceIndexFromForeignReference(reference);
    }

    final ResourceUID getResourceUID(int reference) throws DatabaseException {
        if (ClusterTraits.isFlat(reference)) {
            throw new DatabaseException("Flat reference is not supported yet. reference=" + reference);
        }
        int foreignIndex = ClusterTraits.getForeignIndexFromReference(reference);
        return this.foreignTable.getResourceUID(foreignIndex);
    }

    int getForeignReferenceOrCreateByResourceKey(int resourceKey, ClusterUID clusterUID) throws DatabaseException {
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        return this.getForeignReferenceOrCreateByResourceIndex(resourceIndex, clusterUID);
    }

    int getForeignReferenceOrCreateByResourceIndex(int resourceIndex, ClusterUID clusterUID) throws DatabaseException {
        int foreignIndex;
        if (ClusterTraitsBase.isIllegalResourceIndex((int)resourceIndex)) {
            throw new DatabaseException("Illegal resource index=" + resourceIndex + ".");
        }
        if (this.hashMap == null) {
            this.hashMap = this.foreignTable.getHashMap();
        }
        if ((foreignIndex = this.hashMap.get((Object)clusterUID)) == 0) {
            foreignIndex = this.foreignTable.createForeign(clusterUID.toRID(resourceIndex));
            this.hashMap.put((Object)clusterUID, foreignIndex);
        }
        return ClusterTraits.createForeignReference(foreignIndex, resourceIndex);
    }

    int getForeignReferenceOrZero(int resourceIndex, ClusterUID clusterUID) throws DatabaseException {
        if (this.hashMap == null) {
            this.hashMap = this.foreignTable.getHashMap();
        }
        if (ClusterUID.Null.equals((Object)clusterUID)) {
            throw new DatabaseException("Illegal cluster uid " + clusterUID);
        }
        if (resourceIndex == 0) {
            throw new DatabaseException("Illegal resource index " + resourceIndex);
        }
        int foreignIndex = this.hashMap.get((Object)clusterUID);
        if (foreignIndex == 0) {
            return 0;
        }
        return ClusterTraits.createForeignReference(foreignIndex, resourceIndex);
    }
}

