/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterChange;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.File;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.graph.DelayedWriteGraph;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.TestCluster;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.XSupport;

public class XSupportImpl
implements XSupport {
    private final boolean DEBUG = false;
    private final SessionImplSocket session;
    private static String clusterIdFolderPathSuffix = "/.metadata/.plugins/org.simantics.db.procore";

    XSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public void corruptPageTableAndDie() throws DatabaseException {
        this.execute("corruptPageTableAndDie");
    }

    public void corruptCluster(Resource r) throws DatabaseException {
        ClusterImpl cluster = this.getCluster(r);
        long clusterId = -1L;
        if (cluster.cc == null) {
            cluster.cc = new ClusterChange(this.session.clusterStream, cluster);
        }
        this.session.clusterStream.corruptCluster(cluster.cc, clusterId);
    }

    public int corruptClusterTable(long clusterId) throws DatabaseException {
        return this.session.clusterTable.makeProxy(ClusterUID.makeRandom(), clusterId).getClusterKey();
    }

    public void flushCluster(Resource r) throws ServiceException {
        this.session.writeSupport.flushCluster(r);
    }

    public void breakConnection() throws DatabaseException {
        this.session.graphSession.graphClient.disconnect();
    }

    public void setClusterStreamOff(boolean setOff) throws DatabaseException {
        this.session.clusterTranslator.setStreamOff(setOff);
    }

    public int clearMetadataCache() throws DatabaseException {
        return this.session.graphSession.metadataCache.clear();
    }

    public <T> void commitAndContinue(WriteOnlyGraph wograph, WriteTraits wtraits) {
        this.session.state.commitAndContinue2((WriteGraphImpl)wograph.getService(WriteGraphImpl.class), this.session.clusterStream, wtraits);
    }

    public boolean getImmutable(Resource resource) throws DatabaseException {
        if (!resource.isPersistent()) {
            return false;
        }
        ClusterImpl clusterImpl = this.getCluster(resource);
        return clusterImpl.getImmutable();
    }

    public void setImmutable(Resource resource, boolean immutable) throws DatabaseException {
        ClusterImpl clusterImpl = this.getCluster(resource);
        clusterImpl.setImmutable(immutable, (ClusterSupport)this.session.clusterTranslator);
    }

    private ClusterImpl getCluster(Resource resource) throws DatabaseException {
        if (resource == null) {
            return null;
        }
        int key = this.session.getService(SerialisationSupport.class).getTransientId(resource);
        return (ClusterImpl)this.session.clusterTranslator.getClusterByResourceKey(key);
    }

    public void setServiceMode(boolean allow, boolean create) {
        this.session.serviceMode = (allow ? 1 : 0) + (create ? 2 : 0);
        this.session.writeSupport.flushCluster();
    }

    public Resource convertDelayedResourceToResource(Resource resource) {
        return DelayedWriteGraph.convertDelayedResource((Resource)resource);
    }

    public String execute(String command) throws DatabaseException {
        boolean transaction = true;
        try {
            this.session.state.startReadTransaction(Integer.MIN_VALUE);
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)"Trying to muddle on.", (Throwable)t);
            transaction = false;
        }
        try {
            String string = this.session.graphSession.execute(command);
            return string;
        }
        finally {
            if (transaction) {
                this.session.state.stopReadTransaction();
            }
        }
    }

    public void testCluster(Session session) throws DatabaseException {
        TestCluster.test(session);
    }

    public void initClusterIdMap(String workspaceFolder) throws DatabaseException {
        String toFolder = String.valueOf(workspaceFolder) + clusterIdFolderPathSuffix;
        this.session.clusterTable.clusterIds.saveToFolder(new File(toFolder));
    }

    public void mergeClusterIdMap(String workspaceFolder) throws DatabaseException {
        String fromFolder = String.valueOf(workspaceFolder) + clusterIdFolderPathSuffix;
        this.session.clusterTable.clusterIds.mergeFromFolder(fromFolder);
    }
}

