/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.list.array.TByteArrayList;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.service.ClusterBuilder2;
import org.simantics.db.service.SerialisationSupport;

public class VirtualClusterBuilderImpl2
implements ClusterBuilder2 {
    private final SessionImplSocket session;
    private final VirtualGraph vg;
    private final SerialisationSupport ss;
    private final boolean allowImmutables;
    TByteArrayList valueBytes = new TByteArrayList();
    int valueSubject = 0;

    VirtualClusterBuilderImpl2(SessionImplSocket session, VirtualGraph vg, boolean allowImmutables) {
        this.session = session;
        this.vg = vg;
        this.allowImmutables = allowImmutables;
        this.ss = session.getService(SerialisationSupport.class);
    }

    private WriteSupport getSupport() {
        WriteGraphImpl graph = this.session.writeState.getGraph();
        return graph.writeSupport;
    }

    public void newCluster() throws DatabaseException {
    }

    public void selectCluster(long cluster) throws DatabaseException {
    }

    public void newCluster(int setHandle) throws DatabaseException {
    }

    public void createClusterSet(int resource) throws DatabaseException {
    }

    public int newResource() throws DatabaseException {
        Resource result = this.getSupport().createResource(this.vg);
        return this.handle(result);
    }

    public int newResource(int set) throws DatabaseException {
        Resource result = this.getSupport().createResource(this.vg, this.resource(set));
        return this.handle(result);
    }

    public int resource(Resource res) throws DatabaseException {
        ResourceImpl r = (ResourceImpl)res;
        return r.id;
    }

    public void addStatement(WriteOnlyGraph graph, int subject, int predicate, int object) throws DatabaseException {
        this.getSupport().claim(this.vg, subject, predicate, object);
    }

    public Resource resource(int key) {
        try {
            return this.ss.getResource(key);
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    public int handle(Resource r) {
        return ((ResourceImpl)r).id;
    }

    public void beginValue(int subject) {
        this.valueBytes.clear();
        this.valueSubject = subject;
    }

    public void appendValue(int byteValue) throws DatabaseException {
        this.valueBytes.add((byte)byteValue);
    }

    public void endValue() throws DatabaseException {
        byte[] bytes = this.valueBytes.toArray();
        this.getSupport().claimValue(this.vg, this.valueSubject, bytes, bytes.length);
    }
}

