/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClientChangesImpl;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.OperationImpl;
import fi.vtt.simantics.procore.internal.SessionImplDb;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SynchronizeContext;
import fi.vtt.simantics.procore.internal.WriteState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.simantics.db.Metadata;
import org.simantics.db.Operation;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.ACommentMetadata;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.CommitMetadata;
import org.simantics.db.common.UndoMetadata;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procore.protocol.UndoFunction;
import org.simantics.db.service.ExternalOperation;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.utils.DataContainer;

public class UndoRedoSupportImpl
implements UndoRedoSupport {
    private final boolean DEBUG = false;
    private final SessionImplSocket session;
    final ManagementSupport managementSupport;

    UndoRedoSupportImpl(SessionImplSocket session) {
        this.session = session;
        this.managementSupport = session.getService(ManagementSupport.class);
    }

    public Operation undo(final Collection<Operation> ops) throws DatabaseException {
        if (ops == null || ops.size() < 1) {
            throw new IllegalArgumentException("At least one operation must be defined.");
        }
        final Operation fop = (Operation)ops.toArray()[0];
        final DataContainer id = new DataContainer((Object)0L);
        final SessionImplSocket.TaskHelper th = new SessionImplSocket.TaskHelper("Undo");
        this.session.requestManager.scheduleWrite(new QueryProcessor.SessionTask(null, 0){

            public void run(int thread) {
                ((UndoRedoSupportImpl)UndoRedoSupportImpl.this).session.flushCounter = 0;
                ((UndoRedoSupportImpl)UndoRedoSupportImpl.this).session.clusterStream.reallyFlush();
                ClientChangesImpl cs = new ClientChangesImpl(UndoRedoSupportImpl.this.session);
                if (((UndoRedoSupportImpl)UndoRedoSupportImpl.this).session.clientChanges == null) {
                    ((UndoRedoSupportImpl)UndoRedoSupportImpl.this).session.clientChanges = cs;
                }
                WriteGraphImpl writer = WriteGraphImpl.create((QueryProcessor)UndoRedoSupportImpl.this.session.getQueryProvider2(), (WriteSupport)((UndoRedoSupportImpl)UndoRedoSupportImpl.this).session.writeSupport, null);
                ((UndoRedoSupportImpl)UndoRedoSupportImpl.this).session.writeState = new WriteState<Object>(writer, th.writeTraits, th.sema, th.proc);
                try {
                    SynchronizeContext context = new SynchronizeContext(UndoRedoSupportImpl.this.session, cs, 1);
                    UndoFunction t = ((UndoRedoSupportImpl)UndoRedoSupportImpl.this).session.graphSession.undo(ops, context);
                    if (t.potentialConflicts) {
                        th.throw_("Server thinks that there might be potential conflicts with this undo operation.");
                    }
                    boolean undo = true;
                    if (!context.isOk(true)) {
                        th.throw_("Trouble with server reply.");
                    }
                }
                catch (Throwable e) {
                    th.throwableSet(e);
                    th.sema.release();
                    return;
                }
                try {
                    CommentMetadata cm = (CommentMetadata)writer.getMetadata(CommentMetadata.class);
                    UndoMetadata um = (UndoMetadata)writer.getMetadata(UndoMetadata.class);
                    UndoMetadata pum = UndoRedoSupportImpl.this.getComment4Undo(fop.getId());
                    if (pum != null) {
                        writer.addMetadata((Metadata)um.add((ACommentMetadata)pum));
                        um.setTypeAndRange(pum);
                    }
                    writer.addMetadata((Metadata)um.add("Undo operation " + fop.getId() + "."));
                    Operation ope = fop;
                    if (ops.size() > 1) {
                        writer.addMetadata((Metadata)um.add("Undo " + ops.size() + " change sets."));
                        writer.addMetadata((Metadata)um.add("First change set was " + fop.getCSId() + "."));
                        Operation lop = (Operation)ops.toArray()[ops.size() - 1];
                        writer.addMetadata((Metadata)um.add("Last change set was " + lop.getCSId() + "."));
                        ope = lop;
                    }
                    writer.addMetadata((Metadata)cm.add((ACommentMetadata)UndoRedoSupportImpl.this.getComment(ope.getId())));
                    if (pum == null || pum.getBeginCSId() == 0L) {
                        um.setTypeAndRange(false, ope.getId(), ope.getCSId());
                        writer.addMetadata((Metadata)um);
                    }
                    UndoRedoSupportImpl.this.session.getQueryProvider2().performDirtyUpdates((ReadGraphImpl)writer);
                    UndoRedoSupportImpl.this.session.fireMetadataListeners(writer, cs);
                    UndoRedoSupportImpl.this.session.getQueryProvider2().performScheduledUpdates(writer);
                    UndoRedoSupportImpl.this.session.fireReactionsToSynchronize(cs);
                    UndoRedoSupportImpl.this.session.fireSessionVariableChange("writes");
                    UndoRedoSupportImpl.this.session.printDiagnostics();
                    long headChangeSetId = ((UndoRedoSupportImpl)UndoRedoSupportImpl.this).session.state.getHeadRevisionId();
                    id.set((Object)(headChangeSetId + 1L));
                }
                catch (Throwable e) {
                    Logger.defaultLogError((Throwable)e);
                    th.throwableSet(e);
                }
            }
        });
        this.session.acquire(th.sema, th.writeTraits);
        th.throwableCheck();
        long headChangeSetId = this.session.state.getHeadRevisionId();
        if ((Long)id.get() == headChangeSetId + 1L) {
            return null;
        }
        final ArrayList<ExternalOperation> externalRedos = new ArrayList<ExternalOperation>();
        GraphSession.forExternals(ops, (Function1<ExternalOperation, Boolean>)new FunctionImpl1<ExternalOperation, Boolean>(){

            public Boolean apply(final ExternalOperation op) {
                externalRedos.add(new ExternalOperation(){

                    public void undo() {
                        op.redo();
                    }

                    public void redo() {
                        op.undo();
                    }

                    public boolean isDisposed() {
                        return op.isDisposed();
                    }
                });
                return true;
            }
        });
        return new OperationImpl((Long)id.get(), (Long)id.get(), externalRedos);
    }

    private CommentMetadata getComment(long id) {
        try {
            Collection metadata = this.managementSupport.getMetadata(id, id, CommentMetadata.class);
            if (metadata.size() > 0) {
                return (CommentMetadata)metadata.iterator().next();
            }
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
        }
        return null;
    }

    private UndoMetadata getComment4Undo(long id) {
        try {
            Collection metadata = this.managementSupport.getMetadata(id, id, UndoMetadata.class);
            if (metadata.size() > 0) {
                return (UndoMetadata)metadata.iterator().next();
            }
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
        }
        return null;
    }

    public void undo(Operation op) throws DatabaseException {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add(op);
        this.undo(ops);
    }

    public Operation getCurrent() {
        return this.session.state.getLastOperation();
    }

    public int undo(Session session, int count) throws DatabaseException {
        return this.undoAndReturnOperations(session, count).size();
    }

    public List<Operation> undoAndReturnOperations(Session session, int count) throws DatabaseException {
        if (count < 1) {
            return Collections.emptyList();
        }
        if (!(session instanceof SessionImplDb)) {
            return Collections.emptyList();
        }
        SessionImplDb s = (SessionImplDb)session;
        return s.graphSession.undoContext.undo((UndoRedoSupport)this, count);
    }

    public List<Operation> redo(Session session, int count) throws DatabaseException {
        if (count < 1) {
            return Collections.emptyList();
        }
        if (!(session instanceof SessionImplDb)) {
            return Collections.emptyList();
        }
        SessionImplDb s = (SessionImplDb)session;
        return s.graphSession.undoContext.redo((UndoRedoSupport)this, count);
    }

    public int undoTo(Session session, long changeSet) throws DatabaseException {
        if (!(session instanceof SessionImplDb) || changeSet < 1L) {
            return 0;
        }
        SessionImplDb s = (SessionImplDb)session;
        long head = s.graphSession.getLastChangeSetId();
        int SIZE = (int)(head - changeSet);
        if (SIZE < 1) {
            return 0;
        }
        s.graphSession.undoContext.clear();
        Vector<Operation> ops = new Vector<Operation>(SIZE);
        ops.setSize(SIZE);
        long id = changeSet;
        int i = 0;
        while (i < SIZE) {
            OperationImpl o = new OperationImpl(++id, id);
            ops.setElementAt(o, i);
            ++i;
        }
        this.undo(ops);
        return SIZE;
    }

    public int initUndoListFrom(Session session, long changeSet) throws DatabaseException {
        if (!(session instanceof SessionImplDb) || changeSet < 1L) {
            return 0;
        }
        SessionImplDb s = (SessionImplDb)session;
        long head = s.graphSession.getLastChangeSetId();
        int SIZE = (int)(head - changeSet + 1L);
        if (SIZE < 1) {
            return 0;
        }
        ManagementSupport ms = (ManagementSupport)session.getService(ManagementSupport.class);
        Collection metadata = ms.getMetadata(changeSet, head, CommitMetadata.class);
        if (metadata.size() != SIZE) {
            return 0;
        }
        s.graphSession.undoContext.clear();
        long first = 0L;
        Iterator it = metadata.iterator();
        long csid = changeSet;
        SIZE = (int)((long)SIZE + csid);
        while (csid < (long)SIZE) {
            block8: {
                CommitMetadata md;
                block7: {
                    md = (CommitMetadata)it.next();
                    if (first != 0L) break block7;
                    if (md.opid != 0L && md.opid != csid) break block8;
                    first = csid;
                }
                long id = md.opid != 0L ? md.opid : csid;
                OperationImpl op = new OperationImpl(id, csid);
                s.graphSession.undoContext.commitOk((Operation)op);
            }
            ++csid;
        }
        return (int)(csid - first);
    }

    public UndoContext getUndoContext(Session session) {
        if (session instanceof SessionImplSocket) {
            GraphSession graphSession = ((SessionImplSocket)session).graphSession;
            return graphSession != null ? graphSession.undoContext : null;
        }
        return null;
    }

    public void subscribe(UndoRedoSupport.ChangeListener changeListener) {
        this.session.graphSession.undoContext.addChangeListener(changeListener);
    }

    public void cancel(UndoRedoSupport.ChangeListener changelistener) {
        this.session.graphSession.undoContext.removeChangeListener(changelistener);
    }

    public void addExternalOperation(WriteGraph graph, ExternalOperation op) {
        if (!(this.session instanceof SessionImplDb)) {
            return;
        }
        SessionImplDb s = (SessionImplDb)this.session;
        s.graphSession.undoContext.addExternalOperation(op);
    }
}

