/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.ThreadUtil;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.util.concurrent.ThreadFactory;
import org.simantics.db.common.TestPolicy;

public class ThreadFactoryImpl
implements ThreadFactory {
    private final SessionImplSocket session;

    ThreadFactoryImpl(SessionImplSocket session) {
        this.session = session;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread result = new Thread(SessionImplSocket.SessionThreadGroup, runnable);
        result.setName("SessionThread");
        if (TestPolicy.isActive()) {
            result.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    ThreadUtil.interruptMainThread();
                }
            });
        }
        this.session.sessionThreads.add(result);
        return result;
    }
}

