/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.ProCoreDriver;
import fi.vtt.simantics.procore.internal.Checkout;
import fi.vtt.simantics.procore.internal.HashFunctionTest;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.TeamSupportImpl;
import fi.vtt.simantics.procore.internal.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.ServerI;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.XSupport;
import org.simantics.utils.FileUtils;

class TeamUtils {
    private static Boolean DEBUG = TeamSupportImpl.DEBUG;

    TeamUtils() {
    }

    static void getComments(File from, Vector<String> comments) {
        Checkout.PersistentData pd;
        File ci = new File(from, "Checkout.procore");
        try {
            pd = Checkout.PersistentData.load(ci);
        }
        catch (IOException e) {
            throw new RuntimeException("IOError", e);
        }
        for (String c : pd.comments) {
            comments.add(c);
        }
    }

    static void checkout(File from, File to) throws DatabaseException {
        File branch;
        if (DEBUG.booleanValue()) {
            System.out.println("from=" + from.getAbsolutePath());
            System.out.println("  to=" + to.getAbsolutePath());
        }
        if (!from.isDirectory()) {
            throw new DatabaseException("Folder must exist. path=" + from.getAbsolutePath());
        }
        if (!to.exists()) {
            to.mkdir();
        }
        if (!(branch = new File(to, "procore.headClusters.procore")).exists()) {
            branch.mkdir();
        }
        Temp tt = TeamUtils.createBranch(from, branch);
        if (DEBUG.booleanValue()) {
            TeamUtils.printlnDebug(tt);
        }
    }

    static void fetchDump(SessionImplSocket session, File from, File to, long csid) throws DatabaseException {
        if (DEBUG.booleanValue()) {
            System.out.println("from=" + from.getAbsolutePath());
            System.out.println("  to=" + to.getAbsolutePath());
        }
        if (!from.isDirectory()) {
            throw new DatabaseException("Folder must exist. folder=" + from.getAbsolutePath());
        }
        if (to.exists()) {
            try {
                FileUtils.deleteAll((File)to);
            }
            catch (IOException e) {
                throw new DatabaseException("Folder must be empty. folder=" + from.getAbsolutePath(), (Throwable)e);
            }
        }
        to.mkdirs();
        File[] clusterFiles = from.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cc.pcdump");
            }
        });
        if (clusterFiles.length < 1) {
            throw new RuntimeException("No clusters. path=" + from.getAbsolutePath());
        }
        File tb = new File(to, "db/procore.headClusters.procore");
        if (!tb.isDirectory()) {
            tb.mkdirs();
        }
        Temp res = new Temp();
        int i = 0;
        while (i < clusterFiles.length) {
            String dumpName = clusterFiles[i].getName();
            int l = dumpName.length() - ".cc.pcdump".length();
            String name = "ClusterData." + dumpName.substring(0, l) + ".procore";
            File dst = new File(tb, name);
            clusterFiles[i].renameTo(dst);
            ClusterCode cc = TeamUtils.getClusterCodeFromDataFileName(name);
            Checkout.Cluster c = new Checkout.Cluster(cc.uid);
            res.clusters.put(cc.uid, c);
            res.pd.clusters.put(cc.uid, c);
            ++i;
        }
        File branch = new File(from, "procore.headClusters.procore");
        File[] externalFiles = branch.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("ExternalValue.");
            }
        });
        int i2 = 0;
        while (i2 < externalFiles.length) {
            String s = externalFiles[i2].getName();
            String[] ss = s.split("\\.");
            if (ss.length != 6) {
                throw new RuntimeDatabaseException("Illegal external value file name. name=" + s);
            }
            long cs = Long.parseLong(ss[4]);
            if (cs <= csid) {
                long second;
                long first = Utils.convertHexStringToLong(ss[1]);
                Checkout.IdImpl id = new Checkout.IdImpl(first, second = Utils.convertHexStringToLong(ss[2]));
                Checkout.Cluster c = res.clusters.get(id);
                if (c == null) {
                    throw new RuntimeDatabaseException("Missing cluster for external value. id=" + id);
                }
                int ri = Integer.parseInt(ss[3]);
                Checkout.Value nv = new Checkout.Value(ri, cs);
                Checkout.Value ov = c.values.get(ri);
                if (ov == null) {
                    c.values.put(ri, nv);
                } else if (ov.cs < nv.cs) {
                    ov.cs = nv.cs;
                }
            }
            ++i2;
        }
        for (Map.Entry<Checkout.IdImpl, Checkout.Cluster> e : res.clusters.entrySet()) {
            Checkout.Cluster c = e.getValue();
            for (Map.Entry<Integer, Checkout.Value> e2 : c.values.entrySet()) {
                Checkout.Value v = e2.getValue();
                boolean same = false;
                if (same) continue;
                String name = "ExternalValue." + c.uid + "." + v.index + "." + v.cs + ".procore";
                File f = new File(branch, name);
                File t = new File(tb, name);
                try {
                    FileUtils.copyFile((File)f, (File)t);
                }
                catch (IOException e1) {
                    throw new RuntimeException("IOError", e1);
                }
            }
        }
        File idFolder = new File(to, ".metadata/.plugins/org.simantics.db.procore");
        if (!idFolder.isAbsolute()) {
            idFolder.mkdirs();
        }
        session.clusterTable.clusterIds.mergeToFolder(idFolder);
        session.graphSession.mergeToFile(tb);
        ProCoreDriver.createServerConfigFile(new File(to, "db"));
    }

    static void fetchRevert(SessionImplSocket session, File from, File to, long csid, boolean stopOnError) throws DatabaseException {
        long lastChangeSetId;
        File idFolder;
        if (DEBUG.booleanValue()) {
            System.out.println("from=" + from.getAbsolutePath());
            System.out.println("  to=" + to.getAbsolutePath());
        }
        if (!from.isDirectory()) {
            throw new DatabaseException("Folder must exist. folder=" + from.getAbsolutePath());
        }
        if (to.exists()) {
            try {
                FileUtils.deleteAll((File)to);
            }
            catch (IOException e) {
                throw new DatabaseException("Folder must be empty. folder=" + from.getAbsolutePath(), (Throwable)e);
            }
        }
        to.mkdirs();
        File tb = new File(to, "db/procore.headClusters.procore");
        if (!tb.isDirectory()) {
            tb.mkdirs();
        }
        if (!(idFolder = new File(to, ".metadata/.plugins/org.simantics.db.procore")).isAbsolute()) {
            idFolder.mkdirs();
        }
        XSupport xs = session.getService(XSupport.class);
        if (!stopOnError) {
            lastChangeSetId = csid;
        } else {
            String s = xs.execute("getLastCorrectRevision " + csid);
            lastChangeSetId = Long.parseLong(s);
        }
        ManagementSupport ms = session.getService(ManagementSupport.class);
        ms.dumpChangeSets(lastChangeSetId);
        String name = "cs.pcdump";
        File f = new File(from, name);
        File t = new File(to, "db/" + name);
        if (!f.renameTo(t)) {
            throw new DatabaseException("Could not move " + f.getAbsolutePath() + " to " + t.getAbsolutePath() + ".");
        }
        session.clusterTable.clusterIds.mergeToFolder(idFolder);
        session.graphSession.mergeToFile(tb);
        File workingDir = new File(to, "db");
        ProCoreDriver.createServerConfigFile(workingDir);
        File ucDir = Manager.getUndocoreDirectoryByWorkspaceDirectory((File)to.getParentFile().getParentFile());
        Driver driver = Manager.getDriver((String)"procore");
        ServerI server = driver.getServer(ucDir, workingDir);
        server.start();
        String reply = server.execute("loadChangeSets\n");
        if (DEBUG.booleanValue() && !reply.isEmpty()) {
            System.out.println("DEBUG: LoadChangeSets reply: " + reply);
        }
        server.stop();
    }

    static void fetch(String comment, File from, File to, boolean init) throws DatabaseException {
        if (DEBUG.booleanValue()) {
            System.out.println("comment=" + comment);
            System.out.println("from=" + from.getAbsolutePath());
            System.out.println("  to=" + to.getAbsolutePath());
        }
        if (!from.isDirectory()) {
            throw new DatabaseException("Folder must exist. folder=" + from.getAbsolutePath());
        }
        if (init) {
            if (to.exists()) {
                int count = to.list().length;
                if (count > 0) {
                    System.out.println("TODO: Ask confirmation before deleting.");
                    throw new DatabaseException("Folder must be empty. folder=" + to.getAbsolutePath());
                }
            } else {
                to.mkdirs();
            }
            TeamUtils.fetchNew(comment, from, to);
        } else {
            if (!to.isDirectory()) {
                throw new DatabaseException("Path must be folder. folder=" + to.getAbsolutePath());
            }
            TeamUtils.fetchOld(comment, from, to);
        }
    }

    private static void fetchNew(String comment, File from, File to) {
        File head = new File(from, "procore.headClusters.procore");
        if (!head.isDirectory()) {
            throw new RuntimeException("Missing cluster folder. path=" + head.getAbsolutePath());
        }
        Temp t = TeamUtils.copyClusters(head, to);
        t.pd.comments.add(comment);
        if (DEBUG.booleanValue()) {
            TeamUtils.printlnDebug(t);
        }
        TeamUtils.getResourceIndex(t, head, to);
    }

    private static void printlnDebug(Temp t) {
        Checkout.Value v;
        Checkout.Cluster c;
        System.out.println("DEBUG: all");
        for (String string : t.pd.comments) {
            System.out.println("comment=" + string);
        }
        for (Map.Entry entry : t.pd.clusters.entrySet()) {
            c = (Checkout.Cluster)entry.getValue();
            System.out.println("cluster=" + c.uid);
            for (Map.Entry<Integer, Checkout.Value> e2 : c.values.entrySet()) {
                v = e2.getValue();
                System.out.println("value=" + v.index + " cs=" + v.cs);
            }
        }
        System.out.println("DEBUG: changed");
        for (Map.Entry entry : t.clusters.entrySet()) {
            c = (Checkout.Cluster)entry.getValue();
            System.out.println("cluster=" + c.uid);
            for (Map.Entry<Integer, Checkout.Value> e2 : c.values.entrySet()) {
                v = e2.getValue();
                System.out.println("value=" + v.index + " cs=" + v.cs);
            }
        }
        System.out.println("DEBUG: all=" + t.pd.clusters.size() + " changed=" + t.clusters.size());
    }

    private static void fetchOld(String comment, File from, File to) {
        File head = new File(from, "procore.headClusters.procore");
        if (!head.isDirectory()) {
            throw new RuntimeException("Missing cluster folder. path=" + head.getAbsolutePath());
        }
        Temp t = TeamUtils.copyClustersOld(head, to);
        t.pd.comments.add(comment);
        if (DEBUG.booleanValue()) {
            TeamUtils.printlnDebug(t);
        }
        TeamUtils.getResourceIndex(t, head, to);
    }

    private static long parseLong(String s) {
        if (s.length() < 16) {
            return Long.parseLong(s, 16);
        }
        long first = Long.parseLong(s.substring(0, 8), 16);
        long second = Long.parseLong(s.substring(8), 16);
        return first << 32 | second;
    }

    private static ClusterCode getClusterCodeFromDataFileName(String name) {
        if (!name.startsWith("ClusterData.")) {
            throw new RuntimeDatabaseException("Illegal argument=" + name + ".");
        }
        String[] parts = name.split("\\.");
        if (parts.length != 4) {
            throw new RuntimeDatabaseException("Parse error. input=" + name + ".");
        }
        long first = TeamUtils.parseLong(parts[1]);
        long second = TeamUtils.parseLong(parts[2]);
        ClusterCode cc = new ClusterCode();
        cc.uid = new Checkout.IdImpl(first, second);
        if (DEBUG.booleanValue()) {
            System.out.println("cluster=" + cc + " read from index file");
        }
        return cc;
    }

    private static Temp copyClusters(File from, File to) {
        File[] clusterFiles = from.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("ClusterData.");
            }
        });
        if (clusterFiles.length < 1) {
            throw new RuntimeException("No clusters. path=" + from.getAbsolutePath());
        }
        Temp res = new Temp();
        int i = 0;
        while (i < clusterFiles.length) {
            try {
                String name = clusterFiles[i].getName();
                File dst = new File(to, name);
                FileUtils.copyFile((File)clusterFiles[i], (File)dst);
                ClusterCode cc = TeamUtils.getClusterCodeFromDataFileName(name);
                Checkout.Cluster c = new Checkout.Cluster(cc.uid);
                res.clusters.put(cc.uid, c);
                res.pd.clusters.put(cc.uid, c);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException.", e);
            }
            ++i;
        }
        return res;
    }

    private static Temp copyClustersOld(File from, File to) {
        Checkout.PersistentData pd;
        File ci = new File(to, "Checkout.procore");
        try {
            pd = Checkout.PersistentData.load(ci);
        }
        catch (IOException e) {
            throw new RuntimeException("IOError", e);
        }
        Temp res = new Temp(pd);
        File[] clusterFiles = from.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("ClusterData.");
            }
        });
        if (clusterFiles.length < 1) {
            throw new RuntimeException("No clusters. path=" + from.getAbsolutePath());
        }
        int i = 0;
        while (i < clusterFiles.length) {
            String name = clusterFiles[i].getName();
            ClusterCode cc = TeamUtils.getClusterCodeFromDataFileName(name);
            File dst = new File(to, name);
            try {
                boolean same;
                Checkout.Cluster oc = res.pd.clusters.get(cc.uid);
                if (oc != null && (same = TeamUtils.checkSame(clusterFiles[i], dst))) {
                    if (DEBUG.booleanValue()) {
                        System.out.println("old cluster=" + cc);
                    }
                } else {
                    if (DEBUG.booleanValue()) {
                        System.out.println("new cluster=" + cc);
                    }
                    FileUtils.copy((File)clusterFiles[i], (File)dst);
                    Checkout.Cluster c = new Checkout.Cluster(cc.uid);
                    res.pd.clusters.put(cc.uid, c);
                    res.clusters.put(cc.uid, c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("IOException.", e);
            }
            ++i;
        }
        return res;
    }

    private static boolean checkSame(File f1, File f2) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            String h1 = HashFunctionTest.calculateHash(sha1, f1.getPath());
            String h2 = HashFunctionTest.calculateHash(sha1, f2.getPath());
            return h1.equals(h2);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.defaultLogError((String)"Failed to fetch sha1 algorithm.", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            Logger.defaultLogError((String)"Failed to calculate sha1 algorithm.", (Throwable)e);
            return false;
        }
    }

    private static void getResourceIndex(Temp temp, File from, File to) {
        for (Map.Entry<Checkout.IdImpl, Checkout.Cluster> e : temp.clusters.entrySet()) {
            Checkout.Cluster c = e.getValue();
            final String prefix = "ExternalValue." + c.uid + ".";
            File[] values = from.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            });
            if (values.length < 1) continue;
            int i = 0;
            while (i < values.length) {
                File f = values[i];
                String s = f.getName();
                String[] ss = s.split("\\.");
                if (ss.length != 6) {
                    throw new RuntimeDatabaseException("Illegal external value file name. name=" + s);
                }
                int in = Integer.parseInt(ss[3]);
                long cs = Long.parseLong(ss[4]);
                Checkout.Value nv = new Checkout.Value(in, cs);
                Checkout.Value ov = c.values.get(in);
                if (ov == null) {
                    c.values.put(in, nv);
                } else if (ov.cs < nv.cs) {
                    ov.cs = nv.cs;
                }
                ++i;
            }
            for (Map.Entry<Integer, Checkout.Value> e2 : c.values.entrySet()) {
                Checkout.Value v = e2.getValue();
                boolean same = false;
                if (same) continue;
                String prefix2 = String.valueOf(prefix) + v.index + ".";
                File f = new File(from, String.valueOf(prefix2) + v.cs + ".procore");
                File t = new File(to, String.valueOf(prefix2) + ".procore".substring(1));
                try {
                    FileUtils.copyFile((File)f, (File)t);
                }
                catch (IOException e1) {
                    throw new RuntimeException("IOError", e1);
                }
                if (!DEBUG.booleanValue()) continue;
                System.out.println("DEBUG: value c=" + c.uid + " i=" + v.index + " changed. file=" + t.getName());
            }
        }
        File ci = new File(to, "Checkout.procore");
        try {
            Checkout.PersistentData.save(ci, temp.pd);
        }
        catch (IOException e) {
            throw new RuntimeException("IOError", e);
        }
    }

    private static void createExternalValues(File from, File to, Checkout.IdImpl uid, HashMap<Integer, Checkout.Value> values) {
        for (Map.Entry<Integer, Checkout.Value> e : values.entrySet()) {
            Checkout.Value v = e.getValue();
            String name = "ExternalValue." + uid + "." + v.index + ".procore";
            File src = new File(from, name);
            String name2 = "ExternalValue." + uid + "." + v.index + ".1" + ".procore";
            File dst = new File(to, name2);
            try {
                FileUtils.copy((File)src, (File)dst);
            }
            catch (IOException e1) {
                throw new RuntimeException("IOException.", e1);
            }
        }
    }

    private static Temp createBranch(File from, File to) {
        Checkout.PersistentData pd;
        File ci = new File(from, "Checkout.procore");
        try {
            pd = Checkout.PersistentData.load(ci);
        }
        catch (IOException e) {
            throw new RuntimeException("IOError", e);
        }
        Temp res = new Temp(pd);
        for (Map.Entry<Checkout.IdImpl, Checkout.Cluster> c : pd.clusters.entrySet()) {
            Checkout.Cluster cl = c.getValue();
            String name = "ClusterData." + cl.uid + ".procore";
            File src = new File(from, name);
            File dst = new File(to, name);
            try {
                FileUtils.copy((File)src, (File)dst);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException.", e);
            }
            TeamUtils.createExternalValues(from, to, cl.uid, cl.values);
        }
        return res;
    }

    static class ClusterCode {
        Checkout.IdImpl uid;

        ClusterCode() {
        }

        ClusterCode(Checkout.IdImpl uid) {
            this.uid = uid;
        }

        public String toString() {
            return "" + this.uid;
        }
    }

    static class Temp {
        Checkout.PersistentData pd;
        HashMap<Checkout.IdImpl, Checkout.Cluster> clusters = new HashMap();

        Temp() {
            this.pd = new Checkout.PersistentData();
        }

        Temp(Checkout.PersistentData pd) {
            this.pd = pd;
        }
    }
}

