/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.ProCoreDriver;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.TeamUtils;
import java.io.File;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.TeamSupport;

public class TeamSupportImpl
implements TeamSupport {
    static boolean DEBUG = false;
    private final SessionImplSocket session;

    TeamSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    File getDatabaseFolder() {
        Location location = Platform.getInstanceLocation();
        String path = "/";
        if (location != null) {
            path = location.getURL().getFile();
        }
        return new File(path, "db");
    }

    public void dump(File from, File to, long csid) throws DatabaseException {
        TeamUtils.fetchDump(this.session, from, to, csid);
    }

    public void revert(File from, File to, long csid, boolean stopOnError) throws DatabaseException {
        TeamUtils.fetchRevert(this.session, from, to, csid, stopOnError);
    }

    public void commit(String comment, File to, boolean init) throws DatabaseException {
        System.out.println("DEBUG: commit=\"" + comment + "\" to " + to.getAbsolutePath());
        TeamUtils.fetch(comment, this.getDatabaseFolder(), to, init);
        this.session.clusterTable.clusterIds.mergeToFolder(to);
        this.session.graphSession.mergeToFile(new File(to, "nextId.dat"));
    }

    public void getComments(File teamFolder, Vector<String> comments) throws DatabaseException {
        TeamUtils.getComments(teamFolder, comments);
    }

    public void pull(File teamFolder, File to) throws DatabaseException {
        System.out.println("pull");
        if (!to.exists()) {
            to.mkdirs();
        } else if (!to.isDirectory()) {
            throw new DatabaseException("Output folder not correct: " + to.getAbsolutePath());
        }
        ProCoreDriver.createServerConfigFile(to);
        TeamUtils.checkout(teamFolder, to);
    }
}

