/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.internal.ListenerList;
import fi.vtt.simantics.procore.internal.SessionImplDb;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.db.Session;
import org.simantics.db.SessionErrorHandler;
import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.event.SessionEvent;
import org.simantics.db.event.SessionListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procore.protocol.GraphClient;
import org.simantics.db.procore.protocol.GraphClientEventHandler;
import org.simantics.db.procore.protocol.GraphClientImpl;
import org.simantics.db.procore.protocol.SessionManagerImpl;
import org.simantics.db.service.LifecycleSupport;

class SessionManagerImpl
implements SessionManager,
SessionManagerImpl.Listener {
    private ConcurrentHashMap<GraphClient, SessionImplSocket> sessionMap = new ConcurrentHashMap();
    private ListenerList<SessionListener> sessionListeners = new ListenerList<SessionListener>(SessionListener.class);
    private org.simantics.db.procore.protocol.SessionManagerImpl sessionManagerImpl = org.simantics.db.procore.protocol.SessionManagerImpl.getInstance();
    private SessionErrorHandler errorHandler;

    SessionManagerImpl() throws IOException {
        this.sessionManagerImpl.setListener((SessionManagerImpl.Listener)this);
    }

    GraphClient newGraphClient(GraphClientEventHandler handler) {
        return this.sessionManagerImpl.newGraphClient(handler);
    }

    void finish() {
        this.sessionManagerImpl.stop();
        this.sessionManagerImpl = null;
    }

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public Session createSession(SessionReference sessionReference, UserAuthenticationAgent authAgent) throws DatabaseException, IOException {
        assert (sessionReference != null);
        assert (sessionReference instanceof ProCoreSessionReference);
        SessionImplDb sessionImpl = new SessionImplDb(this, authAgent);
        boolean ok = false;
        try {
            try {
                sessionImpl.connect(sessionReference);
                this.sessionMap.put(sessionImpl.getGraphSession().graphClient, sessionImpl);
                this.fireSessionOpened(sessionImpl);
                ok = true;
            }
            catch (IOException e) {
                sessionImpl = null;
                throw e;
            }
            catch (Throwable e) {
                Logger.defaultLogError((String)"Connection failed. See exception for details.", (Throwable)e);
                try {
                    this.fireSessionClosed(sessionImpl, e);
                    if (sessionImpl.getGraphSession() != null && this.sessionMap.remove(sessionImpl.getGraphSession().graphClient) != null) {
                        this.sessionMap.remove(sessionImpl.getGraphSession().graphClient);
                    }
                    sessionImpl = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new DatabaseException(e);
            }
        }
        finally {
            if (!ok && sessionImpl != null) {
                sessionImpl.getService(LifecycleSupport.class).close();
            }
        }
        return sessionImpl;
    }

    public void removeSession(SessionImplSocket session) {
        if (session != null) {
            this.fireSessionClosed(session, null);
            GraphClient graphClient = session.getGraphSession().graphClient;
            this.sessionMap.remove(graphClient);
        }
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    private void fireSessionOpened(SessionImplSocket session) {
        SessionEvent se = new SessionEvent((Session)session, null);
        SessionListener[] sessionListenerArray = this.sessionListeners.getListeners();
        int n = sessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionListener listener = sessionListenerArray[n2];
            listener.sessionOpened(se);
            ++n2;
        }
    }

    private void fireSessionClosed(SessionImplSocket session, Throwable cause) {
        SessionEvent se = new SessionEvent((Session)session, cause);
        SessionListener[] sessionListenerArray = this.sessionListeners.getListeners();
        int n = sessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionListener listener = sessionListenerArray[n2];
            listener.sessionClosed(se);
            ++n2;
        }
    }

    private void fireSessionException(SessionImplSocket session, Throwable cause) {
        SessionEvent se = new SessionEvent((Session)session, cause);
        SessionListener[] sessionListenerArray = this.sessionListeners.getListeners();
        int n = sessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionListener listener = sessionListenerArray[n2];
            listener.sessionException(se);
            ++n2;
        }
    }

    public void shutdown(GraphClientImpl graphClientImpl, Throwable cause) {
        SessionImplSocket s = this.sessionMap.get(graphClientImpl);
        if (s == null) {
            return;
        }
        this.fireSessionClosed(s, cause);
        this.sessionMap.remove(graphClientImpl);
    }

    public void exception(GraphClientImpl graphClientImpl, Throwable cause) {
        SessionImplSocket s = this.sessionMap.get(graphClientImpl);
        if (s == null) {
            return;
        }
        this.fireSessionException(s, cause);
    }

    public SessionErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(SessionErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

