/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.internal.GraphSessionInit;
import fi.vtt.simantics.procore.internal.ServiceLocatorImpl;
import fi.vtt.simantics.procore.internal.SessionManagerImpl;
import java.io.IOException;
import java.util.HashSet;
import org.simantics.db.ServiceLocator;
import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.exception.InvalidAuthenticationException;
import org.simantics.db.exception.InvalidUserException;
import org.simantics.db.exception.ServiceNotFoundException;
import org.simantics.db.procore.protocol.SessionException;
import org.simantics.db.service.InitSupport;

public final class SessionImplInit
implements InitSupport,
ServiceLocator {
    private final ServiceLocatorImpl serviceLocator = new ServiceLocatorImpl();
    private SessionManagerImpl sessionManagerImpl = null;
    private GraphSessionInit graphSessionInit = null;

    public SessionImplInit(SessionManager sessionManager) {
        this.sessionManagerImpl = (SessionManagerImpl)sessionManager;
    }

    public final void close() throws InternalException {
        if (this.graphSessionInit != null) {
            try {
                try {
                    this.graphSessionInit.stop();
                }
                catch (InterruptedException e) {
                    throw new InternalException("Failed to stop init session cleanly.", (Throwable)e);
                }
            }
            finally {
                this.graphSessionInit = null;
                this.sessionManagerImpl = null;
            }
        }
    }

    public final void connect(SessionReference sessionReference) throws DatabaseException {
        assert (sessionReference != null);
        assert (sessionReference instanceof ProCoreSessionReference);
        this.graphSessionInit = new GraphSessionInit(sessionReference);
        try {
            this.graphSessionInit.connect(this.sessionManagerImpl);
        }
        catch (InvalidAuthenticationException e) {
            throw e;
        }
        catch (InvalidUserException e) {
            throw e;
        }
        catch (IOException e) {
            this.graphSessionInit = null;
            throw new SessionException((Throwable)e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.graphSessionInit = null;
            throw new SessionException(e);
        }
    }

    public <T> T getService(Class<T> api) {
        T t = this.peekService(api);
        if (t == null) {
            throw new ServiceNotFoundException((ServiceLocator)this, api);
        }
        return t;
    }

    public <T> T peekService(Class<T> api) {
        if (InitSupport.class == api) {
            return (T)this;
        }
        return null;
    }

    public boolean hasService(Class<?> api) {
        return this.serviceLocator.hasService(api);
    }

    public <T> void registerService(Class<T> api, T service) {
        this.serviceLocator.registerService(api, service);
    }

    public void addBuiltins(HashSet<InitSupport.Builtin> builtins) throws InternalException {
        this.getService(InitSupport.class).addBuiltins(builtins);
    }
}

