/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;

public class ReservedIds {
    private File file = null;
    private boolean loaded = false;
    private Data data = new Data();

    ReservedIds(File workDir, String id) {
        if (!workDir.isDirectory() && !workDir.mkdir()) {
            throw new RuntimeDatabaseException("Work directory not correct: " + workDir.getPath());
        }
        String name = String.valueOf(workDir.getPath()) + File.separator + "reservedIds." + id;
        this.file = new File(name);
    }

    public boolean loaded() {
        return this.loaded;
    }

    public Data load() {
        try {
            if (this.file == null || !this.file.exists()) {
                return this.data;
            }
            this.loadInternal();
            this.loaded = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.defaultLogError((String)"Failed to load reserved ids.", (Throwable)e);
            return null;
        }
        return this.data;
    }

    public void create(int idCount, long nextId) {
        this.data.idCount = idCount;
        this.data.nextId = nextId;
        this.saveNoThrow(idCount, nextId);
        this.loaded = true;
    }

    public void saveNoThrow(int idCount, long nextId) {
        try {
            this.save(idCount, nextId);
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.defaultLogError((String)"Failed to load reserved ids.", (Throwable)e);
        }
    }

    public void save(int idCount, long nextId) throws IOException {
        this.data.idCount = idCount;
        this.data.nextId = nextId;
        FileOutputStream stream = new FileOutputStream(this.file);
        try {
            byte[] bytes = new byte[12];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.putInt(idCount);
            bb.putLong(nextId);
            ((OutputStream)stream).write(bb.array());
            ((OutputStream)stream).close();
        }
        finally {
            ((OutputStream)stream).close();
        }
        this.loaded = true;
    }

    public void mergeToFile(File toFile) throws DatabaseException {
        byte[] bytes;
        if (!this.loaded) {
            this.load();
        }
        long next = this.data.nextId + (long)this.data.idCount;
        if (toFile.isDirectory()) {
            toFile = new File(toFile, this.file.getName());
        } else if (toFile.exists()) {
            try {
                InputStream is = null;
                try {
                    ByteBuffer bb;
                    long oldNext;
                    is = new FileInputStream(toFile);
                    bytes = new byte[8];
                    int n = is.read(bytes);
                    if (n == 8 && (oldNext = (bb = ByteBuffer.wrap(bytes)).getLong()) > next) {
                        next = oldNext;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                String msg = "Could not open file " + toFile.getAbsolutePath() + ".";
                Logger.defaultLogError((String)msg, (Throwable)e);
                throw new DatabaseException(msg, (Throwable)e);
            }
        }
        try {
            FileOutputStream stream = new FileOutputStream(toFile);
            try {
                bytes = new byte[8];
                ByteBuffer bb = ByteBuffer.wrap(bytes);
                bb.putLong(next);
                ((OutputStream)stream).write(bb.array());
                ((OutputStream)stream).close();
            }
            finally {
                ((OutputStream)stream).close();
            }
        }
        catch (IOException e) {
            String msg = "Could not save file " + toFile.getAbsolutePath() + ".";
            Logger.defaultLogError((String)msg, (Throwable)e);
            throw new DatabaseException(msg, (Throwable)e);
        }
    }

    private void loadInternal() throws IOException {
        FileInputStream is = new FileInputStream(this.file);
        try {
            byte[] bytes = new byte[12];
            int n = ((InputStream)is).read(bytes);
            if (n != 12) {
                return;
            }
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            this.data.idCount = bb.getInt();
            this.data.nextId = bb.getLong();
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static class Data {
        int idCount = 0;
        long nextId = 0L;
    }
}

