/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.Operation;
import org.simantics.db.service.ExternalOperation;

public class OperationImpl
implements Operation {
    private final long id;
    private final long csid;
    private final List<Operation> operations;
    private final List<Operation> selfOperations;
    private final List<ExternalOperation> externals;

    OperationImpl(long id, long csid) {
        this(id, csid, new ArrayList<ExternalOperation>());
    }

    OperationImpl(long id, long csid, List<ExternalOperation> externals) {
        this.id = id;
        this.csid = csid;
        this.operations = new ArrayList<Operation>();
        this.selfOperations = new ArrayList<Operation>(1);
        this.selfOperations.add(this);
        this.externals = externals;
    }

    public String toString() {
        return "Operation id=" + this.id + " cs=" + this.csid + ".";
    }

    public long getId() {
        return this.id;
    }

    public long getCSId() {
        return this.csid;
    }

    public int combine(Operation operation) {
        if (this.operations.size() == 0) {
            for (Operation o : operation.getOperations()) {
                this.operations.add(o);
            }
            this.operations.add(this);
        } else {
            for (Operation o : operation.getOperations()) {
                this.operations.add(o);
            }
        }
        return this.operations.size();
    }

    public List<Operation> getOperations() {
        if (this.operations.size() > 0) {
            return this.operations;
        }
        return this.selfOperations;
    }

    public Collection<ExternalOperation> getExternalOperations() {
        return this.externals;
    }
}

