/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Formatter;

class HashFunctionTest {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] byteToHexPair;

    static {
        char[] hexDigits = "0123456789abcdef".toCharArray();
        byteToHexPair = new char[512];
        int i = 0;
        int o = 0;
        while (i < 256) {
            HashFunctionTest.byteToHexPair[o++] = hexDigits[i >>> 4];
            HashFunctionTest.byteToHexPair[o++] = hexDigits[i & 0xF];
            ++i;
        }
    }

    HashFunctionTest() {
    }

    public static String calculateHash(MessageDigest algorithm, String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        BufferedInputStream bis = new BufferedInputStream(fis);
        DigestInputStream dis = new DigestInputStream(bis, algorithm);
        while (dis.read() != -1) {
        }
        byte[] hash = algorithm.digest();
        return HashFunctionTest.byteArray2Hex(hash);
    }

    private static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        return formatter.toString();
    }

    public static String asHex2(byte[] buf) {
        String s = new BigInteger(1, buf).toString(16);
        return s.length() % 2 == 0 ? s : "0" + s;
    }

    public static String asHex3(byte[] buf) {
        char[] chars = new char[2 * buf.length];
        int i = 0;
        while (i < buf.length) {
            chars[2 * i] = HEX_CHARS[(buf[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[buf[i] & 0xF];
            ++i;
        }
        return new String(chars);
    }

    public static String asHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        int i = 0;
        while (i < buf.length) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
            ++i;
        }
        return strbuf.toString();
    }

    public String toHex(byte[] bytes) {
        char[] out = new char[bytes.length * 2];
        int i = 0;
        while (i < bytes.length) {
            out[2 * i] = DIGITS[bytes[i] < 0 ? 8 + (bytes[i] + 128) / 16 : bytes[i] / 16];
            out[2 * i + 1] = DIGITS[bytes[i] < 0 ? (bytes[i] + 128) % 16 : bytes[i] % 16];
            ++i;
        }
        return new String(out);
    }

    public String toHex2(byte[] array) {
        String output = "";
        int i = 0;
        while (i < array.length / 4) {
            int ii = i * 4;
            int inty = array[ii] + array[ii + 1] * 255 + array[ii + 2] * 65535 + array[ii + 3] * 0xFFFFFF;
            output = String.valueOf(Integer.toHexString(inty)) + output;
            ++i;
        }
        return output;
    }

    public static String asHex4(byte[] buf) {
        int size = buf.length;
        char[] chars = new char[2 * size];
        int i = 0;
        int o = 0;
        while (i < size) {
            int index = buf[i];
            chars[o++] = byteToHexPair[index++];
            chars[o++] = byteToHexPair[index];
            ++i;
        }
        return new String(chars);
    }

    public static void main(String[] args) throws Exception {
        String fileName = "javablogging.png";
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        System.out.println(HashFunctionTest.calculateHash(sha1, fileName));
        System.out.println(HashFunctionTest.calculateHash(md5, fileName));
    }
}

