/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.ServerInformationImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SynchronizeContextI;
import org.simantics.db.SessionReference;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procore.protocol.AcceptCommitFunction;
import org.simantics.db.procore.protocol.AskTransactionFunction;
import org.simantics.db.procore.protocol.CancelCommitFunction;
import org.simantics.db.procore.protocol.EndTransactionFunction;
import org.simantics.db.procore.protocol.GetServerInfoFunction;
import org.simantics.db.procore.protocol.ReserveIdsFunction;

final class GraphSessionSocket
extends GraphSession {
    public GraphSessionSocket(SessionImplSocket sessionImpl, SessionReference sessionReference) {
        super(sessionImpl, sessionReference);
    }

    @Override
    protected ServerInformationImpl getServerInformation() {
        GetServerInfoFunction t = new GetServerInfoFunction();
        try {
            this.graphClient.call(t, null);
        }
        catch (Throwable e) {
            return null;
        }
        return new ServerInformationImpl(t.serverId, t.protocolId, t.databaseId);
    }

    @Override
    public long askReadTransaction(int thread) throws DatabaseException {
        AskTransactionFunction t = new AskTransactionFunction(0, 0L);
        this.graphClient.call(t, null);
        this.updateLastChangeSetId(thread, t.headChangeSetId, true);
        return t.transactionId;
    }

    @Override
    public long askWriteTransaction(int thread, long transactionId) throws DatabaseException {
        AskTransactionFunction t = new AskTransactionFunction(1, transactionId);
        this.graphClient.call(t, null);
        this.updateLastChangeSetId(thread, t.headChangeSetId, true);
        return t.transactionId;
    }

    @Override
    public void endTransaction(long transactionId, boolean write) throws DatabaseException {
        EndTransactionFunction t = new EndTransactionFunction(transactionId);
        this.graphClient.call(t, null);
        this.updateLastChangeSetId(Integer.MIN_VALUE, t.headChangeSetId, false);
    }

    @Override
    public void cancelCommit(long transactionId, long csid, byte[] metadata, SynchronizeContextI context) throws DatabaseException {
        CancelCommitFunction t = new CancelCommitFunction(transactionId, csid, metadata);
        try {
            assert (this.synchronizeContext == null);
            this.synchronizeContext = context;
            this.graphClient.call(t, null);
            if (csid + 1L != t.headChangeSetId) {
                Logger.defaultLogError((String)("Client and server out of synchronisation. Client cs=" + (csid + 1L) + "server cs=" + t.headChangeSetId));
            }
            this.metadataCache.addNext(t.headChangeSetId, metadata);
        }
        finally {
            this.synchronizeContext = null;
        }
    }

    @Override
    public void acceptCommit(long transactionId, long csid, byte[] metadata) throws DatabaseException {
        AcceptCommitFunction t = new AcceptCommitFunction(transactionId, csid, metadata);
        this.graphClient.call(t, null);
        this.metadataCache.addNext(csid + 1L, metadata);
    }

    @Override
    public void stop() throws InterruptedException {
        if (this.graphClient.isConnected()) {
            try {
                this.graphClient.disconnect();
            }
            catch (Throwable e) {
                Logger.defaultLogError((String)"Disconnect failed. See exception for details.", (Throwable)e);
                this.graphClient = null;
            }
        }
    }

    @Override
    public long reserveIds(int count) {
        Logger.defaultLogTrace((String)("Asking for ids " + count + "."));
        ReserveIdsFunction t = new ReserveIdsFunction(count);
        try {
            this.graphClient.call(t, null);
        }
        catch (Throwable e) {
            throw new Error("Not handled.", e);
        }
        Logger.defaultLogTrace((String)("First id is " + t.firstId + "."));
        return t.firstId;
    }
}

