/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.internal.ServerInformationImpl;
import fi.vtt.simantics.procore.internal.SessionManagerImpl;
import org.simantics.db.SessionReference;
import org.simantics.db.procore.protocol.AAAFunction;
import org.simantics.db.procore.protocol.AbstractGraphClientEventHandler;
import org.simantics.db.procore.protocol.GetServerInfoFunction;
import org.simantics.db.procore.protocol.GraphClient;
import org.simantics.db.procore.protocol.GraphClientEventHandler;
import org.simantics.db.procore.protocol.OpenClientSessionFunction;
import org.simantics.db.procore.protocol.ProtocolException;

final class GraphSessionInit
extends AbstractGraphClientEventHandler {
    private ProCoreSessionReference sessionReference;
    private GraphClient graphClient;
    private int callbackSent = 0;
    private int callbackReceived = 0;

    public GraphSessionInit(SessionReference sessionReference) {
        assert (sessionReference != null);
        assert (sessionReference instanceof ProCoreSessionReference);
        this.sessionReference = (ProCoreSessionReference)sessionReference;
    }

    ProCoreSessionReference getSessionReference() {
        return this.sessionReference;
    }

    public void connect(SessionManagerImpl sessionManagerImpl) throws Throwable {
        this.graphClient = sessionManagerImpl.newGraphClient((GraphClientEventHandler)this);
        this.start();
    }

    public long getSessionId() {
        return this.sessionReference.sessionId;
    }

    public String getHost() {
        return this.sessionReference.serverReference.socketAddress.getHostName();
    }

    public int getPort() {
        return this.sessionReference.serverReference.socketAddress.getPort();
    }

    private void checkProtocol(String protocolId) throws ProtocolException {
        String[] strings = protocolId.split("\\.");
        if (strings.length != 2) {
            throw new ProtocolException("Illegal protocolId=" + protocolId);
        }
        int major = Integer.parseInt(strings[0]);
        int minor = Integer.parseInt(strings[1]);
        if (major != 22) {
            throw new ProtocolException("Protocol major version mismatch: plugin=22 server=" + major);
        }
        if (minor < 0) {
            throw new ProtocolException("Protocol minor version mismatch: plugin=0 server=" + minor);
        }
    }

    public void start() throws Throwable {
        this.graphClient.connect(this.sessionReference.serverReference.socketAddress);
        AAAFunction af = new AAAFunction();
        this.graphClient.call(af, null);
        this.checkProtocol(af.args[0]);
        OpenClientSessionFunction ocs = new OpenClientSessionFunction((int)this.getSessionId());
        this.graphClient.call(ocs, null);
        if (-1L == this.getSessionId() || -1 == ocs.sessionId) {
            int newSessionId = ocs.sessionId;
            this.sessionReference = new ProCoreSessionReference(this.sessionReference.serverReference, newSessionId);
        }
    }

    ServerInformationImpl getServerInformation() {
        GetServerInfoFunction t = new GetServerInfoFunction();
        try {
            this.graphClient.call(t, null);
        }
        catch (Throwable e) {
            return null;
        }
        return new ServerInformationImpl(t.serverId, t.protocolId, t.databaseId);
    }

    public void stop() throws InterruptedException {
        if (this.graphClient.isConnected()) {
            while (this.callbackSent > this.callbackReceived) {
                Thread.sleep(1L);
            }
            try {
                this.graphClient.disconnect();
            }
            catch (Throwable e) {
                this.graphClient = null;
            }
        }
    }
}

