/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.internal.BuiltinData;
import fi.vtt.simantics.procore.internal.ChangeSetIdentifierImpl;
import fi.vtt.simantics.procore.internal.ReservedIds;
import fi.vtt.simantics.procore.internal.ServerInformationImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SessionManagerImpl;
import fi.vtt.simantics.procore.internal.StatementImpl;
import fi.vtt.simantics.procore.internal.StatementImplOld;
import fi.vtt.simantics.procore.internal.SynchronizeContextI;
import gnu.trove.THashMap;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectIterator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Operation;
import org.simantics.db.SessionReference;
import org.simantics.db.common.UndoContextEx;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.protocol.AAAFunction;
import org.simantics.db.procore.protocol.AbstractGraphClientEventHandler;
import org.simantics.db.procore.protocol.AskToRelinquishEvent;
import org.simantics.db.procore.protocol.ChangeSetUpdateEvent;
import org.simantics.db.procore.protocol.ClusterDecompressor;
import org.simantics.db.procore.protocol.EchoFunction;
import org.simantics.db.procore.protocol.EventException;
import org.simantics.db.procore.protocol.ExecuteFunction;
import org.simantics.db.procore.protocol.GetChangeSetContextFunction;
import org.simantics.db.procore.protocol.GetChangeSetDataFunction;
import org.simantics.db.procore.protocol.GetChangeSetsFunction;
import org.simantics.db.procore.protocol.GetClusterNewFunction;
import org.simantics.db.procore.protocol.GetRefreshFunction;
import org.simantics.db.procore.protocol.GetResourceSegmentFunction;
import org.simantics.db.procore.protocol.GraphClient;
import org.simantics.db.procore.protocol.GraphClientEventHandler;
import org.simantics.db.procore.protocol.GraphClientImpl;
import org.simantics.db.procore.protocol.OpenClientSessionFunction;
import org.simantics.db.procore.protocol.ProtocolException;
import org.simantics.db.procore.protocol.RefreshFunction;
import org.simantics.db.procore.protocol.SinkFunction;
import org.simantics.db.procore.protocol.UndoFunction;
import org.simantics.db.procore.protocol.UpdateClusterFunction;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ExternalOperation;
import org.simantics.db.service.ManagementSupport;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.utils.threads.ThreadUtils;

public abstract class GraphSession
extends AbstractGraphClientEventHandler {
    protected final boolean DEBUG = false;
    protected final boolean VERBOSE = false;
    protected Listener listener;
    protected SessionImplSocket session;
    private ProCoreSessionReference sessionReference;
    GraphClient graphClient;
    private TLongObjectHashMap<ClusterI> clusterMap = new TLongObjectHashMap();
    protected THashMap<String, BuiltinData> builtinMap = null;
    private long firstChangeSetId = 0L;
    protected SynchronizeContextI synchronizeContext;
    protected ClusterDecompressor clusterDecompressor = new ClusterDecompressor();
    private int idCount = 0;
    private long nextId = 0L;
    private static final int idBlockSize = 256;
    private ReservedIds reservedIds = null;
    final UndoContextEx undoContext = new UndoContextEx("GraphSession");
    final CopyOnWriteArrayList<ManagementSupport.ChangeSetListener> changeSetListeners = new CopyOnWriteArrayList();
    private long lastChangeSetId = 0L;
    protected MetadataCache metadataCache = new MetadataCache();
    private HashSet<Long> loadedClusters = new HashSet();
    long total = 0L;
    long load = 0L;
    long inflate = 0L;

    public GraphSession(SessionImplSocket sessionImpl, SessionReference sessionReference) {
        assert (sessionReference != null);
        assert (sessionReference instanceof ProCoreSessionReference);
        this.sessionReference = (ProCoreSessionReference)sessionReference;
        if (this.sessionReference.clientDir != null && this.sessionReference.clientId != null) {
            try {
                this.reservedIds = new ReservedIds(this.sessionReference.clientDir, this.sessionReference.clientId);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.reservedIds = null;
            }
        }
        this.session = sessionImpl;
    }

    public void mergeToFile(File to) throws DatabaseException {
        this.reservedIds.mergeToFile(to);
    }

    void addChangeSetListener(ManagementSupport.ChangeSetListener csl) {
        this.changeSetListeners.add(csl);
    }

    void removeChangeSetListener(ManagementSupport.ChangeSetListener csl) {
        this.changeSetListeners.remove(csl);
    }

    String getReservedIds() {
        return String.valueOf(this.nextId) + "-" + (this.nextId + 256L - 1L);
    }

    ProCoreSessionReference getSessionReference() {
        return this.sessionReference;
    }

    public void connect(SessionManagerImpl sessionManagerImpl) throws Throwable {
        this.graphClient = sessionManagerImpl.newGraphClient((GraphClientEventHandler)this);
        this.start();
    }

    public long getSessionId() {
        return this.sessionReference.sessionId;
    }

    public String getHost() {
        return this.sessionReference.serverReference.socketAddress.getHostName();
    }

    public int getPort() {
        return this.sessionReference.serverReference.socketAddress.getPort();
    }

    private void checkProtocol(String protocolId) throws ProtocolException {
        String[] strings = protocolId.split("\\.");
        if (strings.length != 2) {
            throw new ProtocolException("Illegal protocolId=" + protocolId);
        }
        int major = Integer.parseInt(strings[0]);
        int minor = Integer.parseInt(strings[1]);
        if (major != 22) {
            throw new ProtocolException("Protocol major version mismatch: plugin=22 server=" + major);
        }
        if (minor < 0) {
            throw new ProtocolException("Protocol minor version mismatch: plugin=0 server=" + minor);
        }
    }

    public void start() throws Throwable {
        this.graphClient.connect(this.sessionReference.serverReference.socketAddress);
        Logger.defaultLogInfo((String)("Start ok, connected to " + this.getHost() + ":" + this.getPort()));
        AAAFunction af = new AAAFunction();
        this.graphClient.call(af, null);
        this.checkProtocol(af.args[0]);
        OpenClientSessionFunction ocs = new OpenClientSessionFunction((int)this.getSessionId());
        this.graphClient.call(ocs, null);
        Logger.defaultLogInfo((String)("SessionId is " + ocs.sessionId));
        if (-1L == this.getSessionId() || -1 == ocs.sessionId) {
            int newSessionId = ocs.sessionId;
            this.sessionReference = new ProCoreSessionReference(this.sessionReference.serverReference, newSessionId);
        }
        this.updateLastChangeSetId(Integer.MIN_VALUE, ocs.headChangeSetId, false);
        this.firstChangeSetId = ocs.headChangeSetId;
    }

    long getFirstChangeSetId() {
        return this.firstChangeSetId;
    }

    String getClusterFileName(long clusterId) {
        String fileName = "cluster" + clusterId + ".dat";
        return fileName;
    }

    int computeClusterMemoryUse() {
        int size = 0;
        TLongObjectIterator i = this.clusterMap.iterator();
        while (i.hasNext()) {
            i.advance();
            ClusterI c = (ClusterI)i.value();
            try {
                size = (int)((long)size + c.getUsedSpace());
            }
            catch (DatabaseException e) {
                Logger.defaultLogInfo((String)("GetUsedSpace faile for cluster " + c));
            }
        }
        return size;
    }

    void printClusterSize() {
        long size = 0L;
        long amount = 0L;
        TLongObjectIterator i = this.clusterMap.iterator();
        while (i.hasNext()) {
            i.advance();
            ClusterI c = (ClusterI)i.value();
            if (!c.isLoaded()) continue;
            try {
                size += c.getUsedSpace();
            }
            catch (DatabaseException e) {
                Logger.defaultLogInfo((String)("GetUsedSpace faile for cluster " + c));
            }
            ++amount;
        }
        if (amount > 50L) {
            this.loadedClusters.clear();
        }
        System.out.println(size / 0x100000L + "M in " + amount + " clusters.");
    }

    ClusterI freeClusterFromCacheAndFreeClusterMemory(long clusterId) {
        ClusterI c = (ClusterI)this.clusterMap.remove(clusterId);
        if (c != null) {
            c.releaseMemory();
        }
        return c;
    }

    private void debugPrint(UpdateClusterFunction f) {
        int i = 0;
        while (i < f.operation.length) {
            System.out.println("op=" + f.operation[i]);
            ++i;
        }
    }

    public boolean updateCluster(UpdateClusterFunction f) {
        this.session.clusterStream.markDirty();
        assert (f != null);
        try {
            this.graphClient.call(f, null);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte[] getChangeSetContext(long id) throws InternalException {
        byte[] data = this.metadataCache.get(id);
        if (data != null) {
            return data;
        }
        GetChangeSetContextFunction t = new GetChangeSetContextFunction(id);
        this.graphClient.call(t, null);
        return t.changeSetContext;
    }

    public StatementImpl getStatement(ResourceImpl s, ResourceImpl p, ResourceImpl o) {
        return new StatementImplOld(s, p, o);
    }

    public long initialClusterId() {
        return this.nextId;
    }

    private void loadReservedIds() {
        ReservedIds.Data d = this.reservedIds.load();
        if (this.reservedIds.loaded()) {
            this.nextId = d.nextId;
            this.idCount = d.idCount;
        }
    }

    public long newClusterId() {
        if (this.reservedIds != null && !this.reservedIds.loaded()) {
            this.loadReservedIds();
        }
        if (this.idCount == 0) {
            try {
                long firstId = this.reserveIds(256);
                while (firstId + 1L <= this.nextId) {
                    Logger.defaultLogError((String)("Server returned too small idendtifier. id=" + firstId));
                    firstId = this.reserveIds(256);
                }
                this.nextId = firstId - 1L;
                this.idCount = 256;
            }
            catch (Throwable e) {
                this.idCount = 0;
                e.printStackTrace();
                Logger.defaultLogError((String)"Unexpected error occurred, see exception", (Throwable)e);
                throw new Error("Not handled.", e);
            }
        }
        --this.idCount;
        ++this.nextId;
        if (this.nextId == 1L) {
            --this.idCount;
            ++this.nextId;
        }
        if (this.reservedIds != null) {
            this.reservedIds.saveNoThrow(this.idCount, this.nextId);
        }
        if ((this.session.serviceMode & 2) > 0) {
            this.session.createdClusters.add(this.nextId);
        }
        return this.nextId;
    }

    public ClusterI getClusterImpl(ClusterUID clusterUID, int clusterKey) throws DatabaseException {
        assert (ClusterUID.isLegal((ClusterUID)clusterUID));
        GetClusterNewFunction t = new GetClusterNewFunction(clusterUID.asBytes());
        long start = System.nanoTime();
        this.graphClient.call(t, null);
        long duration = System.nanoTime() - start;
        this.load += duration;
        ByteBuffer deflated = t.deflated;
        start = System.nanoTime();
        Object[] arrays = this.clusterDecompressor.inflateCluster(t.inflateSize, deflated);
        duration = System.nanoTime() - start;
        this.inflate += duration;
        long[] longs = (long[])arrays[0];
        int[] ints = (int[])arrays[1];
        byte[] bytes = (byte[])arrays[2];
        ClusterImpl cluster = ClusterImpl.make(longs, ints, bytes, (ClusterSupport)this.session.clusterTranslator, clusterKey);
        return cluster;
    }

    ClusterI getCluster(long clusterId) {
        ClusterI c = (ClusterI)this.clusterMap.get(clusterId);
        if (c != null) {
            return c;
        }
        return c;
    }

    ClusterI getClusterOrThrow(long clusterId) throws IllegalArgumentException {
        ClusterI c = this.getCluster(clusterId);
        if (c == null) {
            throw new IllegalArgumentException("Cluster " + clusterId + " does not exist.");
        }
        return c;
    }

    public String execute(String command) throws DatabaseException {
        ExecuteFunction t = new ExecuteFunction(command);
        this.graphClient.call(t, null);
        if (t.out.endsWith("\n")) {
            return t.out.substring(0, t.out.length() - 1);
        }
        return t.out;
    }

    public Collection<ChangeSetIdentifier> getChangeSets() throws DatabaseException {
        GetChangeSetsFunction t = new GetChangeSetsFunction();
        this.graphClient.call(t, null);
        return ChangeSetIdentifierImpl.longs2changeSetIds(this, t.changeSetIds);
    }

    public long getLastChangeSetId() {
        return this.lastChangeSetId;
    }

    public Collection<ChangeSetIdentifier> getChangeSets(long from, long to, long upperLimit) throws DatabaseException {
        if (from > to) {
            throw new DatabaseException("Illegal argument: from=" + from + " > to=" + to + ".");
        }
        long min = Math.max(from, 1L);
        long max = Math.min(to, upperLimit);
        return ChangeSetIdentifierImpl.longs2changeSetIds(this, min, max);
    }

    public GetChangeSetDataFunction getChangeSets(long minCS, long maxCS, SynchronizeContextI context) throws DatabaseException {
        try {
            GetChangeSetDataFunction t = new GetChangeSetDataFunction(minCS, maxCS);
            this.synchronizeContext = context;
            this.graphClient.call(t, null);
            GetChangeSetDataFunction getChangeSetDataFunction = t;
            return getChangeSetDataFunction;
        }
        catch (Throwable e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException("GetChangeSetData call to server failed.");
        }
        finally {
            this.synchronizeContext = null;
        }
    }

    public RefreshFunction refresh(Collection<ChangeSetIdentifier> changeSetIds, SynchronizeContextI context) throws DatabaseException {
        try {
            RefreshFunction t = new RefreshFunction(ChangeSetIdentifierImpl.changeSetIds2ints(changeSetIds));
            this.synchronizeContext = context;
            this.graphClient.call(t, null);
            RefreshFunction refreshFunction = t;
            return refreshFunction;
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException("Refresh call to server failed.");
        }
        finally {
            this.synchronizeContext = null;
        }
    }

    public void onEvent(GraphClient session, ChangeSetUpdateEvent event) throws EventException {
        try {
            this.synchronizeContext.update(event);
        }
        catch (DatabaseException e) {
            throw new EventException("Failed to update change set.", (Throwable)e);
        }
    }

    public void onEvent(GraphClient session, AskToRelinquishEvent event) throws EventException {
    }

    public static void forExternals(Collection<Operation> operations, Function1<ExternalOperation, Boolean> fn) {
        for (Operation o : operations) {
            for (ExternalOperation e : o.getExternalOperations()) {
                if (e.isDisposed()) continue;
                fn.apply((Object)e);
            }
        }
    }

    public UndoFunction undo(Collection<Operation> changeSetIds, SynchronizeContextI context) throws DatabaseException {
        try {
            GraphSession.forExternals(changeSetIds, (Function1<ExternalOperation, Boolean>)new FunctionImpl1<ExternalOperation, Boolean>(){

                public Boolean apply(ExternalOperation op) {
                    op.undo();
                    return true;
                }
            });
            UndoFunction t = new UndoFunction(ChangeSetIdentifierImpl.operations2ints(changeSetIds));
            this.synchronizeContext = context;
            this.graphClient.call(t, null);
            UndoFunction undoFunction = t;
            return undoFunction;
        }
        catch (Throwable e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException("Undo call to server failed.", e);
        }
        finally {
            this.synchronizeContext = null;
        }
    }

    public Collection<ChangeSetIdentifier> getRefresh(long csid) throws DatabaseException {
        GetRefreshFunction t = new GetRefreshFunction(csid);
        this.graphClient.call(t, null);
        return ChangeSetIdentifierImpl.longs2changeSetIds(this, t.changeSetIds);
    }

    public long getCluster(int id) {
        return this.session.getCluster(id);
    }

    public void ping() throws DatabaseException {
        byte[] bytes = new byte[]{-1};
        EchoFunction t = new EchoFunction(bytes);
        this.graphClient.call(t, null);
        assert (t.bytes[0] == -1);
    }

    public void sink() throws DatabaseException {
        int[] ints = new int[]{-1};
        SinkFunction t = new SinkFunction(ints);
        this.graphClient.call(t, null);
    }

    public ResourceSegment getResourceSegment(int resourceIndex, ClusterUID clusterUID, long offset, short size) throws DatabaseException {
        GetResourceSegmentFunction t = new GetResourceSegmentFunction(clusterUID.asBytes(), resourceIndex, offset, size);
        this.graphClient.call(t, null);
        return new ResourceSegment(t.valueSize, t.segment);
    }

    public byte[] getResourceValue(int resourceIndex, ClusterUID clusterUID) throws DatabaseException {
        return this.getResourceValue(resourceIndex, clusterUID, 0L, 0);
    }

    public InputStream getResourceValueStream(final int resourceIndex, final ClusterUID clusterUID, long offset, int length) throws DatabaseException {
        long rSize;
        int IMAX = 65535;
        short slen = (short)Math.min(length != 0 ? length : 65535, 65535);
        ResourceSegment s = this.getResourceSegment(resourceIndex, clusterUID, offset, slen);
        long VALUE_SIZE = s.valueSize;
        if (s.valueSize < 0L) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + clusterUID + " off=" + offset + " len=" + length + " (1).");
        }
        int ilen = slen & 0xFFFF;
        assert (s.bytes.length <= ilen);
        if (length == 0) {
            if (s.valueSize > Integer.MAX_VALUE) {
                throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + clusterUID + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (2).");
            }
            length = (int)s.valueSize;
        }
        if ((rSize = s.valueSize - offset) < (long)length) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + clusterUID + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (3).");
        }
        if (length <= 65535) {
            return new ByteArrayInputStream(s.bytes);
        }
        int finalLength = length;
        return new InputStream(finalLength, s){
            int left;
            long valueOffset;
            int offset;
            ResourceSegment _s;
            {
                this.left = n;
                this.valueOffset = 0L;
                this.offset = 0;
                this._s = resourceSegment;
            }

            @Override
            public int read() throws IOException {
                int result;
                if (this.left <= 0) {
                    throw new IllegalStateException();
                }
                if (this.offset == this._s.bytes.length) {
                    short slen = (short)Math.min(this.left, 65535);
                    this.valueOffset += (long)this._s.bytes.length;
                    try {
                        this._s = GraphSession.this.getResourceSegment(resourceIndex, clusterUID, this.valueOffset, slen);
                    }
                    catch (DatabaseException e) {
                        throw new IOException(e);
                    }
                    this.offset = 0;
                }
                --this.left;
                if ((result = this._s.bytes[this.offset++]) < 0) {
                    result += 256;
                }
                return result;
            }
        };
    }

    public byte[] getResourceValue(int resourceIndex, ClusterUID clusterUID, long offset, int length) throws DatabaseException {
        long rSize;
        int IMAX = 65535;
        short slen = (short)Math.min(length != 0 ? length : 65535, 65535);
        ResourceSegment s = this.getResourceSegment(resourceIndex, clusterUID, offset, slen);
        long VALUE_SIZE = s.valueSize;
        if (s.valueSize < 0L) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + clusterUID + " off=" + offset + " len=" + length + " (1).");
        }
        int ilen = slen & 0xFFFF;
        assert (s.bytes.length <= ilen);
        if (length == 0) {
            if (s.valueSize > Integer.MAX_VALUE) {
                throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + clusterUID + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (2).");
            }
            length = (int)s.valueSize;
        }
        if ((rSize = s.valueSize - offset) < (long)length) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + clusterUID + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (3).");
        }
        if (length <= 65535) {
            return s.bytes;
        }
        byte[] bytes = new byte[length];
        int left = length - s.bytes.length;
        int cur = s.bytes.length;
        offset += (long)s.bytes.length;
        System.arraycopy(s.bytes, 0, bytes, 0, cur);
        while (left > 0) {
            slen = (short)Math.min(left, 65535);
            s = this.getResourceSegment(resourceIndex, clusterUID, offset, slen);
            ilen = slen & 0xFFFF;
            if (s.valueSize != VALUE_SIZE || s.bytes.length != ilen) {
                throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + clusterUID + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " blen=" + s.bytes.length + " (4).");
            }
            System.arraycopy(s.bytes, 0, bytes, cur, s.bytes.length);
            left -= s.bytes.length;
            cur += s.bytes.length;
            offset += (long)s.bytes.length;
        }
        return bytes;
    }

    public long getResourceValueSize(int resourceIndex, ClusterUID clusterUID) throws DatabaseException {
        int SMAX = -1;
        ResourceSegment s = this.getResourceSegment(resourceIndex, clusterUID, 0L, (short)-1);
        if (s.valueSize < 0L) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + clusterUID + " size=" + s.valueSize);
        }
        return s.valueSize;
    }

    int wait4RequestsLess(int limit) throws DatabaseException {
        return ((GraphClientImpl)this.graphClient).wait4RequestsLess(limit);
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    protected void updateLastChangeSetId(int thread, final long csid, boolean refresh) {
        if (this.listener != null) {
            this.listener.onChangeSetId(thread, csid, refresh);
        }
        if (csid > this.lastChangeSetId) {
            this.lastChangeSetId = csid;
            final Iterator<ManagementSupport.ChangeSetListener> it = this.changeSetListeners.iterator();
            ThreadUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    while (it.hasNext()) {
                        ManagementSupport.ChangeSetListener l = (ManagementSupport.ChangeSetListener)it.next();
                        try {
                            l.onChanged(csid);
                        }
                        catch (Throwable t) {
                            Logger.defaultLogError((Throwable)t);
                        }
                    }
                }
            });
        }
    }

    protected abstract ServerInformationImpl getServerInformation();

    public abstract void acceptCommit(long var1, long var3, byte[] var5) throws DatabaseException;

    public abstract void cancelCommit(long var1, long var3, byte[] var5, SynchronizeContextI var6) throws DatabaseException;

    public abstract void endTransaction(long var1, boolean var3) throws DatabaseException;

    public abstract long askWriteTransaction(int var1, long var2) throws DatabaseException;

    public abstract long askReadTransaction(int var1) throws DatabaseException;

    public abstract void stop() throws InterruptedException;

    public abstract long reserveIds(int var1) throws DatabaseException;

    static interface Listener {
        public void onChangeSetId(int var1, long var2, boolean var4);

        public void onRelinquish();

        public boolean onRelinquishOk();

        public void onRelinquishEnd();
    }

    static class MetadataCache {
        private final boolean DEBUG = false;
        private final int SIZE = 10;
        private int lastInd;
        private long lastId;
        private int count;
        Vector<byte[]> buffer;

        MetadataCache() {
            this.init();
        }

        public int clear() {
            int ret = this.count;
            this.init();
            return ret;
        }

        private void init() {
            this.lastInd = -1;
            this.lastId = 0L;
            this.count = 0;
            this.buffer = new Vector();
            this.buffer.setSize(10);
        }

        private boolean incLastInd() {
            ++this.lastInd;
            if (this.lastInd >= 10) {
                this.lastInd = 0;
                return true;
            }
            return false;
        }

        synchronized void addNext(long id, byte[] data) throws DatabaseException {
            if (this.lastId != 0L && this.lastId != id - 1L) {
                this.init();
            }
            this.incLastInd();
            this.buffer.set(this.lastInd, data);
            this.lastId = id;
            if (this.count < 10) {
                ++this.count;
            }
        }

        synchronized byte[] get(long id) {
            if (id > this.lastId || id <= this.lastId - (long)this.count) {
                return null;
            }
            int ind = this.lastInd - (int)(this.lastId - id);
            if (ind < 0) {
                ind += 10;
            }
            byte[] found = this.buffer.get(ind);
            return found;
        }
    }

    private static class ResourceSegment {
        public long valueSize;
        public byte[] bytes;

        ResourceSegment(long valueSize, byte[] bytes) {
            this.valueSize = valueSize;
            this.bytes = bytes;
        }
    }
}

