/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.simantics.db.Resource;
import org.simantics.db.service.FileSupport;

public class FileSupportImpl
implements FileSupport {
    private final SessionImplSocket session;

    FileSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public void write(Resource file, long offset, long length, byte[] bytes) {
        File f = new File(this.session.virtualGraphServerSupport.virtualGraphStoragePath, "files." + file.getResourceId());
        if (f.exists()) {
            throw new UnsupportedOperationException();
        }
        try {
            FileOutputStream fs = new FileOutputStream(f);
            fs.write(bytes, 0, (int)length);
            fs.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void truncate(Resource file, long size) {
        File f = new File(this.session.virtualGraphServerSupport.virtualGraphStoragePath, "files." + file.getResourceId());
        if (f.exists() && f.length() > size) {
            try {
                new RandomAccessFile(f, "rw").getChannel().truncate(size);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public long size(Resource file) {
        File f = new File(this.session.virtualGraphServerSupport.virtualGraphStoragePath, "files." + file.getResourceId());
        if (f.exists()) {
            throw new UnsupportedOperationException();
        }
        return f.length();
    }

    public byte[] read(Resource file, long offset, long length) {
        File f = new File(this.session.virtualGraphServerSupport.virtualGraphStoragePath, "files." + file.getResourceId());
        if (!f.exists()) {
            throw new UnsupportedOperationException();
        }
        try {
            byte[] result = new byte[(int)length];
            FileInputStream fs = new FileInputStream(f);
            fs.read(result, (int)offset, (int)length);
            return result;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new UnsupportedOperationException();
    }

    public void lock(Resource file, File target, long offset, long length) {
        File f = new File(this.session.virtualGraphServerSupport.virtualGraphStoragePath, "files." + file.getResourceId());
        if (!f.exists()) {
            throw new UnsupportedOperationException();
        }
        byte[] bytes = this.read(file, offset, length);
        try {
            FileOutputStream fs = new FileOutputStream(target);
            fs.write(bytes, 0, (int)length);
            fs.close();
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new UnsupportedOperationException();
    }

    public void release(Resource file, File target, long offset, long length) {
        throw new UnsupportedOperationException();
    }

    public void discard(Resource file, File target, long offset, long length) {
    }

    public void lock(Resource file, File target) {
        throw new UnsupportedOperationException();
    }

    public void release(Resource file, File target) {
        throw new UnsupportedOperationException();
    }

    public void discard(Resource file, File target) {
    }
}

