/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.DirectStatementImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.service.CollectionSupport;

public class CollectionSupportImpl
implements CollectionSupport {
    private final SessionImplSocket session;

    CollectionSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public IntResourceMap createIntResourceMap() {
        return new IntResourceMap(this.session);
    }

    public <T, I> T createObjectResourceMap(Class<I> clazz) {
        return (T)new ObjectResourceMap(this.session);
    }

    public <T, I> T createMap(Class<I> clazz) {
        return (T)new ResourceMap(this.session);
    }

    public Set<Resource> createSet() {
        return new ResourceSet(this.session);
    }

    public Set<Resource> createArraySet() {
        return new ResourceList(this.session);
    }

    public Collection<Resource> createList() {
        return new ResourceList(this.session);
    }

    public Collection<Statement> createStatementList() {
        return new StatementList(this.session);
    }

    public Collection<Resource> asSortedList(Collection<Resource> rs) {
        ResourceList result = new ResourceList(this.session);
        result.addAll((Collection<? extends Resource>)rs);
        result.sort();
        return result;
    }

    public org.simantics.db.ResourceSet getResourceSet(ReadGraph graph, Collection<Resource> resources) {
        if (resources instanceof ResourceSet) {
            return (org.simantics.db.ResourceSet)resources;
        }
        IntSet result = new IntSet(((ReadGraphImpl)graph).processor.querySupport);
        for (Resource r : resources) {
            result.add((Object)r);
        }
        return result;
    }

    public org.simantics.db.ResourceSet getResourceSet(ReadGraph graph, Resource ... rs) {
        IntSet result = new IntSet(((ReadGraphImpl)graph).processor.querySupport);
        Resource[] resourceArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            result.add((Object)r);
            ++n2;
        }
        return result;
    }

    static final class IntResourceMap {
        private final SessionImplSocket session;
        private final TIntIntHashMap backend = new TIntIntHashMap(10, 0.5f, -1, 0);

        IntResourceMap(SessionImplSocket session) {
            this.session = session;
        }

        public int size() {
            return this.backend.size();
        }

        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        public boolean containsKey(int key) {
            return this.backend.containsKey(key);
        }

        public boolean containsValue(int value) {
            return this.backend.containsValue(value);
        }

        public Resource get(int key) {
            try {
                return this.session.getResourceByKey(this.backend.get(key));
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Resource put(int key, Resource value) {
            ResourceImpl impl = (ResourceImpl)value;
            int i = this.backend.put(key, impl.id);
            if (i == 0) {
                return null;
            }
            try {
                return this.session.getResourceByKey(i);
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Resource remove(int key) {
            throw new Error("remove not supported");
        }
    }

    static final class ObjectResourceMap<T>
    implements Map<T, Resource> {
        private final SessionImplSocket session;
        private final TObjectIntHashMap<T> backend = new TObjectIntHashMap(10, 0.5f, 0);

        ObjectResourceMap(SessionImplSocket session) {
            this.session = session;
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.backend.contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            ResourceImpl impl = (ResourceImpl)value;
            return this.backend.containsValue(impl.id);
        }

        @Override
        public Resource get(Object key) {
            int result;
            block3: {
                try {
                    result = this.backend.get(key);
                    if (result != 0) break block3;
                    return null;
                }
                catch (ResourceNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return this.session.getResourceByKey(result);
        }

        @Override
        public Resource put(T key, Resource value) {
            ResourceImpl impl = (ResourceImpl)value;
            int i = this.backend.put(key, impl.id);
            if (i == 0) {
                return null;
            }
            try {
                return this.session.getResourceByKey(i);
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public Resource remove(Object key) {
            throw new Error("remove not supported");
        }

        @Override
        public void putAll(Map<? extends T, ? extends Resource> map) {
            ObjectResourceMap other = (ObjectResourceMap)map;
            other.backend.forEachEntry(new TObjectIntProcedure<T>(){

                public boolean execute(T a, int b) {
                    ObjectResourceMap.this.backend.put(a, b);
                    return true;
                }
            });
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<T> keySet() {
            final HashSet result = new HashSet();
            this.backend.forEach(new TObjectProcedure<T>(){

                public boolean execute(T object) {
                    result.add(object);
                    return true;
                }
            });
            return result;
        }

        @Override
        public Collection<Resource> values() {
            ArrayList<Resource> result = new ArrayList<Resource>();
            int[] nArray = this.backend.values();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int key = nArray[n2];
                try {
                    result.add(this.session.getResourceByKey(key));
                }
                catch (ResourceNotFoundException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            return result;
        }

        @Override
        public Set<Map.Entry<T, Resource>> entrySet() {
            final HashSet<Map.Entry<T, Resource>> result = new HashSet<Map.Entry<T, Resource>>();
            this.backend.forEachEntry(new TObjectIntProcedure<T>(){

                public boolean execute(final T a, final int b) {
                    return result.add(new Map.Entry<T, Resource>(){

                        @Override
                        public T getKey() {
                            return a;
                        }

                        @Override
                        public Resource getValue() {
                            return new ResourceImpl((ResourceSupport)((ObjectResourceMap)(this).ObjectResourceMap.this).session.resourceSupport, b);
                        }

                        @Override
                        public Resource setValue(Resource value) {
                            throw new Error("Not supported");
                        }
                    });
                }
            });
            return result;
        }
    }

    static final class ResourceList
    implements Collection<Resource>,
    Set<Resource> {
        private final SessionImplSocket session;
        private final TIntArrayList backend = new TIntArrayList();

        ResourceList(SessionImplSocket session) {
            this.session = session;
        }

        @Override
        public void clear() {
            throw new Error("Not implemented");
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean add(Resource resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            this.backend.add(impl.id);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Resource> rs) {
            boolean result = true;
            for (Resource resource : rs) {
                result &= this.add(resource);
            }
            return result;
        }

        @Override
        public boolean contains(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.contains(impl.id);
        }

        @Override
        public boolean containsAll(Collection<?> rs) {
            boolean result = true;
            for (Object r : rs) {
                result &= this.contains(r);
            }
            return result;
        }

        @Override
        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        @Override
        public Iterator<Resource> iterator() {
            return new Iterator<Resource>(){
                int index;
                {
                    this.index = ResourceList.this.backend.size();
                }

                @Override
                public boolean hasNext() {
                    return this.index > 0;
                }

                @Override
                public Resource next() {
                    return new ResourceImpl((ResourceSupport)((ResourceList)ResourceList.this).session.resourceSupport, ResourceList.this.backend.getQuick(--this.index));
                }

                @Override
                public void remove() {
                    ResourceList.this.backend.remove(this.index, 1);
                    throw new Error("Not supported");
                }
            };
        }

        @Override
        public boolean remove(Object resource) {
            throw new Error("Not implemented");
        }

        @Override
        public boolean removeAll(Collection<?> rs) {
            throw new Error("Not implemented");
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            throw new Error("Not implemented");
        }

        @Override
        public Object[] toArray() {
            throw new Error("Not implemented");
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            final Object[] result = (Object[])Array.newInstance(arg0.getClass().getComponentType(), this.backend.size());
            this.backend.forEach(new TIntProcedure(){
                int index = 0;

                public boolean execute(int value) {
                    result[this.index++] = new ResourceImpl((ResourceSupport)((ResourceList)ResourceList.this).session.resourceSupport, value);
                    return true;
                }
            });
            return result;
        }

        void sort() {
            this.backend.sort();
        }
    }

    static final class ResourceMap<T>
    implements Map<Resource, T> {
        private final SessionImplSocket session;
        private final TIntObjectHashMap<T> backend = new TIntObjectHashMap();

        ResourceMap(SessionImplSocket session) {
            this.session = session;
        }

        @Override
        public void clear() {
            throw new Error("Not implemented");
        }

        @Override
        public boolean containsKey(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.containsKey(impl.id);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.backend.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Resource, T>> entrySet() {
            final HashSet<Map.Entry<Resource, T>> result = new HashSet<Map.Entry<Resource, T>>();
            this.backend.forEachEntry(new TIntObjectProcedure<T>(){

                public boolean execute(final int a, final T b) {
                    result.add(new Map.Entry<Resource, T>(){

                        @Override
                        public Resource getKey() {
                            return new ResourceImpl((ResourceSupport)((ResourceMap)(this).ResourceMap.this).session.resourceSupport, a);
                        }

                        @Override
                        public T getValue() {
                            return b;
                        }

                        @Override
                        public T setValue(T arg0) {
                            throw new Error("Not supported");
                        }
                    });
                    return true;
                }
            });
            return result;
        }

        @Override
        public T get(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return (T)this.backend.get(impl.id);
        }

        @Override
        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        @Override
        public Set<Resource> keySet() {
            final ResourceSet result = new ResourceSet(this.session);
            this.backend.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    result.add(value);
                    return true;
                }
            });
            return result;
        }

        @Override
        public T put(Resource resource, T value) {
            ResourceImpl impl = (ResourceImpl)resource;
            return (T)this.backend.put(impl.id, value);
        }

        @Override
        public void putAll(Map<? extends Resource, ? extends T> map) {
            ResourceMap other = (ResourceMap)map;
            other.backend.forEachEntry(new TIntObjectProcedure<T>(){

                public boolean execute(int a, T b) {
                    ResourceMap.this.backend.put(a, b);
                    return true;
                }
            });
        }

        @Override
        public T remove(Object arg0) {
            throw new Error("Not implemented");
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public Collection<T> values() {
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] objectArray = this.backend.values();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                result.add(o);
                ++n2;
            }
            return result;
        }
    }

    static final class ResourceSet
    implements Set<Resource> {
        private final SessionImplSocket session;
        private final TIntHashSet backend = new TIntHashSet();

        ResourceSet(SessionImplSocket session) {
            this.session = session;
        }

        @Override
        public void clear() {
            this.backend.clear();
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean add(Resource resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.add(impl.id);
        }

        @Override
        boolean add(int id) {
            return this.backend.add(id);
        }

        @Override
        public boolean addAll(Collection<? extends Resource> rs) {
            boolean result = true;
            for (Resource resource : rs) {
                result &= this.add(resource);
            }
            return result;
        }

        @Override
        public boolean contains(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.contains(impl.id);
        }

        @Override
        public boolean containsAll(Collection<?> rs) {
            boolean result = true;
            for (Object r : rs) {
                result &= this.contains(r);
            }
            return result;
        }

        @Override
        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        @Override
        public Iterator<Resource> iterator() {
            return new Iterator<Resource>(){
                TIntIterator it;
                {
                    this.it = ResourceSet.this.backend.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Resource next() {
                    return new ResourceImpl((ResourceSupport)((ResourceSet)ResourceSet.this).session.resourceSupport, this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean remove(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.remove(impl.id);
        }

        @Override
        public boolean removeAll(Collection<?> rs) {
            boolean result = true;
            for (Object r : rs) {
                result &= this.remove(r);
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            throw new Error("Not implemented");
        }

        @Override
        public Object[] toArray() {
            throw new Error("Not implemented");
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            final Object[] result = (Object[])Array.newInstance(arg0.getClass().getComponentType(), this.backend.size());
            this.backend.forEach(new TIntProcedure(){
                int index = 0;

                public boolean execute(int value) {
                    result[this.index++] = new ResourceImpl((ResourceSupport)((ResourceSet)ResourceSet.this).session.resourceSupport, value);
                    return true;
                }
            });
            return result;
        }
    }

    static final class StatementList
    implements Collection<Statement> {
        private final SessionImplSocket session;
        private final TIntArrayList backend = new TIntArrayList();

        StatementList(SessionImplSocket session) {
            this.session = session;
        }

        @Override
        public void clear() {
            throw new Error("Not implemented");
        }

        @Override
        public int size() {
            return this.backend.size() / 3;
        }

        @Override
        public boolean add(Statement stm) {
            ResourceImpl s = (ResourceImpl)stm.getSubject();
            ResourceImpl p = (ResourceImpl)stm.getPredicate();
            ResourceImpl o = (ResourceImpl)stm.getObject();
            this.backend.add(s.id);
            this.backend.add(p.id);
            this.backend.add(o.id);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Statement> rs) {
            boolean result = true;
            for (Statement statement : rs) {
                result &= this.add(statement);
            }
            return result;
        }

        @Override
        public boolean contains(Object statement) {
            throw new Error("Not implemented");
        }

        @Override
        public boolean containsAll(Collection<?> rs) {
            throw new Error("Not implemented");
        }

        @Override
        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        @Override
        public Iterator<Statement> iterator() {
            return new Iterator<Statement>(){
                int index = 0;
                int max;
                {
                    this.max = StatementList.this.backend.size();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.max;
                }

                @Override
                public Statement next() {
                    return new DirectStatementImpl(((StatementList)StatementList.this).session.resourceSupport, StatementList.this.backend.getQuick(this.index++), StatementList.this.backend.getQuick(this.index++), StatementList.this.backend.getQuick(this.index++));
                }

                @Override
                public void remove() {
                    throw new Error("Not supported");
                }
            };
        }

        @Override
        public boolean remove(Object resource) {
            throw new Error("Not implemented");
        }

        @Override
        public boolean removeAll(Collection<?> rs) {
            throw new Error("Not implemented");
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            throw new Error("Not implemented");
        }

        @Override
        public Object[] toArray() {
            throw new Error("Not implemented");
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            final Object[] result = (Object[])Array.newInstance(arg0.getClass().getComponentType(), this.backend.size());
            this.backend.forEach(new TIntProcedure(){
                int index = 0;

                public boolean execute(int value) {
                    result[this.index++] = new ResourceImpl((ResourceSupport)((StatementList)StatementList.this).session.resourceSupport, value);
                    return true;
                }
            });
            return result;
        }
    }
}

