/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterCollector;
import fi.vtt.simantics.procore.internal.ClusterCollectorSupport;
import fi.vtt.simantics.procore.internal.ClusterCollectorSupportImpl;
import fi.vtt.simantics.procore.internal.ClusterControlImpl;
import fi.vtt.simantics.procore.internal.ClusterIds;
import fi.vtt.simantics.procore.internal.ClusterWriteOnly;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterSmall;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.service.ClusterCollectorPolicy;
import org.simantics.db.service.ClusterUID;
import org.simantics.utils.datastructures.Callback;

public final class ClusterTable {
    int maximumBytes = 0x4000000;
    long timeCounter = 0L;
    private final SessionImplSocket sessionImpl;
    private final ArrayList<ClusterI> writeOnlyClusters = new ArrayList();
    private static final int ARRAY_SIZE = ClusterTraits.getClusterArraySize();
    private final ClusterImpl[] clusterArray = new ClusterImpl[ARRAY_SIZE];
    private final boolean[] virtuals = new boolean[ARRAY_SIZE];
    public final TLongObjectHashMap<ClusterImpl> hashMap = new TLongObjectHashMap(2 * ARRAY_SIZE);
    public final TreeMap<Long, ClusterCollectorPolicy.CollectorCluster> importanceMap = new TreeMap();
    private ClusterCollectorPolicy collectorPolicy;
    private int clusterArraySize;
    private boolean dirtySizeInBytes = true;
    private long sizeInBytes = 0L;
    final ClusterIds clusterIds;
    private SizeProcedure sizeProcedure = new SizeProcedure();
    private ClusterCollectorSupport collectorSupport = new ClusterCollectorSupportImpl(this);
    ClusterCollectorImpl collector = new ClusterCollectorImpl(this.collectorSupport);
    private long newResourceClusterId = -2L;
    public static final int CLUSTER_FILL_SIZE = ClusterTraitsBase.getMaxNumberOfResources();
    int counter = 0;
    static long loadTime = 0L;
    Map<Long, ClusterImpl> prefetch = new HashMap<Long, ClusterImpl>();

    ClusterTable(SessionImplSocket sessionImpl, File folderPath) {
        this.sessionImpl = sessionImpl;
        this.clusterArraySize = 1;
        this.hashMap.put(0L, null);
        this.clusterIds = new ClusterIds(sessionImpl, folderPath);
    }

    void dispose() {
        this.hashMap.clear();
        this.importanceMap.clear();
    }

    public void setCollectorPolicy(ClusterCollectorPolicy policy) {
        this.collectorPolicy = policy;
    }

    private void setAllocateSize(double percentage) {
        percentage = Math.max(percentage, 0.05);
        percentage = Math.min(percentage, 0.5);
        this.maximumBytes = (int)Math.floor(percentage * (double)Runtime.getRuntime().maxMemory());
    }

    private double estimateProperAllocation(ClusterCollectorSupport support) {
        long max = Runtime.getRuntime().maxMemory();
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long realFree = max - total + free;
        long current = support.getCurrentSize();
        long inUseTotal = max - realFree;
        long inUseOther = inUseTotal - current;
        double otherUsePercentage = (double)inUseOther / (double)max;
        double aimFree = 0.2;
        double estimate = 1.0 - otherUsePercentage - aimFree;
        estimate = Math.min(estimate, 0.5);
        estimate = Math.max(estimate, 0.05);
        return estimate;
    }

    void checkCollect() {
        this.collector.collect();
    }

    synchronized ClusterImpl getClusterByClusterId(long clusterId) {
        return (ClusterImpl)this.hashMap.get(clusterId);
    }

    ClusterBase getClusterByClusterKey(int clusterKey) {
        return this.clusterArray[clusterKey];
    }

    synchronized ClusterSmall makeProxy(ClusterUID clusterUID, long clusterId) {
        ClusterImpl proxy = (ClusterImpl)this.hashMap.get(clusterId);
        if (proxy != null) {
            throw new IllegalArgumentException("Cluster l" + clusterId + " is already allocated.");
        }
        int clusterKey = this.clusterArraySize++;
        ClusterSmall sentinel = ClusterImpl.proxy(clusterUID, clusterKey, clusterId, (ClusterSupport)this.sessionImpl.clusterTranslator);
        this.clusterArray[clusterKey] = sentinel;
        this.hashMap.put(clusterId, (Object)sentinel);
        return sentinel;
    }

    synchronized ClusterImpl makeCluster(long clusterId, boolean writeOnly) {
        ClusterImpl cluster;
        ClusterUID clusterUID;
        int clusterKey;
        this.checkCollect();
        ClusterImpl proxy = (ClusterImpl)this.hashMap.get(clusterId);
        if (proxy == null) {
            clusterKey = this.clusterArraySize++;
            clusterUID = this.clusterIds.getClusterUIDOrCreate(clusterId);
        } else {
            clusterKey = proxy.getClusterKey();
            clusterUID = proxy.getClusterUID();
        }
        if (ClusterUID.Null.equals((Object)clusterUID)) {
            throw new RuntimeDatabaseException("Tying to create cluster without unique identifier.");
        }
        if (writeOnly) {
            proxy = new ClusterWriteOnly(clusterUID, clusterKey, this.sessionImpl);
            this.writeOnlyClusters.add((ClusterI)proxy);
            this.clusterArray[clusterKey] = proxy;
            this.hashMap.put(clusterId, (Object)proxy);
            return proxy;
        }
        this.clusterArray[clusterKey] = cluster = ClusterImpl.make(clusterUID, clusterKey, (ClusterSupport)this.sessionImpl.clusterTranslator);
        this.hashMap.put(clusterId, (Object)cluster);
        if (!cluster.isLoaded()) {
            Logger.defaultLogError((Throwable)new Exception("Bug in ClusterTable.makeCluster(long, boolean), cluster not loaded"));
        }
        this.importanceMap.put(cluster.getImportance(), new ImportanceEntry(cluster));
        if (this.collectorPolicy != null) {
            this.collectorPolicy.added((ClusterCollectorPolicy.CollectorCluster)cluster);
        }
        return cluster;
    }

    synchronized void replaceCluster(ClusterI cluster) {
        this.checkCollect();
        int clusterKey = cluster.getClusterKey();
        ClusterImpl existing = this.clusterArray[clusterKey];
        if (existing.hasVirtual()) {
            cluster.markVirtual();
        }
        this.importanceMap.remove(existing.getImportance());
        if (this.collectorPolicy != null) {
            this.collectorPolicy.removed((ClusterCollectorPolicy.CollectorCluster)existing);
        }
        this.clusterArray[clusterKey] = (ClusterImpl)cluster;
        this.hashMap.put(cluster.getClusterId(), (Object)((ClusterImpl)cluster));
        if (!cluster.isLoaded()) {
            Logger.defaultLogError((Throwable)new Exception("Bug in ClusterTable.replaceCluster(ClusterI), cluster not loaded"));
        }
        this.importanceMap.put(cluster.getImportance(), new ImportanceEntry((ClusterImpl)cluster));
        if (this.collectorPolicy != null) {
            this.collectorPolicy.added((ClusterCollectorPolicy.CollectorCluster)((ClusterImpl)cluster));
        }
        if (!this.dirtySizeInBytes && !existing.isLoaded()) {
            this.sizeInBytes += cluster.getCachedSize();
        }
    }

    synchronized void release(ClusterCollectorPolicy.CollectorCluster cluster) {
        this.importanceMap.remove(cluster.getImportance());
        this.release(cluster.getClusterId());
    }

    synchronized void release(long id) {
        ClusterI impl = (ClusterI)this.hashMap.get(id);
        if (impl == null) {
            return;
        }
        if (!impl.isLoaded() || impl.isEmpty()) {
            return;
        }
        long clusterId = impl.getClusterId();
        int clusterKey = impl.getClusterKey();
        ClusterUID clusterUID = impl.getClusterUID();
        ClusterSmall clusterSentinel = ClusterImpl.proxy(clusterUID, clusterKey, clusterId, (ClusterSupport)this.sessionImpl.clusterTranslator);
        this.clusterArray[clusterKey] = clusterSentinel;
        this.hashMap.put(clusterId, (Object)clusterSentinel);
        this.importanceMap.remove(impl.getImportance());
        if (this.collectorPolicy != null) {
            this.collectorPolicy.removed((ClusterCollectorPolicy.CollectorCluster)((ClusterImpl)impl));
        }
        if (this.sessionImpl.writeState != null) {
            this.sessionImpl.clusterStream.flush(id);
        }
        if (!this.dirtySizeInBytes) {
            this.sizeInBytes -= impl.getCachedSize();
        }
    }

    synchronized void compact(long id) {
        ClusterI impl = (ClusterI)this.hashMap.get(id);
        if (impl != null) {
            impl.compact();
        }
    }

    void updateSize() {
    }

    double getLoadProbability() {
        return 1.0;
    }

    long getSizeInBytes() {
        if (this.dirtySizeInBytes) {
            this.sizeProcedure.clear();
            this.hashMap.forEachValue((TObjectProcedure)this.sizeProcedure);
            this.sizeInBytes = this.sizeProcedure.result;
            this.setDirtySizeInBytes(false);
        }
        return this.sizeInBytes;
    }

    public void setDirtySizeInBytes(boolean value) {
        this.dirtySizeInBytes = value;
    }

    ClusterControlImpl.ClusterStateImpl getState() {
        final ClusterControlImpl.ClusterStateImpl result = new ClusterControlImpl.ClusterStateImpl();
        this.hashMap.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<ClusterImpl>(){

            public boolean execute(long arg0, ClusterImpl arg1) {
                if (arg1 == null) {
                    return true;
                }
                if (arg1.isLoaded() && !arg1.isEmpty()) {
                    result.ids.add(new ImportanceEntry(arg1));
                }
                return true;
            }
        });
        return result;
    }

    void restoreState(ClusterControlImpl.ClusterStateImpl state) {
        ClusterControlImpl.ClusterStateImpl current = this.getState();
        for (ClusterCollectorPolicy.CollectorCluster id : current.ids) {
            if (state.ids.contains(id)) continue;
            this.collectorSupport.release(id);
        }
    }

    void gc() {
        this.collector.collect();
    }

    ClusterImpl getNewResourceCluster(ClusterSupport cs, GraphSession graphSession, boolean writeOnly) throws DatabaseException {
        if (-2L == this.newResourceClusterId) {
            this.newResourceClusterId = graphSession.initialClusterId();
            return this.getLoadOrMakeCluster(this.newResourceClusterId, writeOnly);
        }
        if (-1L == this.newResourceClusterId) {
            this.newResourceClusterId = graphSession.newClusterId();
            return this.getClusterByClusterIdOrMake(this.newResourceClusterId, writeOnly);
        }
        ClusterImpl cluster = this.getClusterByClusterIdOrThrow(this.newResourceClusterId);
        if (cluster.getNumberOfResources(cs) >= CLUSTER_FILL_SIZE) {
            this.newResourceClusterId = graphSession.newClusterId();
            cluster = this.getClusterByClusterIdOrMake(this.newResourceClusterId, writeOnly);
        }
        return cluster;
    }

    void flushCluster(GraphSession graphSession) {
        this.newResourceClusterId = -1L;
    }

    void removeWriteOnlyClusters() {
        for (ClusterI proxy : this.writeOnlyClusters) {
            long clusterId = proxy.getClusterId();
            int clusterKey = proxy.getClusterKey();
            ClusterUID clusterUID = proxy.getClusterUID();
            ClusterSmall clusterSentinel = ClusterImpl.proxy(clusterUID, clusterKey, clusterId, (ClusterSupport)this.sessionImpl.clusterTranslator);
            this.clusterArray[clusterKey] = clusterSentinel;
            this.hashMap.put(clusterId, (Object)clusterSentinel);
        }
        this.writeOnlyClusters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterImpl getClusterByClusterUID(ClusterUID clusterUID) {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            Long clusterId;
            block6: {
                clusterId = this.clusterIds.getClusterId(clusterUID);
                if (clusterId != null) break block6;
                return null;
            }
            ClusterImpl cluster = (ClusterImpl)this.hashMap.get(clusterId.longValue());
            if (cluster != null) {
                return cluster;
            }
            if (ClusterUID.Builtin.equals((Object)clusterUID)) {
                return this.getClusterByClusterUIDOrMakeProxy(clusterUID);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterImpl getClusterByClusterUIDOrMakeProxy(ClusterUID clusterUID) {
        long clusterId;
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            clusterId = this.clusterIds.getClusterIdOrCreate(clusterUID);
            ClusterImpl proxy = (ClusterImpl)this.hashMap.get(clusterId);
            if (proxy != null) {
                return proxy;
            }
        }
        return this.makeProxy(clusterUID, clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterImpl getLoadOrMakeCluster(long clusterId, boolean writeOnly) {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            ClusterImpl proxy = (ClusterImpl)this.hashMap.get(clusterId);
            if (proxy != null) {
                return proxy;
            }
            ClusterUID clusterUID = this.clusterIds.getClusterUIDOrCreate(clusterId);
            ClusterSmall cluster = this.makeProxy(clusterUID, clusterId);
            ClusterImpl result = cluster.tryLoad(this.sessionImpl);
            if (result != null) {
                return result;
            }
            return this.makeCluster(clusterId, writeOnly);
        }
    }

    ClusterImpl getLoadOrThrow(long clusterId) throws ResourceNotFoundException {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            ClusterImpl proxy = (ClusterImpl)this.hashMap.get(clusterId);
            if (proxy != null) {
                return proxy;
            }
            ClusterUID clusterUID = this.clusterIds.getClusterUID(clusterId);
            if (clusterUID == null) {
                throw new ResourceNotFoundException("Cluster uid not found by id. id=" + clusterId);
            }
            ClusterSmall cluster = this.makeProxy(clusterUID, clusterId);
            ClusterImpl result = cluster.tryLoad(this.sessionImpl);
            if (result != null) {
                return result;
            }
            this.hashMap.remove(clusterId);
            if (cluster.getClusterKey() + 1 == this.clusterArraySize) {
                this.clusterArray[cluster.getClusterKey()] = null;
                --this.clusterArraySize;
            }
            throw new ResourceNotFoundException("Cluster " + clusterId + " not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterImpl getClusterByClusterIdOrMake(long clusterId, boolean writeOnly) {
        ClusterImpl proxy = (ClusterImpl)this.hashMap.get(clusterId);
        if (proxy != null) {
            return proxy;
        }
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            proxy = (ClusterImpl)this.hashMap.get(clusterId);
            if (proxy == null) {
                return this.makeCluster(clusterId, writeOnly);
            }
            return proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterImpl getClusterByClusterIdOrThrow(long clusterId) {
        ClusterTable clusterTable = this;
        synchronized (clusterTable) {
            ClusterImpl proxy = (ClusterImpl)this.hashMap.get(clusterId);
            if (proxy == null) {
                throw new IllegalArgumentException("Cluster id=" + clusterId + " is not created.");
            }
            return proxy;
        }
    }

    final long getClusterIdByResourceKey(int resourceKey) throws DatabaseException {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKey((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            throw new RuntimeException("Tried to get a persistent cluster for a virtual resource.");
        }
        ClusterImpl c = this.clusterArray[clusterKey];
        if (c == null) {
            throw new RuntimeException("No cluster for key " + resourceKey);
        }
        return c.getClusterId();
    }

    final long getClusterIdByResourceKeyNoThrow(int resourceKey) {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            Logger.defaultLogError((String)("Tried to get a persistent cluster for a virtual resource. key=" + resourceKey));
            return 0L;
        }
        ClusterImpl c = this.clusterArray[clusterKey];
        if (c == null) {
            Logger.defaultLogError((String)("No cluster for key " + resourceKey));
            return 0L;
        }
        return c.getClusterId();
    }

    final void refreshImportance(ClusterImpl c) {
        if (c.isWriteOnly()) {
            return;
        }
        this.importanceMap.remove(c.getImportance());
        if (this.collectorPolicy != null) {
            this.collectorPolicy.removed((ClusterCollectorPolicy.CollectorCluster)c);
        }
        long newImportance = this.timeCounter();
        c.setImportance(newImportance);
        if (!c.isLoaded()) {
            Logger.defaultLogError((Throwable)new Exception("Bug in ClusterTable.refreshImportance(ClusterImpl), cluster not loaded"));
        }
        this.importanceMap.put(c.getImportance(), new ImportanceEntry(c));
        if (this.collectorPolicy != null) {
            this.collectorPolicy.added((ClusterCollectorPolicy.CollectorCluster)c);
        }
    }

    public final <T extends ClusterI> T getClusterProxyByResourceKey(int resourceKey) {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            throw new RuntimeException("Tried to get a persistent cluster for a virtual resource.");
        }
        ClusterImpl cluster = this.clusterArray[clusterKey];
        if (cluster == null) {
            throw new RuntimeException("No proxy for existing cluster.");
        }
        return (T)cluster;
    }

    public final <T extends ClusterI> T getClusterByResourceKey(int resourceKey) {
        ClusterImpl cluster;
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            throw new RuntimeException("Tried to get a persistent cluster for a virtual resource.");
        }
        ClusterImpl c = this.clusterArray[clusterKey];
        if (c == null) {
            return null;
        }
        if (c.isLoaded()) {
            if ((this.counter++ & 0xFFF) == 0) {
                this.refreshImportance(c);
            }
            return (T)c;
        }
        if (!(c instanceof ClusterSmall)) {
            Logger.defaultLogError((String)"Proxy must be instance of ClusterSmall");
            return null;
        }
        ClusterSmall cs = (ClusterSmall)c;
        try {
            long start = System.nanoTime();
            cluster = this.load2(cs.getClusterId(), cs.getClusterKey());
            loadTime += System.nanoTime() - start;
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            String msg = "Failed to load cluster " + cs.getClusterUID() + " for resource key " + resourceKey + " resourceId=" + (cs.getClusterId() << 16 + (resourceKey & 0xFFFF));
            throw new RuntimeDatabaseException(msg, (Throwable)e);
        }
        return (T)cluster;
    }

    final <T extends ClusterI> T checkedGetClusterByResourceKey(int resourceKey) {
        ClusterImpl cluster;
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (ClusterTraitsBase.isVirtualClusterKey((int)clusterKey)) {
            throw new RuntimeException("Tried to get a persistent cluster for a virtual resource.");
        }
        ClusterImpl c = this.clusterArray[clusterKey];
        if (c == null) {
            throw new RuntimeException("No cluster for resource key " + resourceKey);
        }
        if (c.isLoaded()) {
            if ((this.counter++ & 0xFFF) == 0) {
                this.refreshImportance(c);
            }
            return (T)c;
        }
        if (!(c instanceof ClusterSmall)) {
            Logger.defaultLogError((String)"Proxy must be instance of ClusterSmall");
            return null;
        }
        ClusterSmall cs = (ClusterSmall)c;
        try {
            cluster = this.load2(cs.getClusterId(), cs.getClusterKey());
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            String msg = "Failed to load cluster " + cs.getClusterUID() + " for resource key " + resourceKey + " resourceId=" + (cs.getClusterId() << 16 + (resourceKey & 0xFFFF));
            throw new RuntimeDatabaseException(msg, (Throwable)e);
        }
        return (T)cluster;
    }

    void printDebugInfo(ClusterSupport support) throws DatabaseException {
        int SIZE = this.clusterArraySize;
        long sum = 0L;
        int i = 1;
        while (i < SIZE) {
            ClusterImpl c = this.clusterArray[i];
            c.getNumberOfResources(support);
            long size = c.getUsedSpace();
            System.out.println("cluster=" + c.getClusterId() + " size=" + size);
            c.printDebugInfo("koss: ", support);
            sum += size;
            ++i;
        }
        System.out.println("Total number of clusters " + SIZE);
        System.out.println("Total cluster size " + sum);
    }

    public synchronized ClusterImpl load2(long clusterId, int clusterKey) throws DatabaseException {
        ClusterImpl curr = this.clusterArray[clusterKey];
        if (curr.isLoaded()) {
            return curr;
        }
        final Semaphore s = new Semaphore(0);
        final DatabaseException[] ex = new DatabaseException[1];
        this.load2(clusterId, clusterKey, new Callback<DatabaseException>(){

            public void run(DatabaseException e) {
                ex[0] = e;
                s.release();
            }
        });
        try {
            s.acquire();
        }
        catch (InterruptedException e) {
            Logger.defaultLogError((Throwable)e);
        }
        if (ex[0] != null) {
            throw ex[0];
        }
        return this.clusterArray[clusterKey];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ClusterImpl getPrefetched() {
        Map<Long, ClusterImpl> map = this.prefetch;
        synchronized (map) {
            return null;
        }
    }

    public synchronized void load2(long clusterId, int clusterKey, Callback<DatabaseException> runnable) {
        assert (Long.MAX_VALUE != clusterId);
        ClusterImpl cluster = null;
        DatabaseException e = null;
        try {
            ClusterUID clusterUID = this.clusterIds.getClusterUID(clusterId);
            cluster = (ClusterImpl)this.sessionImpl.getGraphSession().getClusterImpl(clusterUID, clusterKey);
        }
        catch (Throwable t) {
            Logger.getDefault().logInfo("Load cluster failed.", t);
            e = t instanceof DatabaseException ? (DatabaseException)t : new DatabaseException("Load cluster failed.", t);
        }
        if (cluster == null) {
            runnable.run((Object)e);
            return;
        }
        this.replaceCluster((ClusterI)cluster);
        this.sessionImpl.onClusterLoaded(clusterId);
        runnable.run(null);
    }

    public synchronized ClusterImpl tryLoad(long clusterId, int clusterKey) {
        assert (Long.MAX_VALUE != clusterId);
        try {
            ClusterUID clusterUID = this.clusterIds.getClusterUID(clusterId);
            ClusterImpl cluster = (ClusterImpl)this.sessionImpl.getGraphSession().getClusterImpl(clusterUID, clusterKey);
            this.replaceCluster((ClusterI)cluster);
            this.sessionImpl.onClusterLoaded(clusterId);
            return cluster;
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    public Collection<ClusterI> getClusters() {
        ArrayList<ClusterI> result = new ArrayList<ClusterI>();
        int i = 0;
        while (i < this.clusterArray.length) {
            ClusterImpl cluster = this.clusterArray[i];
            if (cluster != null) {
                result.add((ClusterI)cluster);
            }
            ++i;
        }
        return result;
    }

    public int size() {
        return this.hashMap.size();
    }

    public long timeCounter() {
        return this.timeCounter++;
    }

    public boolean hasVirtual(int index) {
        return this.virtuals[index];
    }

    public void markVirtual(int index) {
        this.virtuals[index] = true;
    }

    public ClusterImpl[] getClusterArray() {
        return this.clusterArray;
    }

    class ClusterCollectorImpl
    implements ClusterCollector {
        private final ClusterCollectorSupport support;
        private ClusterCollectorPolicy policy;

        ClusterCollectorImpl(ClusterCollectorSupport support) {
            this.support = support;
        }

        ClusterCollectorPolicy setPolicy(ClusterCollectorPolicy newPolicy) {
            ClusterCollectorPolicy oldPolicy = this.policy;
            this.policy = newPolicy;
            if (this.policy != null) {
                for (ClusterCollectorPolicy.CollectorCluster id : this.support.getResidentClusters()) {
                    this.policy.added((ClusterCollectorPolicy.CollectorCluster)ClusterTable.this.getClusterByClusterId(id.getClusterId()));
                }
            }
            this.support.setPolicy(this.policy);
            return oldPolicy;
        }

        @Override
        public void collect() {
            if (this.policy != null) {
                this.release(this.policy.select());
            } else {
                int size = this.support.getCurrentSize();
                boolean dynamicAllocation = this.useDynamicAllocation();
                if (dynamicAllocation) {
                    ClusterTable.this.setAllocateSize(ClusterTable.this.estimateProperAllocation(this.support));
                }
                int collectSize = ClusterTable.this.maximumBytes / 2;
                if (dynamicAllocation) {
                    collectSize = Math.min(collectSize, 0x2000000);
                }
                if (ClusterTable.this.maximumBytes - size > collectSize) {
                    return;
                }
                this.collect(collectSize += size - ClusterTable.this.maximumBytes);
            }
        }

        private boolean useDynamicAllocation() {
            return "true".equalsIgnoreCase(System.getProperty("org.simantics.db.cluster.dynamicAlloc"));
        }

        @Override
        public void collect(int target) {
            if (this.policy != null) {
                this.release(this.policy.select(target));
            } else {
                ArrayList<ClusterCollectorPolicy.CollectorCluster> toRelease = new ArrayList<ClusterCollectorPolicy.CollectorCluster>();
                for (ClusterCollectorPolicy.CollectorCluster cluster : this.support.getResidentClusters()) {
                    if ((target = (int)((long)target - this.support.getClusterSize(cluster))) <= 0) break;
                    toRelease.add(cluster);
                }
                this.release(toRelease);
            }
        }

        void release(Collection<ClusterCollectorPolicy.CollectorCluster> toRelease) {
            for (ClusterCollectorPolicy.CollectorCluster id : toRelease) {
                this.support.release(id);
            }
        }
    }

    static class ImportanceEntry
    implements ClusterCollectorPolicy.CollectorCluster {
        public final long importance;
        public final long clusterId;

        public ImportanceEntry(ClusterImpl impl) {
            this(impl.getImportance(), impl.getClusterId());
        }

        public ImportanceEntry(long importance, long clusterId) {
            this.importance = importance;
            this.clusterId = clusterId;
        }

        public long getImportance() {
            return this.importance;
        }

        public long getClusterId() {
            return this.clusterId;
        }
    }

    class SizeProcedure
    implements TObjectProcedure<ClusterImpl> {
        public long result = 0L;

        SizeProcedure() {
        }

        public boolean execute(ClusterImpl cluster) {
            if (cluster != null) {
                try {
                    if (cluster.isLoaded() && !cluster.isEmpty()) {
                        this.result += cluster.getCachedSize();
                    }
                }
                catch (Throwable t) {
                    Logger.defaultLogError((Throwable)t);
                }
            }
            return true;
        }

        public void clear() {
            this.result = 0L;
        }
    }
}

