/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.Change;
import fi.vtt.simantics.procore.internal.ClusterChange;
import fi.vtt.simantics.procore.internal.ClusterChangeManager;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.util.ArrayList;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ClusterUID;

public final class ClusterStream {
    public static final boolean DEBUG = false;
    public static final byte NULL_OPERATION = 0;
    public static final byte CREATE_OPERATION = 1;
    public static final byte SET_OPERATION = 4;
    public static final byte MODI_OPERATION = 6;
    public static final byte KILL_OPERATION = 7;
    boolean off = false;
    public GraphSession graphSession;
    final SessionImplSocket session;
    private final boolean alwaysOff;
    private int stamp;
    private int acceptedStamp;
    private boolean dirty = false;
    final ClusterChangeManager changes = new ClusterChangeManager();

    ClusterStream(SessionImplSocket session, GraphSession graphSession, boolean alwaysOff) {
        this.session = session;
        this.graphSession = graphSession;
        this.alwaysOff = alwaysOff;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void markDirty() {
        this.dirty = true;
    }

    void setOff(boolean value) {
        this.off = this.alwaysOff ? true : value;
    }

    boolean getOff() {
        return this.off;
    }

    void createResource(ClusterChange cc, short operationIndex, ClusterUID clusterUID) {
        if (this.off) {
            return;
        }
        assert (cc != null);
        assert (operationIndex != 0);
        assert (!ClusterUID.Null.equals((Object)clusterUID));
        cc.createResource(operationIndex);
    }

    final void addStatementIndex(Change change, int key, ClusterUID clusterUID, byte op) {
        if (this.off) {
            return;
        }
        assert (key > 0);
        assert (change != null);
        assert (!ClusterUID.Null.equals((Object)clusterUID));
        change.addStatementIndex(key, clusterUID, op);
    }

    void addStatement(ClusterChange cc, Change change) {
        if (this.off) {
            return;
        }
        assert (cc != null);
        assert (change != null);
        cc.addChange(change);
    }

    void cancelStatement(Change change) {
        if (this.off) {
            return;
        }
        assert (change != null);
        change.init();
    }

    void removeStatement(ClusterChange cc, Change change, long clusterId) {
        if (this.off) {
            return;
        }
        assert (cc != null);
        assert (change != null);
        cc.addChange(change);
    }

    void cancelValue(Change change) {
        if (this.off) {
            return;
        }
        assert (change != null);
        change.init();
    }

    void removeValue(ClusterChange cc, Change change, long clusterId) {
        if (this.off) {
            return;
        }
        assert (cc != null);
        assert (change != null);
        cc.addChange(change);
    }

    void setValue(ClusterChange cc, Change change, long clusterId, byte[] bytes, int length) {
        if (this.off) {
            return;
        }
        assert (cc != null);
        assert (change != null);
        cc.setValue(change, bytes, length);
    }

    void modiValue(ClusterChange cc, Change change, long clusterId, long voffset, int length, byte[] bytes, int offset) {
        assert (cc != null);
        assert (change != null);
        cc.modiValue(change, voffset, length, bytes, offset);
    }

    void undoValueEx(ClusterChange cc, Change change, int resourceIndex) {
        cc.undoValueEx(resourceIndex);
    }

    void setImmutable(ClusterChange cc, Change change, long clusterId, boolean immutable) {
        if (this.off) {
            return;
        }
        cc.setImmutable(immutable);
    }

    public void corruptCluster(ClusterChange cc, long clusterId) throws DatabaseException {
        if (this.off) {
            return;
        }
        assert (cc != null);
        cc.corrupt();
    }

    int getStamp() {
        return this.stamp;
    }

    void flush() {
        if (this.off) {
            return;
        }
    }

    void flush(long clusterId) {
        if (this.off) {
            return;
        }
        ClusterUID clusterUID = this.session.clusterTable.clusterIds.getClusterUID(clusterId);
        ArrayList<ClusterChange> ccs = new ArrayList<ClusterChange>();
        for (ClusterChange cc : this.changes.get()) {
            if (!cc.clusterUID.equals((Object)clusterUID) || !cc.flush(this.graphSession, cc.clusterUID)) continue;
            ccs.add(cc);
            if (this.stamp != this.acceptedStamp) continue;
            ++this.stamp;
        }
        this.changes.remove(ccs);
    }

    public boolean reallyFlush() {
        this.session.handleCreatedClusters();
        this.session.clusterTable.removeWriteOnlyClusters();
        if (!this.off && this.changes.size() > 0) {
            for (ClusterChange cc : this.changes.get()) {
                if (!cc.flush(this.graphSession, cc.clusterUID) || this.stamp != this.acceptedStamp) continue;
                ++this.stamp;
            }
            this.changes.clear();
        }
        this.dirty = false;
        return this.hasAcceptedAllChanges();
    }

    public void clear() {
        this.changes.clear();
        this.acceptedStamp = this.stamp;
        this.dirty = false;
    }

    private boolean hasAcceptedAllChanges() {
        return this.stamp == this.acceptedStamp;
    }

    void accept() {
        this.acceptedStamp = this.stamp;
    }

    static enum ClusterEnum {
        Local(0),
        ForeignShort(1),
        ForeignLong(2);

        public int ordinal;
        static Data[][][] maps;

        static {
            maps = new Data[2][3][3];
            ClusterEnum.maps[StmEnum.Add.ordinal][ClusterEnum.Local.ordinal][ClusterEnum.Local.ordinal] = new Data(0, 2, Local, Local);
            ClusterEnum.maps[StmEnum.Add.ordinal][ClusterEnum.Local.ordinal][ClusterEnum.ForeignShort.ordinal] = new Data(12, 4, Local, ForeignShort);
            ClusterEnum.maps[StmEnum.Add.ordinal][ClusterEnum.Local.ordinal][ClusterEnum.ForeignLong.ordinal] = new Data(2, 2, Local, ForeignLong);
            ClusterEnum.maps[StmEnum.Add.ordinal][ClusterEnum.ForeignShort.ordinal][ClusterEnum.Local.ordinal] = new Data(13, 4, ForeignShort, Local);
            ClusterEnum.maps[StmEnum.Add.ordinal][ClusterEnum.ForeignShort.ordinal][ClusterEnum.ForeignShort.ordinal] = new Data(1, 6, ForeignShort, ForeignShort);
            ClusterEnum.maps[StmEnum.Add.ordinal][ClusterEnum.ForeignShort.ordinal][ClusterEnum.ForeignLong.ordinal] = new Data(14, 4, ForeignShort, ForeignLong);
            ClusterEnum.maps[StmEnum.Add.ordinal][ClusterEnum.ForeignLong.ordinal][ClusterEnum.Local.ordinal] = new Data(4, 2, ForeignLong, Local);
            ClusterEnum.maps[StmEnum.Add.ordinal][ClusterEnum.ForeignLong.ordinal][ClusterEnum.ForeignShort.ordinal] = new Data(15, 4, ForeignLong, ForeignShort);
            ClusterEnum.maps[StmEnum.Add.ordinal][ClusterEnum.ForeignLong.ordinal][ClusterEnum.ForeignLong.ordinal] = new Data(6, 2, ForeignLong, ForeignLong);
            ClusterEnum.maps[StmEnum.Remove.ordinal][ClusterEnum.Local.ordinal][ClusterEnum.Local.ordinal] = new Data(1, 2, Local, Local);
            ClusterEnum.maps[StmEnum.Remove.ordinal][ClusterEnum.Local.ordinal][ClusterEnum.ForeignShort.ordinal] = new Data(49, 0, Local, ForeignShort);
            ClusterEnum.maps[StmEnum.Remove.ordinal][ClusterEnum.Local.ordinal][ClusterEnum.ForeignLong.ordinal] = new Data(3, 2, Local, ForeignLong);
            ClusterEnum.maps[StmEnum.Remove.ordinal][ClusterEnum.ForeignShort.ordinal][ClusterEnum.Local.ordinal] = new Data(2, 4, ForeignShort, Local);
            ClusterEnum.maps[StmEnum.Remove.ordinal][ClusterEnum.ForeignShort.ordinal][ClusterEnum.ForeignShort.ordinal] = new Data(2, 6, ForeignShort, ForeignShort);
            ClusterEnum.maps[StmEnum.Remove.ordinal][ClusterEnum.ForeignShort.ordinal][ClusterEnum.ForeignLong.ordinal] = new Data(50, 0, ForeignShort, ForeignLong);
            ClusterEnum.maps[StmEnum.Remove.ordinal][ClusterEnum.ForeignLong.ordinal][ClusterEnum.Local.ordinal] = new Data(5, 2, ForeignLong, Local);
            ClusterEnum.maps[StmEnum.Remove.ordinal][ClusterEnum.ForeignLong.ordinal][ClusterEnum.ForeignShort.ordinal] = new Data(51, 0, ForeignLong, ForeignShort);
            ClusterEnum.maps[StmEnum.Remove.ordinal][ClusterEnum.ForeignLong.ordinal][ClusterEnum.ForeignLong.ordinal] = new Data(7, 2, ForeignLong, ForeignLong);
        }

        private ClusterEnum(int ordinal) {
            this.ordinal = ordinal;
        }

        static Data getData(StmEnum s, ClusterEnum a, ClusterEnum b) {
            return maps[s.ordinal][a.ordinal][b.ordinal];
        }
    }

    static final class Data {
        final byte mask;
        final short bits;
        final int bytes;

        Data(int mask, int bits, ClusterEnum a, ClusterEnum b) {
            this.mask = (byte)(mask << bits);
            this.bits = (short)bits;
            this.bytes = Data.bytes(bits, a, b);
        }

        private static int bytes(int bits, ClusterEnum a, ClusterEnum b) {
            int left = 6 - bits;
            if (a != ClusterEnum.ForeignShort) {
                left += 6;
            }
            if (b != ClusterEnum.ForeignShort) {
                left += 6;
            }
            int bytes = left >>> 3;
            if ((left & 7) != 0) {
                ++bytes;
            }
            return bytes;
        }
    }

    static class DebugInfo {
        long nStms;
        long nLocal;
        long nPartly;
        long nForeign;
        long nValues;
        long sValues;
        long sForeign;
        long tot;

        DebugInfo() {
        }

        void clear() {
            this.nStms = 0L;
            this.nLocal = 0L;
            this.nPartly = 0L;
            this.nForeign = 0L;
            this.sForeign = 0L;
            this.nValues = 0L;
            this.sValues = 0L;
            this.tot = 0L;
        }

        void add(DebugInfo di) {
            this.nStms += di.nStms;
            this.nLocal += di.nLocal;
            this.nPartly += di.nPartly;
            this.nForeign += di.nForeign;
            this.sForeign += di.sForeign;
            this.nValues += di.nValues;
            this.sValues += di.sValues;
            this.tot += di.tot;
        }

        public String toString() {
            return "val=" + this.nValues + " stm=" + this.nStms + " loc=" + this.nLocal + " par=" + this.nPartly + " ful=" + this.nForeign + " for=" + this.sForeign + " vat=" + this.sValues + " tot=" + this.tot;
        }
    }

    static enum OpEnum {
        Create(52),
        Set(53),
        SetShort(56),
        Delete(54),
        Modify(55);

        private byte mask;

        private OpEnum(byte mask) {
            this.mask = mask;
        }

        public byte getOrMask() {
            return this.mask;
        }
    }

    static enum StmEnum {
        Add(0, 0),
        Remove(1, 32);

        public int ordinal;
        private byte mask;

        private StmEnum(int ordinal, byte mask) {
            this.ordinal = ordinal;
            this.mask = mask;
        }

        byte getOrMask() {
            return this.mask;
        }
    }
}

