/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.db.exception.RuntimeDatabaseException;

public class ClusterSets {
    private final File file;
    private final File file2;
    private final HashMap<Long, Long> clusterSets;
    private final HashMap<Long, Long> reverseMap;
    private int refCount;
    private boolean modified;

    ClusterSets(SessionImplSocket session, File file) {
        try {
            PersistentData pd2;
            PersistentData pd;
            this.refCount = 1;
            this.file = file;
            this.file2 = new File(String.valueOf(file.getAbsolutePath()) + ".reverse");
            try {
                pd = (PersistentData)Files.readFile((File)file, (Binding)PersistentData.BINDING);
            }
            catch (IOException e) {
                pd = new PersistentData();
                pd.values = new HashMap();
                Files.writeFile((File)file, (Binding)PersistentData.BINDING, (Object)pd);
            }
            try {
                pd2 = (PersistentData)Files.readFile((File)this.file2, (Binding)PersistentData.BINDING);
            }
            catch (IOException e) {
                pd2 = new PersistentData();
                pd2.values = new HashMap();
                Files.writeFile((File)file, (Binding)PersistentData.BINDING, (Object)pd2);
            }
            this.clusterSets = pd.values;
            this.reverseMap = pd2.values;
            this.modified = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeDatabaseException("Failed to create ClusterSets.");
        }
    }

    public synchronized int inc() {
        return ++this.refCount;
    }

    public synchronized int dec() {
        return --this.refCount;
    }

    public void dispose() {
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeDatabaseException("Failed to save ClusterSets.");
        }
    }

    public synchronized boolean containsKey(long resourceId) {
        return this.clusterSets.containsKey(resourceId);
    }

    public synchronized Long get(Long resourceId) {
        return this.clusterSets.get(resourceId);
    }

    public synchronized void put(long resourceId, long clusterId) {
        this.clusterSets.put(resourceId, clusterId);
        this.reverseMap.put(clusterId, resourceId);
        this.modified = true;
    }

    public synchronized Long getClusterSet(Long clusterId) {
        return this.reverseMap.get(clusterId);
    }

    public synchronized void save() throws IOException {
        if (!this.modified) {
            return;
        }
        PersistentData pd = new PersistentData();
        pd.values = this.clusterSets;
        Files.writeFile((File)this.file, (Binding)PersistentData.BINDING, (Object)pd);
        pd = new PersistentData();
        pd.values = this.reverseMap;
        Files.writeFile((File)this.file2, (Binding)PersistentData.BINDING, (Object)pd);
        this.modified = false;
    }

    public static class PersistentData {
        public static final Binding BINDING = Bindings.getBindingUnchecked(PersistentData.class);
        public HashMap<Long, Long> values;

        public static void main(String[] args) throws Exception {
            System.err.println(BINDING.type().toSingleLineString());
            PersistentData pd = new PersistentData();
            pd.values = new HashMap();
            long i = 0L;
            while (i < 10L) {
                pd.values.put(i, i);
                ++i;
            }
            BINDING.printValue((Object)pd, (Appendable)System.err, new DataValueRepository(), true);
        }
    }
}

