/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterIdMap;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.service.ClusterUID;

class ClusterIds {
    private static final HashMap<String, ClusterIdMap> clusterIdMaps = new HashMap();
    private final SessionImplSocket session;
    private final ClusterIdMap clusterIdMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterIds(SessionImplSocket session, File folderPath) {
        ClusterIdMap clusterIdMap;
        String t;
        this.session = session;
        try {
            t = folderPath.getCanonicalPath();
        }
        catch (IOException e) {
            String m = "Failed to create canonical file name for cluster id map.";
            Logger.defaultLogError((String)m, (Throwable)e);
            throw new RuntimeDatabaseException(m, (Throwable)e);
        }
        HashMap<String, ClusterIdMap> hashMap = clusterIdMaps;
        synchronized (hashMap) {
            clusterIdMap = clusterIdMaps.get(t);
            if (clusterIdMap == null) {
                clusterIdMap = new ClusterIdMap(folderPath);
                clusterIdMaps.put(t, clusterIdMap);
            }
        }
        this.clusterIdMap = clusterIdMap;
    }

    public Long getClusterId(ClusterUID clusterUID) {
        return this.clusterIdMap.getClusterId(clusterUID);
    }

    public long getClusterIdOrCreate(ClusterUID clusterUID) {
        return this.clusterIdMap.getClusterIdOrCreate(this.session, clusterUID);
    }

    public ClusterUID getClusterUID(long clusterId) {
        return this.clusterIdMap.getClusterUID(clusterId);
    }

    public ClusterUID getClusterUIDOrCreate(long clusterId) {
        return this.clusterIdMap.getClusterUIDOrCreate(clusterId);
    }

    public void mergeFromFolder(String folder) {
        this.clusterIdMap.mergeFromFolder(folder);
    }

    public void mergeToFolder(File folder) throws DatabaseException {
        this.clusterIdMap.mergeToFolder(folder);
    }

    public void saveToFolder(File folder) throws DatabaseException {
        this.clusterIdMap.saveToFolder(folder);
    }
}

