/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.service.ClusterUID;
import org.simantics.utils.FileUtils;

public class ClusterIdMap {
    private static final boolean DEBUG = false;
    private static final String fileName = "clusterIdMap.dat";
    private final File file;
    private HashMap<ClusterUID, Long> clusterIds;
    private final TLongObjectHashMap<ClusterUID> clusterUIDs;
    private int refCount;
    private boolean modified;

    /*
     * Unable to fully structure code
     */
    ClusterIdMap(File folderPath) {
        block7: {
            super();
            try {
                this.refCount = 1;
                this.file = new File(folderPath, "clusterIdMap.dat");
                this.clusterUIDs = new TLongObjectHashMap();
                this.modified = false;
                if (this.file.exists()) {
                    try {
                        pd = (PersistentData)Files.readFile((File)this.file, (Binding)PersistentData.BINDING);
                        this.clusterIds = pd.values;
                        for (Map.Entry<ClusterUID, Long> e : pd.values.entrySet()) {
                            this.clusterUIDs.put(e.getValue().longValue(), (Object)e.getKey());
                        }
                        break block7;
                    }
                    catch (Exception ex) {
                        pd2 = (PersistentData2)Files.readFile((File)this.file, (Binding)PersistentData2.BINDING);
                        this.clusterIds = new HashMap<K, V>();
                        ** for (e : pd2.values.entrySet())
                    }
lbl-1000:
                    // 1 sources

                    {
                        uid = e.getKey().toClusterUID();
                        this.clusterIds.put(uid, e.getValue());
                        this.clusterUIDs.put(e.getValue().longValue(), (Object)uid);
                        continue;
lbl26:
                        // 1 sources

                        break block7;
                    }
                }
                this.clusterIds = new HashMap<K, V>();
                this.put(ClusterUID.Builtin, 1L);
                this.save();
            }
            catch (Exception e) {
                e2 = new RuntimeDatabaseException("Failed to load cluster id map.", (Throwable)e);
                Logger.defaultLogError((Throwable)e2);
                throw e2;
            }
        }
    }

    public synchronized int inc() {
        return ++this.refCount;
    }

    public synchronized int dec() {
        return --this.refCount;
    }

    public void dispose() {
        try {
            this.save();
        }
        catch (RuntimeDatabaseException e) {
            Logger.defaultLogError((String)"Failed to dispose cluster id map.", (Throwable)e);
        }
    }

    public synchronized Long getClusterId(ClusterUID clusterUID) {
        return this.clusterIds.get(clusterUID);
    }

    public synchronized ClusterUID getClusterUID(long clusterId) {
        return (ClusterUID)this.clusterUIDs.get(clusterId);
    }

    private synchronized void put(ClusterUID clusterUID, long clusterId) {
        this.modified = true;
        this.clusterUIDs.put(clusterId, (Object)clusterUID);
        this.clusterIds.put(clusterUID, clusterId);
        this.save();
    }

    public synchronized long getClusterIdOrCreate(SessionImplSocket session, ClusterUID clusterUID) {
        Long clusterId = this.clusterIds.get(clusterUID);
        if (clusterId != null) {
            return clusterId;
        }
        clusterId = session.graphSession.newClusterId();
        this.put(clusterUID, clusterId);
        return clusterId;
    }

    public synchronized ClusterUID getClusterUIDOrCreate(long clusterId) {
        ClusterUID clusterUID = this.getClusterUID(clusterId);
        if (clusterUID != null) {
            return clusterUID;
        }
        clusterUID = ClusterUID.makeRandom();
        this.put(clusterUID, clusterId);
        return clusterUID;
    }

    public synchronized void save() throws RuntimeDatabaseException {
        if (!this.modified) {
            return;
        }
        PersistentData pd = new PersistentData();
        pd.values = this.clusterIds;
        try {
            Files.writeFile((File)this.file, (Binding)PersistentData.BINDING, (Object)pd);
        }
        catch (IOException e) {
            String msg = "Failed to save cluster ids to " + this.file.getAbsolutePath() + ".";
            Logger.defaultLogError((String)msg, (Throwable)e);
            throw new RuntimeDatabaseException(msg, (Throwable)e);
        }
        this.modified = false;
    }

    public synchronized void saveToFolder(File folder) throws DatabaseException {
        folder.mkdirs();
        try {
            FileUtils.copyFile((File)this.file, (File)new File(folder, fileName));
        }
        catch (IOException e) {
            String msg = "Failed to save cluster id map.";
            Logger.defaultLogError((String)msg, (Throwable)e);
            throw new DatabaseException(msg, (Throwable)e);
        }
    }

    public synchronized void mergeFromFolder(String folder) {
        PersistentData pd;
        File file = new File(String.valueOf(folder) + "/" + fileName);
        try {
            pd = (PersistentData)Files.readFile((File)file, (Binding)PersistentData.BINDING);
        }
        catch (IOException e) {
            Logger.defaultLogError((String)"Failed to load cluster id map.", (Throwable)e);
            return;
        }
        for (Map.Entry<ClusterUID, Long> e : pd.values.entrySet()) {
            ClusterUID uid = e.getKey();
            long id = e.getValue();
            this.clusterIds.put(uid, id);
            this.clusterUIDs.put(id, (Object)uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeToFolder(File folder) throws DatabaseException {
        File file = new File(folder, fileName);
        if (!file.exists()) {
            this.saveToFolder(folder);
            return;
        }
        ClusterIdMap clusterIdMap = this;
        synchronized (clusterIdMap) {
            PersistentData pd;
            try {
                pd = (PersistentData)Files.readFile((File)file, (Binding)PersistentData.BINDING);
            }
            catch (IOException e) {
                String msg = "Failed to load cluster id map.";
                Logger.defaultLogError((String)msg, (Throwable)e);
                throw new DatabaseException(msg, (Throwable)e);
            }
            for (Map.Entry<ClusterUID, Long> e : this.clusterIds.entrySet()) {
                ClusterUID uid = e.getKey();
                long id = e.getValue();
                pd.values.put(uid, id);
            }
            try {
                Files.writeFile((File)file, (Binding)PersistentData.BINDING, (Object)pd);
            }
            catch (IOException e) {
                String msg = "Failed to save cluster ids to " + file.getAbsolutePath() + ".";
                Logger.defaultLogError((String)msg, (Throwable)e);
                throw new RuntimeDatabaseException(msg, (Throwable)e);
            }
        }
    }

    public static class PersistentData {
        public HashMap<ClusterUID, Long> values;
        public static final Binding BINDING = Bindings.getBindingUnchecked(PersistentData.class);

        public static void main(String[] args) throws Exception {
            System.err.println(BINDING.type().toSingleLineString());
            PersistentData pd = new PersistentData();
            pd.values = new HashMap();
            long i = 0L;
            while (i < 10L) {
                pd.values.put(ClusterUID.make((long)i, (long)(i + 1L)), i);
                ++i;
            }
            BINDING.printValue((Object)pd, (Appendable)System.err, new DataValueRepository(), true);
        }
    }

    private static class PersistentData2 {
        public HashMap<UID, Long> values;
        public static final Binding BINDING = Bindings.getBindingUnchecked(PersistentData2.class);

        private PersistentData2() {
        }
    }

    public static class UID {
        public long[] longs;

        public UID() {
            this.init(ClusterUID.Null);
        }

        public UID(ClusterUID clusterUID) {
            this.init(clusterUID);
        }

        private void init(ClusterUID clusterUID) {
            this.longs = new long[ClusterUID.getLongLength()];
            clusterUID.toLong(this.longs, 0);
        }

        ClusterUID toClusterUID() {
            return ClusterUID.make((long)this.longs[0], (long)this.longs[1]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UID)) {
                return false;
            }
            UID x = (UID)o;
            return Arrays.equals(this.longs, x.longs);
        }

        public int hashCode() {
            int result = 17;
            int f = (int)(this.longs[0] ^ this.longs[1] >>> 32);
            result = 31 * result + f;
            int s = (int)(this.longs[1] ^ this.longs[1] >>> 32);
            result = 31 * result + s;
            return result;
        }
    }
}

