/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.db.service.ClusteringSupport;

class Checkout {
    Checkout() {
    }

    static class Cluster {
        IdImpl uid;
        public HashMap<Integer, Value> values = new HashMap();

        Cluster() {
        }

        Cluster(IdImpl uid) {
            this.uid = uid;
        }
    }

    static class IdImpl
    implements ClusteringSupport.Id {
        public long first;
        public long second;

        public IdImpl(long first, long second) {
            this.first = first;
            this.second = second;
        }

        public String toString() {
            long[] longs = this.toLong();
            return String.format("%x.%x", longs[0], longs[1]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdImpl)) {
                return false;
            }
            IdImpl x = (IdImpl)o;
            return this.first == x.first && this.second == x.second;
        }

        public int hashCode() {
            int result = 17;
            int f = (int)(this.first ^ this.first >>> 32);
            result = 31 * result + f;
            int s = (int)(this.second ^ this.second >>> 32);
            result = 31 * result + s;
            return result;
        }

        public long[] toLong() {
            long[] longs = new long[]{this.first, this.second};
            return longs;
        }
    }

    public static class PersistentData {
        public static final Binding BINDING = Bindings.getBindingUnchecked(PersistentData.class);
        public Vector<String> comments = new Vector();
        public HashMap<IdImpl, Cluster> clusters = new HashMap();

        public static PersistentData load(File file) throws IOException {
            return (PersistentData)Files.readFile((File)file, (Binding)BINDING);
        }

        public static void save(File file, PersistentData pd) throws IOException {
            Files.writeFile((File)file, (Binding)BINDING, (Object)pd);
        }

        public static void main(String[] args) throws Exception {
            System.err.println(BINDING.type().toSingleLineString());
            PersistentData pd = new PersistentData();
            long i = 0L;
            while (i < 10L) {
                IdImpl uid = new IdImpl(i, i);
                Cluster c = new Cluster(uid);
                pd.clusters.put(uid, c);
                c.values.put((int)i, new Value((int)i, i));
                ++i;
            }
            pd.comments.add("comment 0");
            BINDING.printValue((Object)pd, (Appendable)System.err, new DataValueRepository(), true);
            System.err.println();
            File t = new File("PersistentData.databoard");
            PersistentData.save(t, pd);
            PersistentData spd = PersistentData.load(t);
            BINDING.printValue((Object)spd, (Appendable)System.err, new DataValueRepository(), true);
            System.err.println();
        }
    }

    static class Value {
        int index;
        transient long cs;

        public Value(int in) {
            this.index = in;
            this.cs = 0L;
        }

        public Value(int in, long cs) {
            this.index = in;
            this.cs = cs;
        }

        public String toString() {
            return String.format("%d.%d.%d", this.index, this.cs);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value x = (Value)o;
            return this.index == x.index;
        }

        public int hashCode() {
            return this.index;
        }
    }
}

