/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.THashMap;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.support.BuiltinSupport;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.InitSupport;
import org.simantics.graph.db.CoreInitialization;

public class BuiltinSupportImpl
implements BuiltinSupport {
    private final boolean DEBUG = false;
    private final SessionImplSocket session;
    private ClusterBase builtinCluster;
    private THashMap<String, BuiltinData> builtinMap;

    BuiltinSupportImpl(SessionImplSocket session) {
        this.session = session;
        this.builtinMap = null;
        this.builtinCluster = null;
    }

    public int getBuiltin(String uri) {
        try {
            ResourceImpl impl = this.getBuiltinResource(uri);
            if (impl != null) {
                return impl.id;
            }
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((String)("Failed to get builtin for " + uri), (Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceImpl getBuiltinResource(String name) throws DatabaseException {
        Logger.defaultLogTrace((String)("Asking for builtin " + name));
        BuiltinSupportImpl builtinSupportImpl = this;
        synchronized (builtinSupportImpl) {
            if (this.builtinMap == null) {
                ClusterSupport cs = this.session.getService(ClusterSupport.class);
                this.builtinCluster = cs.getClusterByClusterUIDOrMake(ClusterUID.Builtin);
                this.builtinMap = this.initBuiltinMap();
            }
        }
        ResourceImpl resource = null;
        BuiltinData builtin = null;
        BuiltinSupportImpl builtinSupportImpl2 = this;
        synchronized (builtinSupportImpl2) {
            block10: {
                builtin = (BuiltinData)this.builtinMap.get((Object)name);
                if (builtin != null) break block10;
                Logger.defaultLogInfo((String)("Asking for missing builtin " + name));
                return null;
            }
            if (builtin.weakResource != null && (resource = builtin.weakResource.get()) != null) {
                return resource;
            }
        }
        int id = ClusterTraits.createResourceKey((int)this.builtinCluster.getClusterKey(), (int)builtin.index);
        resource = this.session.getResource(id);
        if (resource == null) {
            throw new ValidationException("Builtin not found index=" + builtin.index);
        }
        builtin.weakResource = new SoftReference<ResourceImpl>(resource);
        return resource;
    }

    private THashMap<String, BuiltinData> initBuiltinMap() throws DatabaseException {
        THashMap builtins = new THashMap();
        HashSet t = CoreInitialization.getBuiltins();
        int size = t.size();
        for (InitSupport.Builtin b : t) {
            if (b.index < 1 || b.index > size) {
                throw new ValidationException("Illegal builtin resource index=" + b.index);
            }
            BuiltinData bd = new BuiltinData(b.index);
            builtins.put((Object)b.uri, (Object)bd);
        }
        return builtins;
    }

    static class BuiltinData {
        final int index;
        SoftReference<ResourceImpl> weakResource = null;

        BuiltinData(int index) {
            this.index = index;
        }
    }
}

