/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;

public class ThreadUtil {
    private static ThreadGroup rootThreadGroup = null;

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        if (rootThreadGroup != null) {
            return rootThreadGroup;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        return tg;
    }

    private static ThreadGroup[] getAllThreadGroups() {
        ThreadGroup[] groups;
        ThreadGroup root = ThreadUtil.getRootThreadGroup();
        int nAlloc = root.activeGroupCount();
        int n = 0;
        while ((n = root.enumerate(groups = new ThreadGroup[nAlloc *= 2], true)) == nAlloc) {
        }
        ThreadGroup[] allGroups = new ThreadGroup[n + 1];
        allGroups[0] = root;
        System.arraycopy(groups, 0, allGroups, 1, n);
        return allGroups;
    }

    public static ThreadGroup getThreadGroup(String name) {
        ThreadGroup[] groups;
        ThreadGroup[] threadGroupArray = groups = ThreadUtil.getAllThreadGroups();
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadGroup group = threadGroupArray[n2];
            if (group.getName().equals(name)) {
                return group;
            }
            ++n2;
        }
        return null;
    }

    private static Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = ThreadUtil.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    private static Thread getThread(String name) {
        Thread[] threads;
        Thread[] threadArray = threads = ThreadUtil.getAllThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.getName().equals(name)) {
                return thread;
            }
            ++n2;
        }
        return null;
    }

    public static void interruptAllRootGroupTreads() {
        ThreadUtil.getRootThreadGroup().interrupt();
    }

    public static void interruptAllGroupThreadsAfter(final int millisec) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(millisec);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                ThreadUtil.interruptAllRootGroupTreads();
            }
        });
        t.setName("InterruptMainThread");
        t.setDaemon(true);
        t.start();
    }

    public static void interruptMainThread() {
        Thread main = ThreadUtil.getThread("main");
        if (main != null) {
            main.interrupt();
        }
    }

    public static void interruptMainThreadAfter(final int millisec) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("InterruptMainThread sleeping.");
                    Thread.sleep(millisec);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                System.out.println("InterruptMainThread interrupting.");
                Thread main = ThreadUtil.getThread("main");
                if (main != null) {
                    main.interrupt();
                }
            }
        });
        t.setName("InterruptMainThread");
        t.setDaemon(true);
        t.start();
    }

    public static void interruptThreadGroup(String name) {
        ThreadGroup tg = ThreadUtil.getThreadGroup(name);
        if (tg == null) {
            return;
        }
        tg.interrupt();
    }
}

