/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore;

import java.net.InetSocketAddress;
import org.simantics.db.ServerReference;

public final class ProCoreServerReference
implements ServerReference {
    public final InetSocketAddress socketAddress;
    public final String dbid;

    public ProCoreServerReference(String hostAndPort) {
        assert (hostAndPort != null);
        String[] split = hostAndPort.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("address does not contain a port, missing ':' character");
        }
        this.socketAddress = InetSocketAddress.createUnresolved(split[0], Integer.parseInt(split[1]));
        this.dbid = null;
    }

    public ProCoreServerReference(String host, int port) {
        assert (host != null);
        this.socketAddress = new InetSocketAddress(host, port);
        this.dbid = null;
    }

    public ProCoreServerReference(String host, int port, String dbid) {
        assert (host != null);
        this.socketAddress = InetSocketAddress.createUnresolved(host, port);
        this.dbid = dbid;
    }

    public ProCoreServerReference(InetSocketAddress socketAddress) {
        assert (socketAddress != null);
        this.socketAddress = socketAddress;
        this.dbid = null;
    }

    public ProCoreServerReference(InetSocketAddress socketAddress, String dbid) {
        assert (socketAddress != null);
        this.socketAddress = socketAddress;
        this.dbid = dbid;
    }

    public int hashCode() {
        return this.socketAddress.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        ProCoreServerReference r = (ProCoreServerReference)other;
        return r.socketAddress.equals(this.socketAddress) && (r.dbid != null && r.dbid.equals(this.dbid) || r.dbid == null && this.dbid == null);
    }

    public String toString() {
        if (this.dbid != null) {
            return String.valueOf(this.socketAddress.toString()) + " / " + this.dbid;
        }
        return this.socketAddress.toString();
    }
}

