/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ServerI;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.ArgumentException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServerNotFoundException;
import org.simantics.db.procore.protocol.ProCoreClient;
import org.simantics.db.procore.protocol.SessionException;

public class ProCoreServer
implements ServerI {
    private static Map<String, ProCoreServer> workingDirs = new HashMap<String, ProCoreServer>();
    private static final String SERVER_EXECUTABLE_EXTENSION;
    private static final String SERVER_EXECUTABLE_NAME;
    private static final FileFilter SERVER_EXECUTABLE_FILTER;
    private static final FileFilter SERVER_NONEXECUTABLE_FILTER;
    public static final String BRANCH_DIR = "procore.headClusters.procore";
    public static final String CONFIG_FILE = "procore.config.procore";
    private static final boolean DEBUG = false;
    private static final String QUIT_CMD = "quit";
    private static final int SLEEP_COUNT = 50;
    private final File exeFile;
    private final File workingDir;
    private final GuardFile guardFile;
    private final ProCoreClient proCoreClient = new ProCoreClient();

    static {
        SERVER_EXECUTABLE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().equals(SERVER_EXECUTABLE_NAME) && pathname.canExecute();
            }
        };
        SERVER_NONEXECUTABLE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().equals(SERVER_EXECUTABLE_NAME) && !pathname.canExecute()) {
                    pathname.setExecutable(true);
                    return pathname.canExecute();
                }
                return false;
            }
        };
        String osName = System.getProperty("os.name");
        assert (osName != null);
        SERVER_EXECUTABLE_EXTENSION = (osName = osName.toLowerCase()).startsWith("windows") ? ".exe" : "";
        SERVER_EXECUTABLE_NAME = "ProCoreServer" + SERVER_EXECUTABLE_EXTENSION;
    }

    public static void stopProCoreServer(File workingDir) throws DatabaseException {
        GuardFile guardFile = new GuardFile(workingDir);
        guardFile.stopProCoreServer();
    }

    private static boolean isRunning(String aPid) throws DatabaseException {
        boolean isRunning = true;
        try {
            switch (OSType.calculate()) {
                case WINDOWS: {
                    Process p = Runtime.getRuntime().exec("tasklist.exe /fo csv /nh /fi \"pid eq " + aPid + "\"");
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = input.readLine();
                    if (line.startsWith("INFO: No tasks are running which match the specified criteria.")) {
                        isRunning = false;
                    }
                    input.close();
                    break;
                }
                case UNIX: {
                    Process p = Runtime.getRuntime().exec("ps -p " + aPid + " -o comm=");
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = input.readLine();
                    if (line == null || line.isEmpty()) {
                        isRunning = false;
                    }
                    input.close();
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseException("Could not get list of running processes.", (Throwable)e);
        }
        return isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProCoreServer getProCoreServer(File serverDir, File workingDir) throws DatabaseException {
        try {
            Map<String, ProCoreServer> map = workingDirs;
            synchronized (map) {
                File executable;
                ProCoreServer proCoreServer = workingDirs.get(workingDir.getCanonicalPath());
                if (proCoreServer != null) {
                    return proCoreServer;
                }
                if (!serverDir.isDirectory()) {
                    throw new ArgumentException("Expected server directory as argument");
                }
                if (!workingDir.isDirectory()) {
                    throw new ArgumentException("Expected working directory as argument. wd=" + workingDir.getAbsolutePath());
                }
                File[] fileArray = serverDir.listFiles(SERVER_EXECUTABLE_FILTER);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    executable = fileArray[n2];
                    proCoreServer = new ProCoreServer(executable, workingDir);
                    ++n2;
                }
                if (proCoreServer == null) {
                    fileArray = serverDir.listFiles(SERVER_NONEXECUTABLE_FILTER);
                    n = fileArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        executable = fileArray[n2];
                        proCoreServer = new ProCoreServer(executable, workingDir);
                        ++n2;
                    }
                }
                if (proCoreServer == null) {
                    throw new ServerNotFoundException("No executable ProCoreServer found in " + serverDir.getCanonicalPath());
                }
                workingDirs.put(workingDir.getCanonicalPath(), proCoreServer);
                return proCoreServer;
            }
        }
        catch (IOException e) {
            throw new DatabaseException("IOException", (Throwable)e);
        }
    }

    private static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getFileLines(File aFile, int maxLines) {
        String[] stringArray;
        BufferedReader br;
        InputStreamReader isr;
        FileInputStream fis;
        String[] STRING_EMPTY_ARRAY;
        block9: {
            STRING_EMPTY_ARRAY = new String[]{};
            fis = null;
            isr = null;
            br = null;
            if (aFile.canRead()) break block9;
            String[] stringArray2 = STRING_EMPTY_ARRAY;
            ProCoreServer.close(br);
            ProCoreServer.close(isr);
            ProCoreServer.close(fis);
            return stringArray2;
        }
        try {
            fis = new FileInputStream(aFile);
        }
        catch (FileNotFoundException e) {
            String[] stringArray3 = STRING_EMPTY_ARRAY;
            ProCoreServer.close(br);
            ProCoreServer.close(isr);
            ProCoreServer.close(fis);
            return stringArray3;
        }
        try {
            isr = new InputStreamReader((InputStream)fis, "US-ASCII");
            br = new BufferedReader(isr);
            String line = null;
            int count = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                if (++count > maxLines) break;
                lines.add(line);
            }
            stringArray = lines.toArray(STRING_EMPTY_ARRAY);
        }
        catch (Exception e) {
            try {
                Logger.defaultLogError((Throwable)e);
            }
            catch (Throwable throwable) {
                ProCoreServer.close(br);
                ProCoreServer.close(isr);
                ProCoreServer.close(fis);
                throw throwable;
            }
            ProCoreServer.close(br);
            ProCoreServer.close(isr);
            ProCoreServer.close(fis);
            return new String[0];
        }
        ProCoreServer.close(br);
        ProCoreServer.close(isr);
        ProCoreServer.close(fis);
        return stringArray;
    }

    private static int parseInt(String s) throws DatabaseException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            String msg = "Could not convert string to number. string=" + s;
            Logger.defaultLogError((String)msg);
            throw new DatabaseException(msg, (Throwable)e);
        }
    }

    private static void sleep(int count) {
        try {
            Thread.sleep(100 * count);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private ProCoreServer(File exeFile, File workingDir) throws DatabaseException {
        if (exeFile == null) {
            throw new DatabaseException("Illegal argument: exeFile is null.");
        }
        if (workingDir == null) {
            throw new DatabaseException("Illegal argument: workingDir is null.");
        }
        this.exeFile = exeFile;
        this.workingDir = workingDir;
        this.guardFile = new GuardFile(workingDir);
    }

    public synchronized String execute(String command) throws DatabaseException {
        return this.proCoreClient.execute(command);
    }

    private void startInternal(String[] args) throws DatabaseException {
        if (!this.exeFile.exists()) {
            throw new DatabaseException(this.exeFile + " not found");
        }
        if (!this.exeFile.canExecute()) {
            throw new DatabaseException(this.exeFile + " is not executable");
        }
        if (!this.workingDir.isDirectory()) {
            throw new DatabaseException(String.valueOf(this.workingDir.getAbsolutePath()) + " is not directory");
        }
        String[] cmd = new String[1 + args.length];
        cmd[0] = this.exeFile.getAbsolutePath().toString();
        System.arraycopy(args, 0, cmd, 1, args.length);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        pb.directory(this.workingDir);
        int i = 0;
        while (i < 50) {
            block13: {
                Process process;
                try {
                    process = pb.start();
                }
                catch (IOException e) {
                    Logger.defaultLogError((String)("ProCoreServer startup failed. Process " + cmd[0] + " did not start."), (Throwable)e);
                    this.startInternalReinit(-1);
                    break block13;
                }
                try {
                    int exitStatus = process.exitValue();
                    if (this.guardFile.isAlive() && this.guardFile.isActive(this.proCoreClient)) {
                        return;
                    }
                    this.startInternalReinit(exitStatus);
                }
                catch (IllegalThreadStateException e) {
                    boolean active = this.guardFile.wait4Active(this.proCoreClient, process);
                    if (active) {
                        return;
                    }
                    try {
                        int exitStatus = process.exitValue();
                        this.startInternalReinit(exitStatus);
                    }
                    catch (IllegalThreadStateException e2) {
                        if (this.guardFile.isActive(this.proCoreClient)) {
                            return;
                        }
                        throw new SessionException("Could not connect to server. Server not responsive.");
                    }
                }
            }
            ProCoreServer.sleep(++i);
        }
        throw new DatabaseException("ProCoreServer startup failed. Process " + cmd[0] + " did not start.");
    }

    private void startInternalReinit(int exitStatus) throws DatabaseException {
        switch (exitStatus) {
            default: {
                throw new DatabaseException(this.getExitMessage(exitStatus));
            }
            case -1: 
            case 29: 
            case 30: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
        }
        boolean dead = this.guardFile.wait4ServerToDie(this.proCoreClient);
        if (!dead) {
            throw new DatabaseException("ProCoreServer is running. Giving up trying to start a new instance.", (Throwable)new DatabaseException(this.getExitMessage(exitStatus)));
        }
        boolean deleted = this.guardFile.delete();
        if (!deleted) {
            Logger.defaultLogError((String)("ProCoreServer is dead but can not delete guard file. " + this.getExitMessage(exitStatus)));
        }
    }

    public synchronized boolean isActive() throws DatabaseException {
        if (this.proCoreClient.isConnected()) {
            try {
                this.proCoreClient.execute("");
                return true;
            }
            catch (SessionException e) {
                this.proCoreClient.disconnect();
            }
        }
        return this.guardFile.isActive(this.proCoreClient);
    }

    private String getExitMessage(int exitValue) {
        switch (exitValue) {
            default: {
                return "Unexpected exit value = " + exitValue + ".";
            }
            case 1: {
                return "Exception was thrown. This indicates problems with program logic.";
            }
            case 2: {
                return "CallException was thrown. This indicates problems with calls to/from parent server.";
            }
            case 3: {
                return "ProtocolException was thrown. This indicates problems with executable versions between local and parent servers.";
            }
            case 4: {
                return "NoSuchElementException was thrown. This indicates problems with program logic.";
            }
            case 5: {
                return "IllegalArgumentException was thrown. This indicates problems with program logic.";
            }
            case 6: {
                return "IllegalResourceException was thrown. This indicates problems with server data.";
            }
            case 7: {
                return "IllegalClusterException was thrown. This indicates problems with server data.";
            }
            case 8: {
                return "ParseException was thrown. This indicates problems with/during parsing of the configuration file.";
            }
            case 9: {
                return "PortSemaphoreException was thrown. This indicates that some other server is using the same port number.";
            }
            case 10: {
                return "DatabaseSemaphoreException was thrown. This indicates that some other server is using the same database id.";
            }
            case 11: {
                return "SystemException was thrown. This indicates problems with program logic.";
            }
            case 12: {
                return "CppException was thrown. This indicates problems with program logic.";
            }
            case 13: {
                return "UnknownException was thrown. This indicates problems with program logic.";
            }
            case 14: {
                return "ThrowException was thrown. This indicates problems with program logic.";
            }
            case 15: {
                return "AssertException was thrown. This indicates problems with program logic.";
            }
            case 16: {
                return "ParentCheckException was thrown. This indicates problems with the database version of parent.";
            }
            case 17: {
                return "ParentConnectionException was thrown. This indicates problems with parent child relationship.";
            }
            case 18: {
                return "ConnectionException was thrown. This indicates problems with TCP/IP connections.";
            }
            case 19: {
                return "ProxyException was thrown. This indicates problems with TCP/IP connections to proxy.";
            }
            case 20: {
                return "NoSuchFileException was thrown. This indicates problems with a missing file.";
            }
            case 21: {
                return "JournalException was thrown. This indicates problems with journal mechanisim.";
            }
            case 22: {
                return "OutOfSpaceException was thrown. This indicates problems with memory.";
            }
            case 23: {
                return "ExternalValueException was thrown. This indicates problems with large value handling.";
            }
            case 24: {
                return "IllegalTransactionException was thrown. This indicates problems with transaction logic.";
            }
            case 25: {
                return "WriteTransactionException was thrown. This indicates that server failed during write transaction.";
            }
            case 26: {
                return "ConsoleException was thrown. This indicates that server console was closed without quit command.";
            }
            case 27: {
                return "ExitException was thrown. This indicates that server did not exit cleanly.";
            }
            case 28: {
                return "ExitReadPIdException was thrown. This indicates that server did not exit cleanly.";
            }
            case 29: {
                return "ExitReadStatusException was thrown. This indicates that server did not exit cleanly.";
            }
            case 30: {
                return "ExitStatusValueException was thrown. This indicates that server did not exit cleanly.";
            }
            case 31: {
                return "UpdateException was thrown. This indicates that server failed during update.";
            }
            case 32: {
                return "DatabaseVersionException was thrown. This indicates that server can not use given database.";
            }
            case 33: {
                return "DatabaseCorruptionException was thrown. This indicates that server has detected database corruption.";
            }
            case 34: {
                return "ExitReadPortException was thrown. This indicates that server did not start or exit cleanly.";
            }
            case 35: {
                return "ExitGuardOpenException was thrown. This indicates that server could not open guard file.";
            }
            case 36: {
                return "ExitGuardOpenWriteException was thrown. This indicates that server could not open guard file for writing.";
            }
            case 37: {
                return "ExitGuardWritePidException was thrown. This indicates that server could not write pid to guard file.";
            }
            case 38: {
                return "ExitGuardWritePortException was thrown. This indicates that server could not write port to guard file.";
            }
            case 39: {
                return "LastCommitNotCleanException was thrown. This indicates that client died during transaction. Recovery action needed.";
            }
            case 40: {
                return "TerminatedException was thrown. This indicates that server died because it received terminating signal.";
            }
            case 41: {
                return "ExitGuardWriteStatusException was thrown. This indicates that server could not write exit status to guard file.";
            }
            case 42: {
                return "EndReadStatusException was thrown. This indicates that server died because it could not read end status from guard file.";
            }
            case 43: {
                return "EndStatusValueException was thrown. This indicates that server died because end value was not zero.";
            }
            case 44: {
                return "ExitGuardReadVersionException was thrown. This indicates that server died because server could not read version from guard file.";
            }
            case 45: {
                return "ExitGuardValueVersionException was thrown. This indicates that server died because server did not support guard file version.";
            }
            case 46: {
                return "ExitGuardWriteVersionException was thrown. This indicates that server died because server could not write version to guard file.";
            }
            case 47: 
        }
        return "ListenPortException was thrown. This indicates that server died because server could not listen to given port or any other port.";
    }

    public synchronized void start() throws DatabaseException {
        try {
            this.startInternal(new String[0]);
        }
        catch (Throwable t) {
            String msg = "ProCoreServer startup failed. Automatic recovery handling not implemented. Use database debugger to manually fix database.";
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException(msg, t);
        }
    }

    public synchronized void stop() throws DatabaseException {
        boolean dead = this.guardFile.wait4ServerToDie(this.proCoreClient);
        if (!dead) {
            Logger.defaultLogInfo((String)"Failed to stop a server. This is not an error! Server does not have to stop.");
        }
    }

    public synchronized String getExitMessage() throws DatabaseException {
        Integer returnValue = this.guardFile.getExitValue();
        if (returnValue == null) {
            throw new DatabaseException("Exit message not available.");
        }
        return this.getExitMessage(returnValue);
    }

    public synchronized int getPort() throws DatabaseException {
        if (this.proCoreClient.isConnected()) {
            return this.proCoreClient.getPort();
        }
        return this.guardFile.getPort();
    }

    static class GuardFile {
        private static final String GUARD_FILE = "procore.guard.procore";
        private static final int VERSION_LINE = 1;
        private static final int PID_LINE = 2;
        private static final int PORT_LINE = 3;
        private static final int EXIT_LINE = 4;
        private static final int END_LINE = 5;
        private final File guardFile;

        GuardFile(File workingDir) {
            this.guardFile = new File(workingDir, GUARD_FILE);
        }

        int getPort() throws DatabaseException {
            String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
            if (lines.length < 3) {
                throw new DatabaseException("Server port is not available. " + this.guardFile.getAbsolutePath());
            }
            return ProCoreServer.parseInt(lines[2]);
        }

        private void checkVersion(String[] lines) throws DatabaseException {
            if (lines.length < 1) {
                throw new DatabaseException("Guard file version is not available. " + this.guardFile.getAbsolutePath());
            }
            int version = ProCoreServer.parseInt(lines[0]);
            if (1 != version) {
                throw new DatabaseException("Unsupported guard file version. version=" + version);
            }
        }

        private boolean wait4ActiveTest(Process process) {
            try {
                process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }

        boolean wait4Active(ProCoreClient proCoreClient, Process process) throws DatabaseException {
            String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
            int i = 0;
            while (this.wait4ActiveTest(process) && i < 50) {
                lines = ProCoreServer.getFileLines(this.guardFile, 5);
                if (lines.length >= 1) {
                    this.checkVersion(lines);
                    if (lines.length >= 3) {
                        if (lines.length >= 4) {
                            if (!this.wait4ActiveTest(process)) {
                                return false;
                            }
                        } else {
                            int port = ProCoreServer.parseInt(lines[2]);
                            if (port < 1) {
                                return false;
                            }
                            try {
                                proCoreClient.disconnect();
                                proCoreClient.connect(port);
                                return true;
                            }
                            catch (SessionException e) {
                                proCoreClient.disconnect();
                            }
                        }
                    }
                }
                ProCoreServer.sleep(++i);
            }
            return false;
        }

        boolean delete() {
            if (this.guardFile.exists()) {
                return this.guardFile.delete();
            }
            return true;
        }

        Integer getExitValue() {
            String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
            try {
                this.checkVersion(lines);
                if (lines.length >= 4) {
                    return ProCoreServer.parseInt(lines[3]);
                }
                if (lines.length >= 2 && !ProCoreServer.isRunning(lines[1])) {
                    return -1;
                }
                return null;
            }
            catch (Exception e) {
                Logger.defaultLogError((String)"Could not get ProCoreServer exit value.", (Throwable)e);
                return null;
            }
        }

        void stopProCoreServer() throws DatabaseException {
            block13: {
                if (!this.guardFile.exists()) {
                    throw new DatabaseException("Guard file does not exist.");
                }
                String[] lines = new String[]{};
                int i = 0;
                while (i < 50) {
                    lines = ProCoreServer.getFileLines(this.guardFile, 5);
                    if (lines.length < 1) {
                        throw new DatabaseException("Guard file does not contain lines.");
                    }
                    this.checkVersion(lines);
                    if (lines.length >= 5) {
                        return;
                    }
                    if (!ProCoreServer.isRunning(lines[1])) {
                        return;
                    }
                    if (lines.length < 3) {
                        // empty if block
                    }
                    ProCoreServer.sleep(++i);
                }
                if (lines.length < 3) {
                    throw new DatabaseException("Guard file does not contain port.");
                }
                try {
                    int port = ProCoreServer.parseInt(lines[2]);
                    if (port <= 0) break block13;
                    ProCoreClient lProCoreClient = new ProCoreClient();
                    lProCoreClient.connect(port);
                    try {
                        lProCoreClient.execute(ProCoreServer.QUIT_CMD);
                    }
                    finally {
                        lProCoreClient.disconnect();
                    }
                }
                catch (Throwable t) {
                    throw new DatabaseException("Failed to stop procore server cleanly.", t);
                }
            }
            boolean dead = this.wait4ServerToDie(null);
            if (!dead) {
                throw new DatabaseException("Unable to stop server.");
            }
        }

        boolean isActive(ProCoreClient proCoreClient) throws DatabaseException {
            block7: {
                String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
                if (lines.length != 3) {
                    return false;
                }
                this.checkVersion(lines);
                int port = ProCoreServer.parseInt(lines[2]);
                if (port <= 0) break block7;
                if (proCoreClient.isConnected()) {
                    proCoreClient.disconnect();
                }
                try {
                    proCoreClient.connect(port);
                    proCoreClient.execute("");
                    return true;
                }
                catch (SessionException e) {
                    try {
                        proCoreClient.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return false;
        }

        boolean isAlive() throws DatabaseException {
            String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
            if (lines.length < 1) {
                return false;
            }
            this.checkVersion(lines);
            if (lines.length < 2) {
                return false;
            }
            if (lines.length >= 5) {
                return false;
            }
            if (lines.length >= 4) {
                return false;
            }
            return ProCoreServer.isRunning(lines[1]);
        }

        boolean wait4ServerToDie(ProCoreClient proCoreClient) throws DatabaseException {
            if (proCoreClient != null && proCoreClient.isConnected()) {
                try {
                    proCoreClient.execute(ProCoreServer.QUIT_CMD);
                }
                finally {
                    proCoreClient.disconnect();
                }
            }
            String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
            int i = 0;
            while (i < 50 && lines.length < 5) {
                if (lines.length >= 4) {
                    return true;
                }
                if (lines.length >= 2 && !ProCoreServer.isRunning(lines[1])) {
                    return true;
                }
                ProCoreServer.sleep(1);
                ++i;
                lines = ProCoreServer.getFileLines(this.guardFile, 5);
            }
            return lines.length >= 4;
        }
    }

    private static final class OSType
    extends Enum<OSType> {
        public static final /* enum */ OSType UNIX = new OSType();
        public static final /* enum */ OSType WINDOWS = new OSType();
        public static final /* enum */ OSType UNKNOWN = new OSType();
        private static final /* synthetic */ OSType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new OSType[]{UNIX, WINDOWS, UNKNOWN};
        }

        public static OSType calculate() {
            String osName = System.getProperty("os.name");
            assert (osName != null);
            if ((osName = osName.toLowerCase()).startsWith("windows")) {
                return WINDOWS;
            }
            if (osName.startsWith("mac os x") || osName.startsWith("linux") || osName.startsWith("sun")) {
                return UNIX;
            }
            return UNKNOWN;
        }

        public static OSType[] values() {
            OSType[] oSTypeArray = ENUM$VALUES;
            int n = oSTypeArray.length;
            OSType[] oSTypeArray2 = new OSType[n];
            System.arraycopy(ENUM$VALUES, 0, oSTypeArray2, 0, n);
            return oSTypeArray2;
        }

        public static OSType valueOf(String string) {
            return Enum.valueOf(OSType.class, string);
        }
    }
}

