/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore;

import fi.vtt.simantics.procore.BackdoorAuthenticator;
import fi.vtt.simantics.procore.SessionManagerSource;
import fi.vtt.simantics.procore.internal.SessionImplVirtual;
import fi.vtt.simantics.procore.internal.SessionImplVirtualInit;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import org.simantics.db.Driver;
import org.simantics.db.ReadGraph;
import org.simantics.db.ServerAddress;
import org.simantics.db.ServerI;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.authentication.UserAuthenticator;
import org.simantics.db.common.auth.UserAuthenticationAgents;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServerNotFoundException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.FileUtils;

public class ProCoreDriverVirtual
implements Driver {
    private static final Boolean DEBUG = true;
    private final UserAuthenticator authenticator = new BackdoorAuthenticator();
    private final UserAuthenticationAgent agent = UserAuthenticationAgents.staticAgent((UserAuthenticator)this.authenticator);

    ProCoreDriverVirtual() {
        this.initLogging();
    }

    public final String getName() {
        return "virtual";
    }

    public Session connect(ServerAddress address, Properties args) throws DatabaseException {
        SessionImplVirtual s = new SessionImplVirtual(this.agent);
        if (args.containsKey("noinitialise")) {
            if (DEBUG.booleanValue()) {
                System.out.println("noinitialise");
            }
        } else {
            s.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph g) {
                    Layer0.getInstance((ReadGraph)g);
                }
            });
        }
        return s;
    }

    public ServiceLocator connect2(ServerAddress address, Properties args) throws DatabaseException {
        if (args.containsKey("builtinInitializer")) {
            return new SessionImplVirtualInit(this.agent);
        }
        return new SessionImplVirtual(this.agent);
    }

    public ServerI getServer(File exeDir, File workDir) throws DatabaseException, ServerNotFoundException {
        return SessionImplVirtual.newProCoreServer(exeDir, workDir);
    }

    public void cloneDatabase(File workspaceDir, File serverDir) throws DatabaseException {
        if (DEBUG.booleanValue()) {
            System.out.println("Cloning database in " + serverDir.getAbsolutePath());
        }
        if (!workspaceDir.exists()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " does not exist.");
        }
        if (!workspaceDir.isDirectory()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " is not a directory.");
        }
        if (!serverDir.exists()) {
            throw new DatabaseException("Source directory " + serverDir.getAbsolutePath() + " does not exist.");
        }
        if (!serverDir.isDirectory()) {
            throw new DatabaseException("Source directory " + serverDir.getAbsolutePath() + " is not a directory.");
        }
        File fromFile = new File("");
        File toFile = new File(String.valueOf(serverDir.getAbsolutePath()) + File.separator);
        try {
            FileUtils.copyFile((File)fromFile, (File)toFile);
        }
        catch (IOException e) {
            throw new DatabaseException("Failed to create file " + toFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public void configLocalDatabase(File workspaceDir, File serverDir, ServerAddress address) throws DatabaseException {
        if (DEBUG.booleanValue()) {
            System.out.println("Configurating database in " + serverDir.getAbsolutePath());
        }
    }

    public void removeDatabaseFiles(File dbDir) throws DatabaseException {
        File[] dbFiles;
        dbDir = new File(".");
        if (!dbDir.exists()) {
            throw new DatabaseException("Database directory " + dbDir.getAbsolutePath() + " does not exist.");
        }
        if (!dbDir.isDirectory()) {
            throw new DatabaseException("Database directory " + dbDir.getAbsolutePath() + " is not a directory.");
        }
        File[] fileArray = dbFiles = dbDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("virtualGraph.*.dat");
            }
        });
        int n = dbFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File dbFile = fileArray[n2];
            if (DEBUG.booleanValue()) {
                System.out.println("Deleting old database file: " + dbFile);
            }
            if (!dbFile.delete()) {
                System.out.println("WARNING: Failed to remove previous database file: " + dbFile);
            }
            ++n2;
        }
    }

    public void initDatabase(File wsDir, File serverDir, Properties props, File initFile) throws DatabaseException {
        if (DEBUG.booleanValue()) {
            System.out.println("Initializing database file " + initFile.getAbsolutePath());
        }
    }

    private void initLogging() {
        block2: {
            try {
                SessionManagerSource.getSessionManager();
            }
            catch (IOException e) {
                if (!DEBUG.booleanValue()) break block2;
                e.printStackTrace();
            }
        }
    }
}

