/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore;

import fi.vtt.simantics.procore.BackdoorAuthenticator;
import fi.vtt.simantics.procore.PrimitiveParsers;
import fi.vtt.simantics.procore.ProCoreDriverVirtual;
import fi.vtt.simantics.procore.ProCoreServer;
import fi.vtt.simantics.procore.ProCoreServerReference;
import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.SessionManagerSource;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.Socket;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ServerAddress;
import org.simantics.db.ServerI;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.SessionReference;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.authentication.UserAuthenticator;
import org.simantics.db.common.auth.UserAuthenticationAgents;
import org.simantics.db.common.auth.UserAuthenticators;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServerNotFoundException;
import org.simantics.db.procore.protocol.SessionException;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.InitSupport;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.XSupport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.utils.FileUtils;

public class ProCoreDriver
implements Driver {
    public static final String ProCoreConfigFile = "procore.config.procore";
    public static final String ProCoreDriverName = "procore";
    public static final String ProCoreDriverNameVirtual = "virtual";
    private static final ProCoreDriver driver = new ProCoreDriver();
    private static final ProCoreDriverVirtual virtual = new ProCoreDriverVirtual();
    private static final Boolean DEBUG = false;
    private static final OntologyVersions VERSIONS;
    private static final String instanceOf;
    private static final String inherits;
    private static final String subrelationOf;
    private int lastUsedIndex = 3;

    static {
        Manager.registerDriver((String)ProCoreDriverName, (Driver)driver);
        Manager.registerDriver((String)ProCoreDriverNameVirtual, (Driver)virtual);
        VERSIONS = OntologyVersions.getInstance();
        instanceOf = VERSIONS.currentVersion("http://www.simantics.org/Layer0-0.0/InstanceOf");
        inherits = VERSIONS.currentVersion("http://www.simantics.org/Layer0-0.0/Inherits");
        subrelationOf = VERSIONS.currentVersion("http://www.simantics.org/Layer0-0.0/SubrelationOf");
    }

    public final String getName() {
        return ProCoreDriverName;
    }

    public Session connect(ServerAddress address, Properties args) throws DatabaseException {
        ServiceLocator sl = this.connect2(address, args);
        Session s = (Session)sl.peekService(Session.class);
        if (s == null) {
            throw new SessionException("Failed to connect to database. No further error information available, sorry!");
        }
        s.registerService(Properties.class, (Object)args);
        return s;
    }

    public ServiceLocator connect2(ServerAddress address, Properties args) throws DatabaseException {
        ProCoreServerReference serverReference = new ProCoreServerReference(address.getAddress(), address.getDbid());
        ProCoreSessionReference sessionReference = new ProCoreSessionReference(serverReference, -1L);
        try {
            String user = args.getProperty("user");
            String password = args.getProperty("password");
            if (user == null) {
                throw new DatabaseException("'user' property not provided");
            }
            if (password == null) {
                throw new DatabaseException("'password' property not provided");
            }
            UserAuthenticator authenticator = UserAuthenticators.byNameAndPassword((String)user, (String)password);
            if (args.getProperty("hyshys") != null) {
                authenticator = new BackdoorAuthenticator();
            }
            UserAuthenticationAgent agent = UserAuthenticationAgents.staticAgent((UserAuthenticator)authenticator);
            String prop = args.getProperty("clientDir");
            if (prop != null) {
                sessionReference.clientDir = new File(prop);
            }
            if ((prop = args.getProperty("clientId")) != null) {
                sessionReference.clientId = prop;
            }
            Session session = SessionManagerSource.getSessionManager().createSession((SessionReference)sessionReference, agent);
            String noL0 = args.getProperty("noL0");
            if (noL0 != null) {
                return session;
            }
            if (args.containsKey("omitbuiltins") || args.containsKey("builtinInitializer")) {
                if (DEBUG.booleanValue()) {
                    System.out.println("omitbuiltins");
                }
            } else {
                ((XSupport)session.getService(XSupport.class)).setServiceMode(true, true);
                ReadRequest req = new ReadRequest(){

                    public void run(ReadGraph g) {
                        Layer0.getInstance((ReadGraph)g);
                    }
                };
                try {
                    session.syncRequest((Read)req);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                ((XSupport)session.getService(XSupport.class)).setServiceMode(false, false);
            }
            return session;
        }
        catch (IOException e) {
            throw new DatabaseException("Connect failed. address=" + serverReference.toString(), (Throwable)e);
        }
    }

    public ServerI getServer(File exeDir, File workDir) throws DatabaseException, ServerNotFoundException {
        return ProCoreServer.getProCoreServer(exeDir, workDir);
    }

    public void cloneDatabase(File workspaceDir, File serverDir) throws DatabaseException {
        if (!workspaceDir.exists()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " does not exist.");
        }
        if (!workspaceDir.isDirectory()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " is not a directory.");
        }
        if (!serverDir.exists()) {
            throw new DatabaseException("Source directory " + serverDir.getAbsolutePath() + " does not exist.");
        }
        if (!serverDir.isDirectory()) {
            throw new DatabaseException("Source directory " + serverDir.getAbsolutePath() + " is not a directory.");
        }
        File templateDir = Manager.getTemplateDirectory((File)workspaceDir);
        ProCoreDriver.copyDbFiles(templateDir, serverDir);
        File configFile = Manager.getConfigTemplate((File)workspaceDir);
        File toFile = new File(String.valueOf(serverDir.getAbsolutePath()) + File.separator + ProCoreConfigFile);
        try {
            toFile.createNewFile();
        }
        catch (IOException e) {
            throw new DatabaseException("Failed to create file " + toFile.getAbsolutePath(), (Throwable)e);
        }
        Properties properties = new Properties();
        Integer port = ProCoreDriver.getFreeEphemeralPort();
        String portS = "" + port;
        properties.put("common_port", portS);
        ProCoreDriver.createServerConfigFile(configFile, toFile, properties);
    }

    public static int getFreeEphemeralPort() {
        while (true) {
            int n;
            block8: {
                Socket s2 = null;
                try {
                    s2 = new Socket();
                    s2.bind(null);
                    n = s2.getLocalPort();
                    if (s2 == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (s2 != null) {
                            s2.close();
                        }
                        throw throwable;
                    }
                    catch (BindException s2) {
                        continue;
                    }
                    catch (Throwable e) {
                        throw new Error(e);
                    }
                }
                s2.close();
            }
            return n;
            break;
        }
    }

    public static void copyDbFiles(File fromDir, File toDir) throws DatabaseException {
        if (!fromDir.exists()) {
            throw new DatabaseException("Source directory " + fromDir.getAbsolutePath() + " does not exist.");
        }
        if (!fromDir.isDirectory()) {
            throw new DatabaseException("Source directory " + fromDir.getAbsolutePath() + " is not a directory.");
        }
        if (!toDir.exists()) {
            throw new DatabaseException("Target directory " + toDir.getAbsolutePath() + " does not exist.");
        }
        if (!toDir.isDirectory()) {
            throw new DatabaseException("Target directory " + toDir.getAbsolutePath() + " is not a directory.");
        }
        File[] toFiles = toDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".procore");
            }
        });
        if (toFiles.length > 0) {
            throw new DatabaseException("Target directory " + toDir.getAbsolutePath() + " already contains database files.");
        }
        File[] fromFiles = fromDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".procore");
            }
        });
        if (fromFiles.length == 0) {
            throw new DatabaseException("Source directory " + fromDir.getAbsolutePath() + " does not contain database files.");
        }
        File[] fileArray = fromFiles;
        int n = fromFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fromFile = fileArray[n2];
            File toFile = new File(String.valueOf(toDir.getPath()) + File.separator + fromFile.getName());
            if (toFile.exists()) {
                throw new DatabaseException("Target file " + toFile.getAbsolutePath() + " exist already.");
            }
            try {
                FileUtils.copyFile((File)fromFile, (File)toFile);
            }
            catch (IOException e) {
                throw new DatabaseException("Failed to copy file.", (Throwable)e);
            }
            ++n2;
        }
    }

    public static File createServerConfigFile(File toFolder) {
        File toFile = new File(toFolder, ProCoreConfigFile);
        if (!toFile.exists()) {
            String db = String.valueOf(Platform.getInstanceLocation().getURL().getFile()) + "db";
            File selfConfig = new File(db, ProCoreConfigFile);
            Properties properties = new Properties();
            try {
                FileReader fr = new FileReader(selfConfig);
                try {
                    properties.load(fr);
                    properties.put("common_port", "0");
                }
                finally {
                    fr.close();
                }
                FileOutputStream out = new FileOutputStream(toFile, true);
                try {
                    properties.store(out, "Automatically generated.");
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return toFile;
    }

    public static void createServerConfigFile(File templateFile, File toFile, Properties properties) throws DatabaseException {
        if (!templateFile.exists()) {
            throw new DatabaseException("Source file " + templateFile.getAbsolutePath() + " does not exist.");
        }
        if (!templateFile.isFile()) {
            throw new DatabaseException("Source file " + templateFile.getAbsolutePath() + " is not a file.");
        }
        if (!toFile.exists()) {
            throw new DatabaseException("Target file " + toFile.getAbsolutePath() + " does not exist.");
        }
        if (!toFile.isFile()) {
            throw new DatabaseException("Target file " + toFile.getAbsolutePath() + " is not a File.");
        }
        try {
            FileUtils.copyFile((File)templateFile, (File)toFile);
            if (properties != null && properties.size() > 0) {
                FileOutputStream out = new FileOutputStream(toFile, true);
                properties.store(out, "# automatically generated properties");
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new DatabaseException("Failed to save properties.", (Throwable)e);
        }
    }

    public void configLocalDatabase(File workspaceDir, File serverDir, ServerAddress address) throws DatabaseException {
        if (!workspaceDir.exists()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " does not exist.");
        }
        if (!workspaceDir.isDirectory()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " is not a directory.");
        }
        if (!serverDir.exists()) {
            throw new DatabaseException("Source directory " + serverDir.getAbsolutePath() + " does not exist.");
        }
        if (!serverDir.isDirectory()) {
            throw new DatabaseException("Source directory " + serverDir.getAbsolutePath() + " is not a directory.");
        }
        File configFile = Manager.getConfigTemplate((File)workspaceDir);
        File toFile = new File(String.valueOf(serverDir.getAbsolutePath()) + File.separator + ProCoreConfigFile);
        try {
            toFile.createNewFile();
        }
        catch (IOException e) {
            throw new DatabaseException("Failed to create file " + toFile.getAbsolutePath(), (Throwable)e);
        }
        Properties properties = new Properties();
        Integer port = ProCoreDriver.getFreeEphemeralPort();
        String portS = "" + port;
        properties.put("common_port", portS);
        if (address != null) {
            properties.put("parent_host", address.getAddress().getHostName());
            if (address.getDbid() != null) {
                properties.put("parent_proxy", address.getDbid());
            }
            portS = "" + address.getAddress().getPort();
            properties.put("parent_port", portS);
        }
        ProCoreDriver.createServerConfigFile(configFile, toFile, properties);
    }

    private boolean tryToDelete(File aFolder) {
        int i = 0;
        while (i < 10) {
            try {
                FileUtils.deleteAll((File)aFolder);
                return false;
            }
            catch (Throwable throwable) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return true;
    }

    public void removeDatabaseFiles(File dbDir) throws DatabaseException {
        if (!dbDir.exists()) {
            throw new DatabaseException("Database directory " + dbDir.getAbsolutePath() + " does not exist.");
        }
        if (!dbDir.isDirectory()) {
            throw new DatabaseException("Database directory " + dbDir.getAbsolutePath() + " is not a directory.");
        }
        try {
            ProCoreServer.stopProCoreServer(dbDir);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((String)"Problems with shutting down server.", (Throwable)e);
            return;
        }
        if (this.tryToDelete(dbDir)) {
            throw new DatabaseException("Problems removing database directory.");
        }
    }

    public void initDatabase(File wsDir, File serverDir, Properties props, File initFile) throws DatabaseException {
        if (DEBUG.booleanValue()) {
            System.out.println("Initializing local server in " + serverDir.getAbsolutePath());
        }
        if (!serverDir.exists()) {
            serverDir.mkdirs();
        } else {
            driver.removeDatabaseFiles(serverDir);
        }
        this.createDefaultConfigFile(wsDir, serverDir, props);
        File ucDir = Manager.getUndocoreDirectory((File)wsDir);
        ServerI server = driver.getServer(ucDir, serverDir);
        String host = props.getProperty("common_host");
        String port = props.getProperty("common_port");
        String dbid = props.getProperty("parent_proxy");
        this.initDatabase(server, host, Integer.parseInt(port), dbid, initFile);
        if (DEBUG.booleanValue()) {
            System.out.println("Finished initializing.");
        }
    }

    private void initDatabase(ServerI server, String host, int port, String dbid, File initFile) throws DatabaseException {
        if (!initFile.exists()) {
            throw new DatabaseException("Database initialization file " + initFile.getAbsolutePath() + " does not exist.");
        }
        if (!initFile.canRead()) {
            throw new DatabaseException("Database initialization file " + initFile.getAbsolutePath() + " is not readable.");
        }
        if (!initFile.isFile()) {
            throw new DatabaseException("Database initialization file " + initFile.getAbsolutePath() + " is not text file.");
        }
        server.start();
        try {
            try {
                if (DEBUG.booleanValue()) {
                    System.out.println("Generating builtins.");
                }
                ServerAddress serverReference = new ServerAddress(host, port, dbid);
                this.generateBuiltins(driver, server, serverReference, initFile);
                if (DEBUG.booleanValue()) {
                    System.out.println("Generating resources.");
                }
                TIntLongHashMap clus = new TIntLongHashMap();
                this.generateResources(driver, server, serverReference, initFile, clus);
            }
            catch (Exception e) {
                if (DEBUG.booleanValue()) {
                    e.printStackTrace();
                }
                throw new DatabaseException("Failed to initialize database.", (Throwable)e);
            }
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    public boolean deleteConfigFile(File dir) {
        File toFile = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + ProCoreConfigFile);
        return toFile.delete();
    }

    public File createDefaultConfigFile(File wsDir, File serverDir, Properties props) throws DatabaseException {
        File configFile = Manager.getConfigTemplate((File)wsDir);
        File toFile = new File(String.valueOf(serverDir.getAbsolutePath()) + File.separator + ProCoreConfigFile);
        try {
            toFile.createNewFile();
        }
        catch (IOException e) {
            throw new DatabaseException("Failed to create file " + toFile.getAbsolutePath(), (Throwable)e);
        }
        if (props.getProperty("common_host") == null) {
            props.put("common_host", "127.0.0.1");
        }
        if (props.getProperty("common_port") == null) {
            Integer port = ProCoreDriver.getFreeEphemeralPort();
            String portS = "" + port;
            props.put("common_port", portS);
        }
        ProCoreDriver.createServerConfigFile(configFile, toFile, props);
        return toFile;
    }

    private void generateBuiltins(Driver driver, ServerI server, ServerAddress address, File initFile) throws Exception {
        Properties proCoreProperties = new Properties();
        proCoreProperties.put("builtinInitializer", "true");
        ServiceLocator serviceLocator = driver.connect2(address, proCoreProperties);
        InitSupport is = (InitSupport)serviceLocator.getService(InitSupport.class);
        try {
            HashSet<InitSupport.Builtin> builtins = new HashSet<InitSupport.Builtin>();
            BufferedReader reader = new BufferedReader(new FileReader(initFile));
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                String token = tokenizer.nextToken();
                if (!"b".equals(token)) break;
                String uri = tokenizer.nextToken();
                int resource = Integer.parseInt(tokenizer.nextToken());
                int cluster = Integer.parseInt(tokenizer.nextToken());
                Builtin t = new Builtin(uri, resource, cluster);
                int index = t.getIndex();
                builtins.add(new InitSupport.Builtin(uri, index));
                line = reader.readLine();
            }
            reader.close();
            is.addBuiltins(builtins);
        }
        finally {
            is.close();
        }
    }

    private void generateResources(Driver driver, ServerI server, ServerAddress address, final File initFile, final TIntLongHashMap clus) throws DatabaseException {
        Properties proCoreProperties = new Properties();
        proCoreProperties.put("user", "default");
        proCoreProperties.put("password", "");
        proCoreProperties.put("omitbuiltins", "");
        final Session session = driver.connect(address, proCoreProperties);
        session.syncRequest((WriteOnly)new WriteOnlyRequest(){
            TIntObjectHashMap<Resource> res = new TIntObjectHashMap();

            private Resource getResource(WriteOnlyGraph graph, int id, int cluster) throws DatabaseException {
                Resource result = (Resource)this.res.get(id);
                if (result == null) {
                    long cc = clus.get(cluster);
                    result = cc == 0L ? this.newCluster(graph, cluster) : graph.newResource(cc);
                    this.res.put(id, (Object)result);
                }
                return result;
            }

            private Resource newCluster(WriteOnlyGraph graph, int cluster) throws DatabaseException {
                graph.flushCluster();
                Resource resource = graph.newResource();
                ClusteringSupport support = (ClusteringSupport)session.getService(ClusteringSupport.class);
                long result = support.getCluster(resource);
                clus.put(cluster, result);
                return resource;
            }

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                try {
                    String line;
                    int lineNr = 1;
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(initFile), "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        block31: {
                            StringTokenizer tokenizer = new StringTokenizer(line);
                            String token = tokenizer.nextToken();
                            if ("r".equals(token)) {
                                int sId = Integer.parseInt(tokenizer.nextToken());
                                int sc = Integer.parseInt(tokenizer.nextToken());
                                int pId = Integer.parseInt(tokenizer.nextToken());
                                int pc = Integer.parseInt(tokenizer.nextToken());
                                int oId = Integer.parseInt(tokenizer.nextToken());
                                int oc = Integer.parseInt(tokenizer.nextToken());
                                Resource s = this.getResource(graph, sId, sc);
                                Resource p = this.getResource(graph, pId, pc);
                                Resource o = this.getResource(graph, oId, oc);
                                graph.claim(s, p, null, o);
                                if (tokenizer.hasMoreTokens()) {
                                    String v = tokenizer.nextToken();
                                    try {
                                        if (v.startsWith("[")) {
                                            if ("[s".equals(v)) {
                                                graph.claimValue(s, (Object)PrimitiveParsers.parseStringArray(tokenizer), Bindings.getBindingUnchecked(String[].class));
                                            } else if ("[b".equals(v)) {
                                                graph.claimValue(s, (Object)PrimitiveParsers.parseBooleanArray(tokenizer), (Binding)Bindings.BOOLEAN);
                                            } else if ("[c".equals(v)) {
                                                graph.claimValue(s, (Object)PrimitiveParsers.parseByteArray(tokenizer), (Binding)Bindings.BYTE_ARRAY);
                                            } else if ("[i".equals(v)) {
                                                graph.claimValue(s, (Object)PrimitiveParsers.parseIntegerArray(tokenizer), (Binding)Bindings.INT_ARRAY);
                                            } else if ("[l".equals(v)) {
                                                graph.claimValue(s, (Object)PrimitiveParsers.parseLongArray(tokenizer), (Binding)Bindings.LONG_ARRAY);
                                            } else if ("[d".equals(v)) {
                                                graph.claimValue(s, (Object)PrimitiveParsers.parseDoubleArray(tokenizer), (Binding)Bindings.DOUBLE_ARRAY);
                                            } else if ("[f".equals(v)) {
                                                graph.claimValue(s, (Object)PrimitiveParsers.parseFloatArray(tokenizer), (Binding)Bindings.FLOAT_ARRAY);
                                            } else {
                                                System.out.println("line " + lineNr + ": unrecognized primitive value tag: " + v);
                                            }
                                            break block31;
                                        }
                                        if ("s".equals(v)) {
                                            graph.claimValue(s, (Object)PrimitiveParsers.parseString(tokenizer), (Binding)Bindings.STRING);
                                            break block31;
                                        }
                                        if ("b".equals(v)) {
                                            graph.claimValue(s, (Object)PrimitiveParsers.parseSingleBoolean(tokenizer), (Binding)Bindings.BOOLEAN);
                                            break block31;
                                        }
                                        if ("c".equals(v)) {
                                            graph.claimValue(s, (Object)PrimitiveParsers.parseSingleByte(tokenizer), (Binding)Bindings.BYTE);
                                            break block31;
                                        }
                                        if ("i".equals(v)) {
                                            graph.claimValue(s, (Object)PrimitiveParsers.parseSingleInteger(tokenizer), (Binding)Bindings.INTEGER);
                                            break block31;
                                        }
                                        if ("l".equals(v)) {
                                            graph.claimValue(s, (Object)PrimitiveParsers.parseSingleLong(tokenizer), (Binding)Bindings.LONG);
                                            break block31;
                                        }
                                        if ("d".equals(v)) {
                                            graph.claimValue(s, (Object)PrimitiveParsers.parseSingleDouble(tokenizer), (Binding)Bindings.DOUBLE);
                                            break block31;
                                        }
                                        if ("f".equals(v)) {
                                            graph.claimValue(s, (Object)Float.valueOf(PrimitiveParsers.parseSingleFloat(tokenizer)), (Binding)Bindings.FLOAT);
                                            break block31;
                                        }
                                        System.out.println("line " + lineNr + ": unrecognized primitive value tag: " + v);
                                    }
                                    catch (IllegalArgumentException e) {
                                        System.out.println("line " + lineNr + ": " + e.getMessage());
                                    }
                                }
                            } else if ("b".equals(token)) {
                                String uri = tokenizer.nextToken();
                                int resource = Integer.parseInt(tokenizer.nextToken());
                                Resource r = graph.getBuiltin(uri);
                                this.res.put(resource, (Object)r);
                            }
                        }
                        ++lineNr;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        LifecycleSupport ls = (LifecycleSupport)session.getService(LifecycleSupport.class);
        ls.close();
    }

    class Builtin {
        String uri;
        int resource;
        int cluster;
        int index;

        Builtin(String uri, int resource, int cluster) {
            this.uri = uri;
            this.resource = resource;
            this.cluster = cluster;
            if (instanceOf.equals(uri)) {
                this.index = 1;
            } else if (inherits.equals(uri)) {
                this.index = 2;
            } else if (subrelationOf.equals(uri)) {
                this.index = 3;
            } else {
                ProCoreDriver proCoreDriver2 = ProCoreDriver.this;
                int n = proCoreDriver2.lastUsedIndex + 1;
                proCoreDriver2.lastUsedIndex = n;
                this.index = n;
            }
        }

        int getIndex() {
            return this.index;
        }
    }
}

