/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore;

import gnu.trove.TByteArrayList;
import gnu.trove.TDoubleArrayList;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public final class PrimitiveParsers {
    public static final String parseString(StringTokenizer t) {
        String rest = t.nextToken("\n");
        return rest.substring(1);
    }

    public static final String[] parseStringArray(StringTokenizer t) {
        throw new UnsupportedOperationException("StringArray parsing not supported");
    }

    public static final Boolean parseBoolean(StringTokenizer t) {
        String value = t.nextToken();
        if ("true".equals(value) || "True".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value) || "False".equals(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("invalid boolean value '" + value + "'");
    }

    public static final Boolean parseSingleBoolean(StringTokenizer t) {
        Boolean b = PrimitiveParsers.parseBoolean(t);
        if (t.hasMoreElements()) {
            throw new IllegalArgumentException();
        }
        return b;
    }

    public static final boolean[] parseBooleanArray(StringTokenizer t) {
        boolean[] result = new boolean[4];
        int count = 0;
        while (t.hasMoreElements()) {
            Boolean value = PrimitiveParsers.parseBoolean(t);
            if (result.length == count) {
                result = Arrays.copyOf(result, result.length * 2);
            }
            result[count++] = value;
        }
        return Arrays.copyOf(result, count);
    }

    public static final Byte parseByte(StringTokenizer t) {
        return Byte.parseByte(t.nextToken());
    }

    public static final Byte parseSingleByte(StringTokenizer t) {
        Byte b = PrimitiveParsers.parseByte(t);
        if (t.hasMoreElements()) {
            throw new IllegalArgumentException();
        }
        return b;
    }

    public static final byte[] parseByteArray(StringTokenizer t) {
        TByteArrayList result = new TByteArrayList();
        while (t.hasMoreElements()) {
            result.add(PrimitiveParsers.parseByte(t).byteValue());
        }
        return result.toNativeArray();
    }

    public static final int parseInteger(StringTokenizer tokenizer) {
        return Integer.parseInt(tokenizer.nextToken());
    }

    public static final int parseSingleInteger(StringTokenizer t) {
        int i = PrimitiveParsers.parseInteger(t);
        if (t.hasMoreElements()) {
            throw new IllegalArgumentException();
        }
        return i;
    }

    public static final int[] parseIntegerArray(StringTokenizer t) {
        TIntArrayList result = new TIntArrayList();
        while (t.hasMoreElements()) {
            result.add(PrimitiveParsers.parseInteger(t));
        }
        return result.toNativeArray();
    }

    public static final long parseLong(StringTokenizer tokenizer) {
        return Long.parseLong(tokenizer.nextToken());
    }

    public static final long parseSingleLong(StringTokenizer t) {
        long l = PrimitiveParsers.parseLong(t);
        if (t.hasMoreElements()) {
            throw new IllegalArgumentException();
        }
        return l;
    }

    public static final long[] parseLongArray(StringTokenizer t) {
        TLongArrayList result = new TLongArrayList();
        while (t.hasMoreElements()) {
            result.add(PrimitiveParsers.parseLong(t));
        }
        return result.toNativeArray();
    }

    public static final float parseFloat(StringTokenizer tokenizer) {
        return Float.parseFloat(tokenizer.nextToken());
    }

    public static final float parseSingleFloat(StringTokenizer t) {
        float f = PrimitiveParsers.parseFloat(t);
        if (t.hasMoreElements()) {
            throw new IllegalArgumentException();
        }
        return f;
    }

    public static final float[] parseFloatArray(StringTokenizer t) {
        TFloatArrayList result = new TFloatArrayList();
        while (t.hasMoreElements()) {
            result.add(PrimitiveParsers.parseFloat(t));
        }
        return result.toNativeArray();
    }

    public static final double parseDouble(StringTokenizer tokenizer) {
        return Double.parseDouble(tokenizer.nextToken());
    }

    public static final double parseSingleDouble(StringTokenizer t) {
        double d = PrimitiveParsers.parseDouble(t);
        if (t.hasMoreElements()) {
            throw new IllegalArgumentException();
        }
        return d;
    }

    public static final double[] parseDoubleArray(StringTokenizer t) {
        TDoubleArrayList result = new TDoubleArrayList();
        while (t.hasMoreElements()) {
            result.add(PrimitiveParsers.parseDouble(t));
        }
        return result.toNativeArray();
    }
}

