/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore;

import fi.vtt.simantics.procore.ProCoreServer;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;

public class CorruptWatcher
implements Runnable {
    private static final int SLEEP_MS = 3000;
    private final boolean DEBUG = false;
    private static long count = 0L;
    private final File file;
    private final Thread thread;
    private boolean stop = false;
    private ProCoreServer server;
    private final boolean showDialog;

    CorruptWatcher(File dir, File file, ProCoreServer server, boolean showDialog) throws DatabaseException {
        this.file = file;
        this.thread = new Thread((Runnable)this, "CorruptWatcher " + ++count + " " + dir.getAbsolutePath());
        this.thread.start();
        this.server = server;
        this.showDialog = showDialog;
    }

    void stop() {
        this.stop = true;
        if (this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join(6000L);
            }
            catch (InterruptedException e) {
                Logger.getDefault().logInfo("CorruptWatcher: interrupted during join.", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        int lines = this.logNewLines(this.file, 0, false, true);
        while (!this.stop) {
            try {
                this.server.isActive();
                lines = this.logNewLines(this.file, lines, true, this.showDialog);
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    int logNewLines(File file, int lines, boolean log, boolean noDialog) {
        int count;
        StringBuilder sb;
        BufferedReader br;
        InputStreamReader isr;
        FileInputStream fis;
        block13: {
            block12: {
                fis = null;
                isr = null;
                br = null;
                sb = new StringBuilder();
                if (file.exists()) break block12;
                this.close(br);
                this.close(isr);
                this.close(fis);
                return 0;
            }
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                this.close(br);
                this.close(isr);
                this.close(fis);
                return 0;
            }
            isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            br = new BufferedReader(isr);
            String line = null;
            count = 0;
            while ((line = br.readLine()) != null) {
                if (!log || ++count <= lines) continue;
                sb.append(line);
                sb.append("\n");
            }
            if (log) break block13;
            int n = count;
            this.close(br);
            this.close(isr);
            this.close(fis);
            return n;
        }
        try {
            try {
                lines = count;
            }
            catch (Exception line) {
                this.close(br);
                this.close(isr);
                this.close(fis);
            }
        }
        catch (Throwable throwable) {
            this.close(br);
            this.close(isr);
            this.close(fis);
            throw throwable;
        }
        this.close(br);
        this.close(isr);
        this.close(fis);
        String s = sb.toString();
        if (s != null && !s.contentEquals("")) {
            Logger.defaultLogError((String)s, (Throwable)new Exception("CorruptWatcher: server log file has changed."));
            if (noDialog && !GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, s);
            }
        }
        return lines;
    }

    void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

