/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.service;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ResourceUID;

public final class ClusterUID {
    public static final ClusterUID Null = new ClusterUID(0L, 0L);
    public static final ClusterUID Reserved = new ClusterUID(0L, 1L);
    public static final ClusterUID Builtin = new ClusterUID(0L, 2L);
    public final long first;
    public final long second;
    private static transient long firstCache1 = 0L;
    private static transient long firstCache2 = 0L;
    private static transient long secondCache1 = 0L;
    private static transient long secondCache2 = 0L;
    private static transient ClusterUID clusterCache1 = null;
    private static transient ClusterUID clusterCache2 = null;

    public static boolean isLegal(ClusterUID clusterUID) {
        return !clusterUID.equals(Null) && !clusterUID.equals(Reserved);
    }

    public ClusterUID() {
        this.first = 0L;
        this.second = 0L;
    }

    public ClusterUID(long first, long second) {
        this.first = first;
        this.second = second;
    }

    public static ClusterUID make(long first, long second) {
        if (first == firstCache1 && second == secondCache1) {
            return clusterCache1;
        }
        if (first == firstCache2 && second == secondCache2) {
            return clusterCache2;
        }
        ClusterUID result = new ClusterUID(first, second);
        firstCache2 = firstCache1;
        secondCache2 = secondCache1;
        clusterCache2 = clusterCache1;
        firstCache1 = first;
        secondCache1 = second;
        clusterCache1 = result;
        return result;
    }

    public static ClusterUID make(byte[] bytes, int offset) {
        if (bytes.length < offset + 16) {
            throw new IllegalArgumentException("Too few bytes for ClusteUID. length=" + bytes.length + " offset=" + offset);
        }
        ByteBuffer bf = ByteBuffer.wrap(bytes, offset, 16);
        bf.order(ByteOrder.LITTLE_ENDIAN);
        return ClusterUID.make(bf.getLong(), bf.getLong());
    }

    public String toString() {
        return String.format("%x.%x", this.first, this.second);
    }

    public static int getLongLength() {
        return 2;
    }

    public static ClusterUID makeRandom() {
        UUID id = UUID.randomUUID();
        return new ClusterUID(id.getMostSignificantBits(), id.getLeastSignificantBits());
    }

    public int toByte(byte[] bytes, int offset) {
        Bytes.writeLE(bytes, offset + 0, this.first);
        Bytes.writeLE(bytes, offset + 8, this.second);
        return offset + 16;
    }

    public int toLong(long[] longs, int offset) {
        longs[offset++] = this.first;
        longs[offset++] = this.second;
        return offset;
    }

    public byte[] asBytes() {
        byte[] bytes = new byte[16];
        this.toByte(bytes, 0);
        return bytes;
    }

    public ResourceUID toRID(int resourceIndex) {
        return new ResourceUID(this.first, this.second, resourceIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterUID)) {
            return false;
        }
        ClusterUID x = (ClusterUID)o;
        return this.first == x.first && this.second == x.second;
    }

    public int hashCode() {
        int result = 17;
        int f = (int)(this.first ^ this.first >>> 32);
        result = 31 * result + f;
        int s = (int)(this.second ^ this.second >>> 32);
        result = 31 * result + s;
        return result;
    }
}

