/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.service;

public final class Bytes {
    public static final void write(byte[] bytes, int index, byte value) {
        bytes[index] = value;
    }

    public static final void writeLE(byte[] bytes, int index, long value) {
        bytes[index++] = (byte)(value & 0xFFL);
        bytes[index++] = (byte)(value >>> 8 & 0xFFL);
        bytes[index++] = (byte)(value >>> 16 & 0xFFL);
        bytes[index++] = (byte)(value >>> 24 & 0xFFL);
        bytes[index++] = (byte)(value >>> 32 & 0xFFL);
        bytes[index++] = (byte)(value >>> 40 & 0xFFL);
        bytes[index++] = (byte)(value >>> 48 & 0xFFL);
        bytes[index++] = (byte)(value >>> 56 & 0xFFL);
    }

    public static final void writeLE6(byte[] bytes, int index, long value) {
        bytes[index++] = (byte)(value & 0xFFL);
        bytes[index++] = (byte)(value >>> 8 & 0xFFL);
        bytes[index++] = (byte)(value >>> 16 & 0xFFL);
        bytes[index++] = (byte)(value >>> 24 & 0xFFL);
        bytes[index++] = (byte)(value >>> 32 & 0xFFL);
        bytes[index++] = (byte)(value >>> 40 & 0xFFL);
    }

    public static final void writeLE7(byte[] bytes, int index, long value) {
        bytes[index++] = (byte)(value & 0xFFL);
        bytes[index++] = (byte)(value >>> 8 & 0xFFL);
        bytes[index++] = (byte)(value >>> 16 & 0xFFL);
        bytes[index++] = (byte)(value >>> 24 & 0xFFL);
        bytes[index++] = (byte)(value >>> 32 & 0xFFL);
        bytes[index++] = (byte)(value >>> 40 & 0xFFL);
        bytes[index++] = (byte)(value >>> 48 & 0xFFL);
    }

    public static final void writeLE(byte[] bytes, int index, int value) {
        bytes[index++] = (byte)(value & 0xFF);
        bytes[index++] = (byte)(value >>> 8 & 0xFF);
        bytes[index++] = (byte)(value >>> 16 & 0xFF);
        bytes[index++] = (byte)(value >>> 24 & 0xFF);
    }

    public static final void writeLE(byte[] bytes, int index, short value) {
        bytes[index++] = (byte)(value & 0xFF);
        bytes[index++] = (byte)(value >>> 8 & 0xFF);
    }

    public static final byte read(byte[] bytes, int byteIndex) {
        return bytes[byteIndex++];
    }

    public static final short readLE2(byte[] bytes, int byteIndex) {
        short result = (short)((short)(bytes[byteIndex++] & 0xFF) | (short)(bytes[byteIndex++] & 0xFF) << 8);
        return result;
    }

    public static final int readLE4(byte[] bytes, int byteIndex) {
        int result = bytes[byteIndex++] & 0xFF | (bytes[byteIndex++] & 0xFF) << 8 | (bytes[byteIndex++] & 0xFF) << 16 | (bytes[byteIndex++] & 0xFF) << 24;
        return result;
    }

    public static final long readLE8(byte[] bytes, int byteIndex) {
        long result = (long)(bytes[byteIndex++] & 0xFF) | (long)(bytes[byteIndex++] & 0xFF) << 8 | (long)(bytes[byteIndex++] & 0xFF) << 16 | (long)(bytes[byteIndex++] & 0xFF) << 24 | (long)(bytes[byteIndex++] & 0xFF) << 32 | (long)(bytes[byteIndex++] & 0xFF) << 40 | (long)(bytes[byteIndex++] & 0xFF) << 48 | (long)(bytes[byteIndex++] & 0xFF) << 56;
        return result;
    }
}

