/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db;

import java.net.InetSocketAddress;

public class ServerAddress {
    private InetSocketAddress socketAddress;
    private String dbid;

    public ServerAddress(String hostAndPort, String dbid) {
        this(hostAndPort);
        this.dbid = dbid;
    }

    public ServerAddress(String hostAndPort) {
        assert (hostAndPort != null);
        String[] split = hostAndPort.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("address does not contain a port, missing ':' character");
        }
        this.socketAddress = InetSocketAddress.createUnresolved(split[0], Integer.parseInt(split[1]));
        this.dbid = null;
    }

    public ServerAddress(String host, int port) {
        assert (host != null);
        this.socketAddress = new InetSocketAddress(host, port);
        this.dbid = null;
    }

    public ServerAddress(String host, int port, String dbid) {
        assert (host != null);
        this.socketAddress = InetSocketAddress.createUnresolved(host, port);
        this.dbid = dbid;
    }

    public ServerAddress(InetSocketAddress socketAddress) {
        assert (socketAddress != null);
        this.socketAddress = socketAddress;
        this.dbid = null;
    }

    public ServerAddress(InetSocketAddress socketAddress, String dbid) {
        assert (socketAddress != null);
        this.socketAddress = socketAddress;
        this.dbid = dbid;
    }

    public InetSocketAddress getAddress() {
        return this.socketAddress;
    }

    public String getDbid() {
        return this.dbid;
    }

    public int hashCode() {
        return this.socketAddress.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        ServerAddress r = (ServerAddress)other;
        return r.socketAddress.equals(this.socketAddress) && (r.dbid != null && r.dbid.equals(this.dbid) || r.dbid == null && this.dbid == null);
    }

    public String toString() {
        if (this.dbid != null) {
            return String.valueOf(this.socketAddress.toString()) + " / " + this.dbid;
        }
        return this.socketAddress.toString();
    }
}

