/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.simantics.db.Driver;
import org.simantics.db.ServerAddress;
import org.simantics.db.ServerI;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;

public class Manager {
    private static HashMap<String, Driver> drivers = new HashMap();
    private static final String BUILD_DIRECTORY_PREFIX = "org.simantics.db.build";
    private static final String DB_CONFIG_TEMPLATE = "template.cnfg";
    private static final String DB_TEMPLATE_DIR = "template";

    public static Driver getDriver(String id) {
        return drivers.get(id);
    }

    public static void registerDriver(String id, Driver driver) {
        drivers.put(id, driver);
    }

    public static Session getSession(String driverName, ServerAddress address, String user, String password) throws DatabaseException {
        Driver driver = Manager.getDriver(driverName);
        Properties info = new Properties();
        if (user != null) {
            info.put("user", user);
        }
        if (password != null) {
            info.put("password", password);
        }
        return driver.connect(address, info);
    }

    public static Session getSession(String driverName, ServerAddress address, String user, String password, String clientDir, String clientId) throws DatabaseException {
        Driver driver = Manager.getDriver(driverName);
        Properties info = new Properties();
        if (user != null) {
            info.put("user", user);
        }
        if (password != null) {
            info.put("password", password);
        }
        if (clientDir != null) {
            info.put("clientDir", clientDir);
        }
        if (clientId != null) {
            info.put("clientId", clientId);
        }
        return driver.connect(address, info);
    }

    public static File getUndocoreDirectoryByWorkspaceDirectory(File workspace) throws DatabaseException {
        String prefix = BUILD_DIRECTORY_PREFIX;
        String suffix = Manager.calculateSuffix();
        String name = workspace + "/" + prefix + "/" + suffix;
        File ucDir = new File(name);
        if (!ucDir.isDirectory()) {
            String wd = new File(".").getAbsolutePath();
            throw new DatabaseException("No undocore directory for " + name + " current directory=" + wd + ".");
        }
        return ucDir;
    }

    public static File getUndocoreDirectory(File applicationLocation) throws DatabaseException {
        String suffix = Manager.calculateSuffix();
        String name = applicationLocation + File.separator + suffix;
        File ucDir = new File(name);
        if (!ucDir.isDirectory()) {
            String wd = new File(".").getAbsolutePath();
            throw new DatabaseException("No undocore directory for " + name + " current directory=" + wd + ".");
        }
        return ucDir;
    }

    public static File getTemplateDirectory(File workspace) throws DatabaseException {
        File ucDir = Manager.getUndocoreDirectory(workspace);
        String name = String.valueOf(ucDir.getAbsolutePath()) + File.separator + DB_TEMPLATE_DIR;
        File tDir = new File(name);
        if (!tDir.isDirectory()) {
            throw new DatabaseException("No template directory for " + name);
        }
        return tDir;
    }

    public static File getConfigTemplate(File workspace) throws DatabaseException {
        String name = workspace + File.separator + File.separator + DB_CONFIG_TEMPLATE;
        File tFile = new File(name);
        if (!tFile.isFile() || !tFile.exists()) {
            throw new DatabaseException("No template file '" + tFile.getAbsolutePath() + "'");
        }
        return tFile;
    }

    private static String calculateSuffix() throws DatabaseException {
        String osArch = System.getProperty("os.arch").toLowerCase();
        String osName = System.getProperty("os.name").toLowerCase();
        if (Manager.is64BitOS()) {
            if (osName.startsWith("windows")) {
                return "win32.x86_64";
            }
            if (osName.startsWith("linux")) {
                return "linux.x86_64";
            }
        } else if (osArch.equals("i386") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("x86")) {
            if (osName.startsWith("windows")) {
                return "win32.x86";
            }
            if (osName.startsWith("linux")) {
                return "linux.x86";
            }
        }
        throw new DatabaseException("Unsupported architecture " + osArch + " and/or operating system " + osName);
    }

    private static boolean is64BitOS() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            return System.getenv("ProgramFiles(x86)") != null;
        }
        return System.getProperty("os.arch").indexOf("64") != -1;
    }

    public static ServerI cloneDatabase(Driver driver, String workspaceDirN, String serverDirN) throws DatabaseException {
        File workspaceDir = new File(workspaceDirN);
        if (!workspaceDir.exists()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " does not exist.");
        }
        if (!workspaceDir.isDirectory()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " is not a directory.");
        }
        File serverDir = new File(serverDirN);
        if (!serverDir.exists()) {
            serverDir.mkdirs();
        } else {
            driver.removeDatabaseFiles(serverDir);
        }
        driver.cloneDatabase(workspaceDir, serverDir);
        File ucDir = Manager.getUndocoreDirectory(workspaceDir);
        return driver.getServer(ucDir, serverDir);
    }

    public static ServerI checkout(Driver driver, String workspaceDirN, String serverDirN, ServerAddress server) throws DatabaseException {
        File workspaceDir = new File(workspaceDirN);
        if (!workspaceDir.exists()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " does not exist.");
        }
        if (!workspaceDir.isDirectory()) {
            throw new DatabaseException("Workspace directory " + workspaceDir.getAbsolutePath() + " is not a directory.");
        }
        File serverDir = new File(serverDirN);
        if (!serverDir.exists()) {
            serverDir.mkdirs();
        } else {
            driver.removeDatabaseFiles(serverDir);
        }
        driver.configLocalDatabase(workspaceDir, serverDir, server);
        File ucDir = Manager.getUndocoreDirectory(workspaceDir);
        return driver.getServer(ucDir, serverDir);
    }
}

