/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.event.view.handler.CorrectMilestoneLabelsAction;

public class TagAction
extends Action {
    private final String virtualGraphId;
    private final String tagURI;
    private final boolean tag;
    private final List<Resource> resources;

    public TagAction(String label, ImageDescriptor image, String virtualGraphId, String tagURI, boolean tag, List<Resource> input) {
        super(label, image);
        this.virtualGraphId = virtualGraphId;
        this.tagURI = tagURI;
        this.tag = tag;
        this.resources = input;
    }

    public void run() {
        Session session = Simantics.peekSession();
        if (session == null) {
            return;
        }
        final VirtualGraph vg = this.virtualGraphId == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(this.virtualGraphId);
        session.asyncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                Resource tr = graph.getResource(TagAction.this.tagURI);
                for (Resource r : TagAction.this.resources) {
                    if (TagAction.this.tag) {
                        graph.claim(r, tr, tr, r);
                        continue;
                    }
                    graph.deny(r, tr, r);
                }
                if (TagAction.this.tagURI.equals("http://www.simantics.org/Event-1.2/Milestone")) {
                    CorrectMilestoneLabelsAction.correctMilestoneLabels(graph, vg, TagAction.this.resources);
                }
            }
        });
    }
}

