/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.AsyncRead;
import org.simantics.event.Activator;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.handler.ClaimAction;
import org.simantics.event.view.handler.CorrectMilestoneLabelsAction;
import org.simantics.event.view.handler.DenyAction;
import org.simantics.event.view.handler.TagAction;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.workbench.action.PerformDefaultAction;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class MenuActions
extends DynamicMenuContribution {
    protected Object[] getSelectedObjects() {
        ISelection sel = this.getSelection();
        List resources = ISelectionUtils.getPossibleKeys((Object)sel, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        return resources.toArray();
    }

    List<Resource> toResources(Object[] array) {
        Resource[] a = new Resource[array.length];
        int i = 0;
        while (i < array.length) {
            a[i] = (Resource)array[i];
            ++i;
        }
        return Arrays.asList(a);
    }

    protected IAction[] getActions(ReadGraph graph, Object[] selection) throws DatabaseException {
        Resource eventSource;
        Resource event;
        Resource eventLog;
        if (selection.length == 0) {
            return new IAction[0];
        }
        List<Resource> input = this.toResources(selection);
        boolean logs = false;
        boolean events = false;
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        int hiddenCount = 0;
        int milestoneCount = 0;
        int hasSourceCount = 0;
        for (Resource r : input) {
            logs |= graph.isInstanceOf(r, EVENT.EventLog);
            events |= graph.isInstanceOf(r, EVENT.Event);
            if (graph.hasStatement(r, EVENT.Hidden)) {
                ++hiddenCount;
            }
            if (graph.hasStatement(r, EVENT.Milestone)) {
                ++milestoneCount;
            }
            if (!graph.hasStatement(r, EVENT.Event_source)) continue;
            ++hasSourceCount;
        }
        boolean allHidden = hiddenCount == selection.length;
        boolean allMilestones = milestoneCount == selection.length;
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (!allHidden) {
            actions.add(this.hideAction(input));
        }
        if (hiddenCount > 0 || allHidden) {
            actions.add(this.unhideAction(input));
        }
        if (!logs && !allMilestones) {
            actions.add(this.markMilestoneAction(input));
        }
        if (!logs && (milestoneCount > 0 || allMilestones)) {
            actions.add(this.unmarkMilestoneAction(input));
        }
        if (!logs && events && input.size() == 1 && (eventLog = (Resource)graph.syncRequest((AsyncRead)new PossibleTypedParent(event = input.get(0), EVENT.EventLog))) != null) {
            boolean isBaseline = graph.hasStatement(eventLog, EVENT.EventLog_HasBaselineEvent, event);
            if (isBaseline) {
                actions.add(this.removeBaseline(Collections.singletonList(eventLog)));
            } else {
                actions.add(this.setBaseline(eventLog, event));
            }
        }
        if (logs && !events) {
            actions.add(this.removeBaseline(input));
        }
        if (input.size() == 1 && hasSourceCount == 1 && (eventSource = graph.getPossibleObject(event = input.get(0), EVENT.Event_source)) != null) {
            actions.add(this.performDefaultAction(eventSource));
        }
        return actions.toArray(new IAction[actions.size()]);
    }

    private IAction markMilestoneAction(List<Resource> input) {
        return this.tagAction("Mark as Milestone", Activator.MARK_MILESTONE_ICON, "http://www.simantics.org/Event-1.2/Milestone", true, input);
    }

    private IAction unmarkMilestoneAction(List<Resource> input) {
        return this.tagAction("Unmark Milestone", Activator.UNMARK_MILESTONE_ICON, "http://www.simantics.org/Event-1.2/Milestone", false, input);
    }

    private IAction unhideAction(List<Resource> input) {
        return this.tagAction("Unhide", Activator.UNHIDE_ICON, "http://www.simantics.org/Event-1.2/Hidden", false, input);
    }

    private IAction hideAction(List<Resource> input) {
        return this.tagAction("Hide", Activator.HIDE_ICON, "http://www.simantics.org/Event-1.2/Hidden", true, input);
    }

    private IAction tagAction(String label, ImageDescriptor image, String tagURI, boolean tag, List<Resource> input) {
        return new TagAction(label, image, "experiments", tagURI, tag, input);
    }

    private IAction setBaseline(Resource eventLog, Resource event) {
        return new SetBaseline("experiments", eventLog, event);
    }

    private IAction removeBaseline(List<Resource> logs) {
        return new DenyAction("Remove Baseline", Activator.REMOVE_BASELINE_ICON, "experiments", "http://www.simantics.org/Event-1.2/EventLog/HasBaselineEvent", logs);
    }

    private IAction performDefaultAction(Resource input) {
        return new PerformDefaultAction("Show Event Source", null, input);
    }

    private static class SetBaseline
    extends ClaimAction {
        public SetBaseline(String virtualGraphId, Resource subject, Resource object) {
            super("Set Baseline", Activator.SET_BASELINE_ICON, virtualGraphId, subject, "http://www.simantics.org/Event-1.2/EventLog/HasBaselineEvent", object);
        }

        @Override
        public void claim(WriteGraph graph) throws DatabaseException {
            super.claim(graph);
            EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
            if (!graph.hasStatement(this.object, EVENT.Milestone)) {
                graph.claim(this.object, EVENT.Milestone, this.object);
                CorrectMilestoneLabelsAction.correctMilestoneLabels(graph, graph.getProvider(), Collections.singleton(this.object));
            }
        }
    }
}

