/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventResource;
import org.simantics.layer0.Layer0;

public class GetEventLogsQuery
extends UniqueRead<Collection<Resource>> {
    Collection<Resource> events;

    public GetEventLogsQuery(Collection<Resource> events) {
        this.events = events;
    }

    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> eventlogs = new ArrayList<Resource>(1);
        for (Resource event : this.events) {
            Resource eventlog = graph.getPossibleObject(event, L0.PartOf);
            if (eventlog == null || !graph.isInstanceOf(eventlog, EVENT.EventLog) || eventlogs.contains(event)) continue;
            eventlogs.add(eventlog);
        }
        return eventlogs;
    }
}

