/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.handler.GetEventLogsQuery;
import org.simantics.event.view.handler.MilestoneList;
import org.simantics.event.view.handler.MilestoneListQuery;

public class CorrectMilestoneLabelsAction
extends WriteRequest {
    Resource eventlog;

    public CorrectMilestoneLabelsAction(Resource eventlog, VirtualGraph vg) {
        super(vg);
        this.eventlog = eventlog;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        MilestoneList ml = (MilestoneList)((Object)graph.sync((ReadInterface)new MilestoneListQuery(this.eventlog)));
        System.out.println("Setting labels");
        if (!ml.milestones.isEmpty()) {
            int i = 0;
            while (i < ml.milestones.size()) {
                String lbl = Integer.toString(i + 1);
                Resource milestone = ml.milestones.get(i);
                graph.claimLiteral(milestone, EVENT.Event_milestoneLabel, (Object)lbl, (Binding)Bindings.STRING);
                System.out.println("Setting " + milestone + " to " + lbl);
                ++i;
            }
        }
    }

    public static void correctMilestoneLabels(WriteGraph graph, VirtualGraph vg, Collection<Resource> events) throws DatabaseException {
        Collection eventlogs = (Collection)graph.sync((ReadInterface)new GetEventLogsQuery(events));
        for (Resource eventlog : eventlogs) {
            graph.syncRequest((Write)new CorrectMilestoneLabelsAction(eventlog, vg));
        }
    }
}

